/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.config;

import java.lang.reflect.Field;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.ComponentRegistrar;
import org.springframework.beans.factory.parsing.ComponentRegistrarAdapter;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.config.FeatureSpecification;
import org.springframework.context.config.SourceAwareSpecification;
import org.springframework.context.config.SpecificationContext;
import org.springframework.core.env.DefaultEnvironment;
import org.springframework.core.env.Environment;
import org.w3c.dom.Element;

public abstract class AbstractSpecificationBeanDefinitionParser
implements BeanDefinitionParser {
    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        FeatureSpecification spec = this.doParse(element, parserContext);
        if (spec instanceof SourceAwareSpecification) {
            ((SourceAwareSpecification)spec).source(parserContext.getReaderContext().extractSource((Object)element));
            ((SourceAwareSpecification)spec).sourceName(element.getTagName());
        }
        spec.execute(this.specificationContextFrom(parserContext));
        return null;
    }

    protected abstract FeatureSpecification doParse(Element var1, ParserContext var2);

    private SpecificationContext specificationContextFrom(ParserContext parserContext) {
        SpecificationContext specContext = new SpecificationContext();
        specContext.setRegistry(parserContext.getRegistry());
        specContext.setRegistrar((ComponentRegistrar)new ComponentRegistrarAdapter(parserContext));
        specContext.setResourceLoader(parserContext.getReaderContext().getResourceLoader());
        try {
            specContext.setEnvironment(parserContext.getDelegate().getEnvironment());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            specContext.setEnvironment((Environment)new DefaultEnvironment());
        }
        try {
            Field field = ReaderContext.class.getDeclaredField("problemReporter");
            field.setAccessible(true);
            ProblemReporter problemReporter = (ProblemReporter)field.get(parserContext.getReaderContext());
            specContext.setProblemReporter(problemReporter);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not access field 'ReaderContext#problemReporter' on object " + parserContext.getReaderContext(), ex);
        }
        return specContext;
    }
}

