/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.castor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;
import org.exolab.castor.xml.XMLException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.ValidationFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.castor.CastorMappingException;
import org.springframework.oxm.support.AbstractMarshaller;
import org.springframework.oxm.support.SaxResourceUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastorMarshaller
extends AbstractMarshaller
implements InitializingBean,
BeanClassLoaderAware {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private Resource[] mappingLocations;
    private String encoding = "UTF-8";
    private Class[] targetClasses;
    private String[] targetPackages;
    private boolean validating = false;
    private boolean whitespacePreserve = false;
    private boolean ignoreExtraAttributes = true;
    private boolean ignoreExtraElements = false;
    private Map<String, String> namespaceMappings;
    private XMLContext xmlContext;
    private boolean suppressNamespaces = false;
    private boolean suppressXsiType = false;
    private boolean marshalAsDocument = true;
    private String rootElement;
    private boolean marshalExtendedType = true;
    private String noNamespaceSchemaLocation;
    private String schemaLocation;
    private boolean useXSITypeAtRoot = false;
    private Map<String, String> processingInstructions;
    private Map<String, String> namespaceToPackageMapping;
    private ClassLoader classLoader;
    private Object root;
    private boolean reuseObjects = false;
    private boolean clearCollections = false;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMappingLocation(Resource mappingLocation) {
        this.mappingLocations = new Resource[]{mappingLocation};
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClasses = new Class[]{targetClass};
    }

    public void setTargetClasses(Class[] targetClasses) {
        this.targetClasses = targetClasses;
    }

    public void setTargetPackages(String[] targetPackages) {
        this.targetPackages = targetPackages;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setWhitespacePreserve(boolean whitespacePreserve) {
        this.whitespacePreserve = whitespacePreserve;
    }

    public void setIgnoreExtraAttributes(boolean ignoreExtraAttributes) {
        this.ignoreExtraAttributes = ignoreExtraAttributes;
    }

    public void setIgnoreExtraElements(boolean ignoreExtraElements) {
        this.ignoreExtraElements = ignoreExtraElements;
    }

    public void setNamespaceMappings(Map<String, String> namespaceMappings) {
        this.namespaceMappings = namespaceMappings;
    }

    public boolean isSuppressNamespaces() {
        return this.suppressNamespaces;
    }

    public void setSuppressNamespaces(boolean suppressNamespaces) {
        this.suppressNamespaces = suppressNamespaces;
    }

    public boolean isSuppressXsiType() {
        return this.suppressXsiType;
    }

    public void setSuppressXsiType(boolean suppressXsiType) {
        this.suppressXsiType = suppressXsiType;
    }

    public void setMarshalAsDocument(boolean marshalAsDocument) {
        this.marshalAsDocument = marshalAsDocument;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    public void setMarshalExtendedType(boolean marshalExtendedType) {
        this.marshalExtendedType = marshalExtendedType;
    }

    public void setNoNamespaceSchemaLocation(String noNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = noNamespaceSchemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void setUseXSITypeAtRoot(boolean useXSITypeAtRoot) {
        this.useXSITypeAtRoot = useXSITypeAtRoot;
    }

    public void setProcessingInstructions(Map<String, String> processingInstructions) {
        this.processingInstructions = processingInstructions;
    }

    public void setNamespaceToPackageMapping(Map<String, String> namespaceToPackageMapping) {
        this.namespaceToPackageMapping = namespaceToPackageMapping;
    }

    public void setObject(Object root) {
        this.root = root;
    }

    public void setReuseObjects(boolean reuseObjects) {
        this.reuseObjects = reuseObjects;
    }

    public void setClearCollections(boolean clearCollections) {
        this.clearCollections = clearCollections;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public final void afterPropertiesSet() throws CastorMappingException, IOException {
        if (this.logger.isInfoEnabled()) {
            if (!ObjectUtils.isEmpty((Object[])this.mappingLocations)) {
                this.logger.info((Object)("Configured using [" + StringUtils.arrayToCommaDelimitedString((Object[])this.mappingLocations) + "]"));
            }
            if (!ObjectUtils.isEmpty((Object[])this.targetClasses)) {
                this.logger.info((Object)("Configured for target classes " + StringUtils.arrayToCommaDelimitedString((Object[])this.targetClasses) + "]"));
            }
            if (!ObjectUtils.isEmpty((Object[])this.targetPackages)) {
                this.logger.info((Object)("Configured for target packages [" + StringUtils.arrayToCommaDelimitedString((Object[])this.targetPackages) + "]"));
            }
            if (ObjectUtils.isEmpty((Object[])this.mappingLocations) && ObjectUtils.isEmpty((Object[])this.targetClasses) && ObjectUtils.isEmpty((Object[])this.targetPackages)) {
                this.logger.info((Object)"Using default configuration");
            }
        }
        try {
            this.xmlContext = this.createXMLContext(this.mappingLocations, this.targetClasses, this.targetPackages);
        }
        catch (MappingException ex) {
            throw new CastorMappingException("Could not load Castor mapping", ex);
        }
        catch (ResolverException ex) {
            throw new CastorMappingException("Could not resolve Castor mapping", ex);
        }
    }

    protected XMLContext createXMLContext(Resource[] mappingLocations, Class[] targetClasses, String[] targetPackages) throws MappingException, ResolverException, IOException {
        XMLContext context = new XMLContext();
        if (!ObjectUtils.isEmpty((Object[])mappingLocations)) {
            Mapping mapping = new Mapping();
            Resource[] resourceArray = mappingLocations;
            int n = mappingLocations.length;
            int n2 = 0;
            while (n2 < n) {
                Resource mappingLocation = resourceArray[n2];
                mapping.loadMapping(SaxResourceUtils.createInputSource(mappingLocation));
                ++n2;
            }
            context.addMapping(mapping);
        }
        if (!ObjectUtils.isEmpty((Object[])targetClasses)) {
            context.addClasses(targetClasses);
        }
        if (!ObjectUtils.isEmpty((Object[])targetPackages)) {
            context.addPackages(targetPackages);
        }
        return context;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    protected final void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        this.marshalSaxHandlers(graph, DomUtils.createContentHandler((Node)node), null);
    }

    @Override
    protected final void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        Marshaller marshaller = this.xmlContext.createMarshaller();
        marshaller.setContentHandler(contentHandler);
        this.marshal(graph, marshaller);
    }

    @Override
    protected final void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        this.marshalWriter(graph, new OutputStreamWriter(outputStream, this.encoding));
    }

    @Override
    protected final void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        Marshaller marshaller = this.xmlContext.createMarshaller();
        marshaller.setWriter(writer);
        this.marshal(graph, marshaller);
    }

    @Override
    protected final void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) throws XmlMappingException {
        this.marshalSaxHandlers(graph, StaxUtils.createContentHandler((XMLEventWriter)eventWriter), null);
    }

    @Override
    protected final void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        this.marshalSaxHandlers(graph, StaxUtils.createContentHandler((XMLStreamWriter)streamWriter), null);
    }

    private void marshal(Object graph, Marshaller marshaller) {
        try {
            this.customizeMarshaller(marshaller);
            marshaller.marshal(graph);
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, true);
        }
    }

    protected void customizeMarshaller(Marshaller marshaller) {
        marshaller.setValidation(this.validating);
        marshaller.setSuppressNamespaces(this.isSuppressNamespaces());
        marshaller.setSuppressXSIType(this.isSuppressXsiType());
        marshaller.setMarshalAsDocument(this.marshalAsDocument);
        marshaller.setRootElement(this.rootElement);
        marshaller.setMarshalExtendedType(this.marshalExtendedType);
        marshaller.setNoNamespaceSchemaLocation(this.noNamespaceSchemaLocation);
        marshaller.setSchemaLocation(this.schemaLocation);
        marshaller.setUseXSITypeAtRoot(this.useXSITypeAtRoot);
        if (this.processingInstructions != null) {
            for (Map.Entry<String, String> processingInstruction : this.processingInstructions.entrySet()) {
                marshaller.addProcessingInstruction(processingInstruction.getKey(), processingInstruction.getValue());
            }
        }
        if (this.namespaceMappings != null) {
            for (Map.Entry<String, String> entry : this.namespaceMappings.entrySet()) {
                marshaller.setNamespaceMapping(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected final Object unmarshalDomNode(Node node) throws XmlMappingException {
        try {
            return this.createUnmarshaller().unmarshal(node);
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, false);
        }
    }

    @Override
    protected final Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        try {
            return this.createUnmarshaller().unmarshal(new InputSource(inputStream));
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, false);
        }
    }

    @Override
    protected final Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        try {
            return this.createUnmarshaller().unmarshal(new InputSource(reader));
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, false);
        }
    }

    @Override
    protected final Object unmarshalXmlEventReader(XMLEventReader eventReader) {
        XMLReader reader = StaxUtils.createXMLReader((XMLEventReader)eventReader);
        try {
            return this.unmarshalSaxReader(reader, new InputSource());
        }
        catch (IOException ex) {
            throw new UnmarshallingFailureException("Failed to read XML stream", ex);
        }
    }

    @Override
    protected final Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        UnmarshalHandler unmarshalHandler = this.createUnmarshaller().createHandler();
        try {
            ContentHandler contentHandler = Unmarshaller.getContentHandler((UnmarshalHandler)unmarshalHandler);
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(inputSource);
            return unmarshalHandler.getObject();
        }
        catch (SAXException ex) {
            throw new UnmarshallingFailureException("SAX reader exception", ex);
        }
    }

    @Override
    protected final Object unmarshalXmlStreamReader(XMLStreamReader streamReader) {
        XMLReader reader = StaxUtils.createXMLReader((XMLStreamReader)streamReader);
        try {
            return this.unmarshalSaxReader(reader, new InputSource());
        }
        catch (IOException ex) {
            throw new UnmarshallingFailureException("Failed to read XML stream", ex);
        }
    }

    private Unmarshaller createUnmarshaller() {
        Unmarshaller unmarshaller = this.xmlContext.createUnmarshaller();
        this.customizeUnmarshaller(unmarshaller);
        return unmarshaller;
    }

    protected void customizeUnmarshaller(Unmarshaller unmarshaller) {
        unmarshaller.setValidation(this.validating);
        unmarshaller.setWhitespacePreserve(this.whitespacePreserve);
        unmarshaller.setIgnoreExtraAttributes(this.ignoreExtraAttributes);
        unmarshaller.setIgnoreExtraElements(this.ignoreExtraElements);
        unmarshaller.setClassLoader(this.classLoader);
        unmarshaller.setObject(this.root);
        unmarshaller.setReuseObjects(this.reuseObjects);
        unmarshaller.setClearCollections(this.clearCollections);
        if (this.namespaceToPackageMapping != null) {
            for (Map.Entry<String, String> mapping : this.namespaceToPackageMapping.entrySet()) {
                unmarshaller.addNamespaceToPackageMapping(mapping.getKey(), mapping.getValue());
            }
        }
    }

    protected XmlMappingException convertCastorException(XMLException ex, boolean marshalling) {
        if (ex instanceof ValidationException) {
            return new ValidationFailureException("Castor validation exception", ex);
        }
        if (ex instanceof MarshalException) {
            if (marshalling) {
                return new MarshallingFailureException("Castor marshalling exception", ex);
            }
            return new UnmarshallingFailureException("Castor unmarshalling exception", ex);
        }
        return new UncategorizedMappingException("Unknown Castor exception", ex);
    }
}

