/*
 * Decompiled with CFR 0.152.
 */
package ru.d10xa.allure;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginCollection;
import org.gradle.api.tasks.testing.Test;
import ru.d10xa.allure.AllureExtension;
import ru.d10xa.allure.AllureReportTask;
import ru.d10xa.allure.MavenRepositories;

public class AllurePlugin
implements Plugin<Project> {
    private static final String ALLURE_RESULTS_DIRECTORY_SYSTEM_PROPERTY = "allure.results.directory";
    private static final String CONFIGURATION_TEST_COMPILE = "testCompile";
    private Project project;
    private Configuration cfg;
    private AllureExtension ext;
    private Task allureReportTask;

    public void apply(Project project) {
        this.project = project;
        PluginCollection javaPlugins = this.project.getPlugins().withType(JavaPlugin.class);
        this.cfg = (Configuration)project.getConfigurations().create("allureReport");
        this.ext = (AllureExtension)project.getExtensions().create("allure", AllureExtension.class, new Object[]{project});
        this.project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (AllurePlugin.this.ext.isGeb()) {
                    MavenRepositories.addRepository(project.getRepositories(), "https://dl.bintray.com/d10xa/maven");
                    AllurePlugin.this.dependency(AllurePlugin.CONFIGURATION_TEST_COMPILE, "ru.d10xa", "allure-spock-geb", "0.2.1");
                }
                for (Test test : project.getTasks().withType(Test.class)) {
                    test.systemProperty(AllurePlugin.ALLURE_RESULTS_DIRECTORY_SYSTEM_PROPERTY, (Object)AllurePlugin.this.ext.getAllureResultsDir());
                }
            }
        });
        this.dependency("allureReport", "ru.yandex.qatools.allure", "allure-bundle", this.ext.getAllureBundleVersion());
        if (!javaPlugins.isEmpty()) {
            this.addDependencies();
        }
        this.createAllureReportTask(project);
    }

    private void createAllureReportTask(Project project) {
        this.allureReportTask = project.getTasks().create("allureReport", AllureReportTask.class);
    }

    private void addDependencies() {
        this.dependency(CONFIGURATION_TEST_COMPILE, "ru.yandex.qatools.allure", "allure-spock-1.0-adaptor", "1.0");
    }

    private void dependency(String configuration, String group, String name, String version) {
        this.project.getDependencies().add(configuration, (Object)String.format("%s:%s:%s", group, name, version));
    }
}

