/*
 * Decompiled with CFR 0.152.
 */
package ru.d10xa.allure;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import ru.d10xa.allure.AllureExtension;

public class AllureReportTask
extends JavaExec {
    public static final String NAME = "allureReport";
    public static final String ALLURE_MAIN_CLASS = "ru.yandex.qatools.allure.AllureMain";
    public static final String CONFIGURATION_NAME = "allureReport";
    private Set<Object> resultDirs = new LinkedHashSet<Object>();
    private Object reportDir;

    @TaskAction
    public void exec() {
        this.args(this.collectArguments());
        this.setMain(ALLURE_MAIN_CLASS);
        this.classpath(new Object[]{this.getProject().getConfigurations().getByName("allureReport")});
        super.exec();
    }

    @Input
    private List<String> collectArguments() {
        ArrayList<String> args = new ArrayList<String>(this.resultDirs.size() + 1);
        for (Object resultDir : this.resultDirs) {
            args.add(resultDir.toString());
        }
        if (args.isEmpty()) {
            args.add(this.getAllureExtension().getAllureResultsDir());
        }
        if (this.reportDir != null) {
            args.add(this.reportDir.toString());
        } else {
            args.add(this.getAllureExtension().getAllureReportDir());
        }
        return args;
    }

    private AllureExtension getAllureExtension() {
        return (AllureExtension)this.getProject().getExtensions().findByType(AllureExtension.class);
    }

    public void from(Object ... results) {
        this.resultDirs = new LinkedHashSet<Object>();
        for (Object result : results) {
            this.resultDirs.add(result);
        }
    }

    public void to(Object reportDir) {
        this.reportDir = reportDir;
    }
}

