/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.validator;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matchers;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import javax.validation.executable.ValidateOnExecution;
import org.aopalliance.intercept.MethodInterceptor;
import ru.vyarus.guice.validator.GuiceConstraintValidatorFactory;
import ru.vyarus.guice.validator.GuiceMethodValidator;

public class ValidationModule
extends AbstractModule {
    private ValidatorFactory factory;

    public ValidationModule() {
        this(Validation.buildDefaultValidatorFactory());
    }

    public ValidationModule(ValidatorFactory factory) {
        this.factory = factory;
    }

    protected void configure() {
        GuiceConstraintValidatorFactory constraintValidatorFactory = new GuiceConstraintValidatorFactory();
        this.requestInjection(constraintValidatorFactory);
        Validator validator = this.factory.usingContext().constraintValidatorFactory((ConstraintValidatorFactory)constraintValidatorFactory).getValidator();
        this.bind(Validator.class).toInstance((Object)validator);
        this.bind(ExecutableValidator.class).toInstance((Object)validator.forExecutables());
        GuiceMethodValidator interceptor = new GuiceMethodValidator();
        this.requestInjection(interceptor);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(ValidateOnExecution.class), new MethodInterceptor[]{interceptor});
        this.bindInterceptor(Matchers.annotatedWith(ValidateOnExecution.class), Matchers.any(), new MethodInterceptor[]{interceptor});
    }
}

