/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter.engine;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.Extension;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import ru.vyarus.spock.jupiter.engine.ExtensionUtils;

public class ExtensionRegistry {
    private final Logger logger = LoggerFactory.getLogger(ExtensionRegistry.class);
    private final ExtensionRegistry parent;
    private final Set<Class<? extends Extension>> registeredExtensionTypes = new LinkedHashSet<Class<? extends Extension>>();
    private final List<Extension> registeredExtensions = new ArrayList<Extension>();

    public ExtensionRegistry(ExtensionRegistry parent) {
        this.parent = parent;
    }

    public <E extends Extension> Stream<E> stream(Class<E> extensionType) {
        if (this.parent == null) {
            return this.streamLocal(extensionType);
        }
        return Stream.concat(this.parent.stream(extensionType), this.streamLocal(extensionType));
    }

    public <E extends Extension> List<E> getExtensions(Class<E> extensionType) {
        return this.stream(extensionType).collect(Collectors.toCollection(ArrayList::new));
    }

    public <E extends Extension> List<E> getReversedExtensions(Class<E> extensionType) {
        List<E> extensions = this.getExtensions(extensionType);
        Collections.reverse(extensions);
        return extensions;
    }

    public void registerExtension(Class<? extends Extension> extensionType) {
        if (!this.isAlreadyRegistered(extensionType)) {
            this.registerExtension((Extension)ReflectionUtils.newInstance(extensionType, (Object[])new Object[0]), null);
        }
    }

    public void registerExtension(Extension extension, Object source) {
        Preconditions.notNull((Object)extension, (String)"Extension must not be null");
        Class<?> type = extension.getClass();
        this.validateExtensionType(type);
        this.logger.trace(() -> String.format("Registering extension [%s]%s", extension, this.buildSourceInfo(source)));
        this.registeredExtensions.add(extension);
        this.registeredExtensionTypes.add(type);
    }

    private void validateExtensionType(Class<? extends Extension> extension) {
        int supported = (int)ExtensionUtils.SUPPORTED_EXTENSIONS.stream().filter(ext -> ext.isAssignableFrom(extension)).count();
        List unsupported = ExtensionUtils.UNSUPPORTED_EXTENSIONS.stream().filter(ext -> ext.isAssignableFrom(extension)).collect(Collectors.toList());
        if (!unsupported.isEmpty()) {
            this.logger.warn(() -> "Extension " + extension.getName() + " implements not supported extension types: " + unsupported.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        }
        if (supported == 0) {
            throw new IllegalStateException("Extension " + extension.getName() + " does not use any of supported extension types: " + ExtensionUtils.SUPPORTED_EXTENSIONS.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        }
    }

    private String buildSourceInfo(Object source) {
        String res;
        if (source == null) {
            return "";
        }
        if (source instanceof Member) {
            Member member = (Member)source;
            String type = member instanceof Method ? "method" : "field";
            res = String.format("%s %s.%s", type, member.getDeclaringClass().getName(), member.getName());
        } else {
            res = source.toString();
        }
        return " from source [" + res + "]";
    }

    private boolean isAlreadyRegistered(Class<? extends Extension> extensionType) {
        return this.registeredExtensionTypes.contains(extensionType) || this.parent != null && this.parent.isAlreadyRegistered(extensionType);
    }

    private <E extends Extension> Stream<E> streamLocal(Class<E> extensionType) {
        return this.registeredExtensions.stream().filter(extensionType::isInstance).map(extensionType::cast);
    }
}

