/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.spockframework.runtime.model.MethodInfo;
import ru.vyarus.spock.jupiter.engine.ExtensionRegistry;
import ru.vyarus.spock.jupiter.engine.context.AbstractContext;

@SuppressFBWarnings(value={"MS_MUTABLE_COLLECTION_PKGPROTECT"})
public final class ExtensionUtils {
    public static final List<Class<? extends Extension>> SUPPORTED_EXTENSIONS = Arrays.asList(ExecutionCondition.class, BeforeAllCallback.class, AfterAllCallback.class, BeforeEachCallback.class, AfterEachCallback.class, BeforeTestExecutionCallback.class, AfterTestExecutionCallback.class, ParameterResolver.class, TestInstancePostProcessor.class, TestInstancePreDestroyCallback.class, TestExecutionExceptionHandler.class);
    public static final List<Class<? extends Extension>> UNSUPPORTED_EXTENSIONS = Arrays.asList(TestTemplateInvocationContextProvider.class, TestInstanceFactory.class, LifecycleMethodExecutionExceptionHandler.class, InvocationInterceptor.class, TestWatcher.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionUtils.class);
    private static final Comparator<Field> ORDER_COMPARATOR = Comparator.comparingInt(ExtensionUtils::getOrder);

    private ExtensionUtils() {
    }

    public static ExtensionRegistry createRegistry(Class<?> testClass) {
        ExtensionRegistry registry = new ExtensionRegistry(null);
        ExtensionUtils.findClassExtensions(testClass).forEach(registry::registerExtension);
        return registry;
    }

    public static ExtensionRegistry createMethodRegistry(ExtensionRegistry root, Method method) {
        Stream<Class<? extends Extension>> extensions = ExtensionUtils.streamExtensionTypes(method);
        ExtensionRegistry registry = new ExtensionRegistry(root);
        extensions.forEach(registry::registerExtension);
        ExtensionUtils.registerExtensionsFromExecutableParameters(registry, method);
        return registry;
    }

    public static Stream<Class<? extends Extension>> findClassExtensions(Class<?> testClass) {
        return ExtensionUtils.streamExtensionTypes(AnnotationUtils.findRepeatableAnnotations(testClass, ExtendWith.class));
    }

    public static void registerExtensionsFromFields(ExtensionRegistry registrar, Class<?> clazz, Object instance) {
        Preconditions.notNull((Object)registrar, (String)"ExtensionRegistry must not be null");
        Preconditions.notNull(clazz, (String)"Class must not be null");
        Predicate<Field> predicate = instance == null ? ReflectionUtils::isStatic : ReflectionUtils::isNotStatic;
        ReflectionUtils.findFields(clazz, predicate, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().sorted(ORDER_COMPARATOR).forEach(field -> {
            List<Class> extensionTypes = ExtensionUtils.streamExtensionTypes(field).collect(Collectors.toList());
            boolean isExtendWithPresent = !extensionTypes.isEmpty();
            boolean isRegisterExtensionPresent = AnnotationUtils.isAnnotated((AnnotatedElement)field, RegisterExtension.class);
            if (isExtendWithPresent) {
                extensionTypes.forEach(registrar::registerExtension);
            }
            if (isRegisterExtensionPresent) {
                ReflectionUtils.tryToReadFieldValue((Field)field, (Object)instance).ifSuccess(value -> {
                    Preconditions.condition((boolean)(value instanceof Extension), () -> String.format("Failed to register extension via @RegisterExtension field [%s]: field value's type [%s] must implement an [%s] API.", field, value != null ? value.getClass().getName() : null, Extension.class.getName()));
                    if (isExtendWithPresent) {
                        Class<?> valueType = value.getClass();
                        extensionTypes.forEach(extensionType -> Preconditions.condition((!extensionType.equals(valueType) ? 1 : 0) != 0, () -> String.format("Failed to register extension via field [%s]. The field registers an extension of type [%s] via @RegisterExtension and @ExtendWith, but only one registration of a given extension type is permitted.", field, valueType.getName())));
                    }
                    registrar.registerExtension((Extension)value, field);
                });
            }
        });
    }

    public static void registerExtensionsFromExecutableParameters(ExtensionRegistry registrar, Executable executable) {
        Preconditions.notNull((Object)registrar, (String)"ExtensionRegistry must not be null");
        Preconditions.notNull((Object)executable, (String)"Executable must not be null");
        AtomicInteger index = new AtomicInteger();
        Arrays.stream(executable.getParameters()).map(parameter -> AnnotationUtils.findRepeatableAnnotations((Parameter)parameter, (int)index.getAndIncrement(), ExtendWith.class)).flatMap(ExtensionUtils::streamExtensionTypes).forEach(registrar::registerExtension);
    }

    public static Object resolveParameter(ParameterContext parameterContext, Executable executable, AbstractContext context) {
        try {
            List exts = context.getRegistry().stream(ParameterResolver.class).filter(resolver -> resolver.supportsParameter(parameterContext, (ExtensionContext)context)).collect(Collectors.toList());
            if (exts.isEmpty()) {
                return MethodInfo.MISSING_ARGUMENT;
            }
            if (exts.size() > 1) {
                String resolvers = exts.stream().map(parameterResolver -> parameterResolver.getClass().getSimpleName()).collect(Collectors.joining(", "));
                throw new ParameterResolutionException(String.format("Discovered multiple competing ParameterResolvers for parameter [%s] in method [%s]: %s", parameterContext.getParameter(), executable.toGenericString(), resolvers));
            }
            ParameterResolver resolver2 = (ParameterResolver)exts.get(0);
            Object value = resolver2.resolveParameter(parameterContext, (ExtensionContext)context);
            ExtensionUtils.validateResolvedType(parameterContext.getParameter(), value, executable, resolver2);
            LOGGER.debug(() -> String.format("ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in method [%s].", resolver2.getClass().getName(), value != null ? value.getClass().getName() : null, parameterContext.getParameter(), executable.toGenericString()));
            return value;
        }
        catch (ParameterResolutionException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
            String message = String.format("Failed to resolve parameter [%s] in method [%s]", parameterContext.getParameter(), executable.toGenericString());
            if (StringUtils.isNotBlank((String)throwable.getMessage())) {
                message = message + ": " + throwable.getMessage();
            }
            throw new ParameterResolutionException(message, throwable);
        }
    }

    private static void validateResolvedType(Parameter parameter, Object value, Executable executable, ParameterResolver resolver) {
        Class<?> type = parameter.getType();
        if (!ReflectionUtils.isAssignableTo((Object)value, type)) {
            String message = value == null && type.isPrimitive() ? String.format("ParameterResolver [%s] resolved a null value for parameter [%s] in method [%s], but a primitive of type [%s] is required.", resolver.getClass().getName(), parameter, executable.toGenericString(), type.getName()) : String.format("ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in method [%s], but a value assignment compatible with [%s] is required.", resolver.getClass().getName(), value != null ? value.getClass().getName() : null, parameter, executable.toGenericString(), type.getName());
            throw new ParameterResolutionException(message);
        }
    }

    private static int getOrder(Field field) {
        return AnnotationUtils.findAnnotation((AnnotatedElement)field, Order.class).map(Order::value).orElse(0x3FFFFFFF);
    }

    private static Stream<Class<? extends Extension>> streamExtensionTypes(AnnotatedElement annotatedElement) {
        return ExtensionUtils.streamExtensionTypes(AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)annotatedElement, ExtendWith.class));
    }

    private static Stream<Class<? extends Extension>> streamExtensionTypes(List<ExtendWith> extendWithAnnotations) {
        return extendWithAnnotations.stream().map(ExtendWith::value).flatMap(Arrays::stream);
    }
}

