/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter.engine.context;

import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.TestInstances;
import org.spockframework.runtime.model.FeatureInfo;
import ru.vyarus.spock.jupiter.engine.ExtensionRegistry;
import ru.vyarus.spock.jupiter.engine.context.AbstractContext;
import ru.vyarus.spock.jupiter.engine.context.ClassContext;
import ru.vyarus.spock.jupiter.engine.context.DefaultTestInstances;

public class MethodContext
extends AbstractContext {
    private final FeatureInfo feature;
    private final TestInstances instances;

    public MethodContext(ClassContext parent, ExtensionRegistry registry, FeatureInfo feature, Object testInstance) {
        super(parent, registry, feature.getFeatureMethod().getReflection(), parent.getSpec());
        this.feature = feature;
        this.instances = DefaultTestInstances.of(testInstance);
    }

    public String getUniqueId() {
        return this.parent.getUniqueId() + "/[method:" + this.feature.getFeatureMethod().getName() + "]";
    }

    public String getDisplayName() {
        return this.feature.getDisplayName();
    }

    public Optional<Method> getTestMethod() {
        return Optional.of(this.feature.getFeatureMethod().getReflection());
    }

    public Optional<Object> getTestInstance() {
        return this.getTestInstances().map(TestInstances::getInnermostInstance);
    }

    public Optional<TestInstances> getTestInstances() {
        return Optional.ofNullable(this.instances);
    }
}

