/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.spockframework.runtime.extension.AbstractMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.runtime.model.MethodInfo;
import ru.vyarus.spock.jupiter.engine.ExtensionRegistry;
import ru.vyarus.spock.jupiter.engine.ExtensionUtils;
import ru.vyarus.spock.jupiter.engine.context.AbstractContext;
import ru.vyarus.spock.jupiter.engine.context.ClassContext;
import ru.vyarus.spock.jupiter.engine.context.DefaultParameterContext;
import ru.vyarus.spock.jupiter.engine.context.MethodContext;
import ru.vyarus.spock.jupiter.engine.execution.ConditionEvaluator;
import ru.vyarus.spock.jupiter.interceptor.JunitApiExecutor;

public class ExtensionLifecycleMerger
extends AbstractMethodInterceptor {
    private final Logger logger = LoggerFactory.getLogger(ExtensionLifecycleMerger.class);
    private final Map<Object, MethodContext> methods = new ConcurrentHashMap<Object, MethodContext>();
    private final ClassContext context;
    private final JunitApiExecutor junit = new JunitApiExecutor();
    private final IMethodInterceptor fixtureMethodsInterceptor;

    public ExtensionLifecycleMerger(ClassContext context) {
        this.context = context;
        this.fixtureMethodsInterceptor = invocation -> {
            AbstractContext ctx = context;
            if (invocation.getFeature() != null) {
                ctx = this.getMethodContext(invocation);
            }
            this.injectArguments(invocation, ctx);
            invocation.proceed();
        };
    }

    public IMethodInterceptor getFixtureMethodsInterceptor() {
        return this.fixtureMethodsInterceptor;
    }

    public ClassContext getSpecContext() {
        return this.context;
    }

    public MethodContext getMethodContext(IMethodInvocation invocation) {
        return (MethodContext)Preconditions.notNull((Object)this.methods.get(invocation.getInstance()), () -> "Method context not found for '" + invocation.getSpec().getDisplayName() + "/" + invocation.getFeature().getDisplayName() + "' feature");
    }

    public void interceptSetupSpecMethod(IMethodInvocation invocation) throws Throwable {
        this.junit.beforeAll(this.context);
        this.spockLifecycle("setupSpec");
        invocation.proceed();
    }

    public void interceptInitializerMethod(IMethodInvocation invocation) throws Throwable {
        this.spockLifecycle("initialization");
        invocation.proceed();
        Object instance = Preconditions.notNull((Object)invocation.getInstance(), (String)"No spec instance");
        this.junit.instancePostProcessors(this.context, instance);
        MethodContext methodContext = this.createMethodContext(invocation.getFeature(), instance);
        if (ConditionEvaluator.skip((ISkippable)invocation.getFeature(), methodContext)) {
            return;
        }
        this.methods.put(instance, methodContext);
    }

    public void interceptSetupMethod(IMethodInvocation invocation) throws Throwable {
        this.junit.beforeEach(this.getMethodContext(invocation));
        this.spockLifecycle("setup");
        invocation.proceed();
    }

    public void interceptFeatureMethod(IMethodInvocation invocation) throws Throwable {
        this.spockLifecycle("'" + invocation.getFeature().getDisplayName() + "' execution");
        MethodContext mcontext = this.getMethodContext(invocation);
        try {
            this.junit.beforeTestExecution(mcontext);
            this.injectArguments(invocation, mcontext);
            mcontext.getCollector().execute(() -> {
                try {
                    invocation.proceed();
                }
                catch (Throwable throwable) {
                    UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
                    this.junit.handleTestException(mcontext, throwable);
                }
            });
        }
        finally {
            this.junit.afterTestExecution(mcontext);
        }
    }

    public void interceptCleanupMethod(IMethodInvocation invocation) throws Throwable {
        this.spockLifecycle("cleanup");
        MethodContext mcontext = this.getMethodContext(invocation);
        invocation.proceed();
        this.junit.afterEach(mcontext);
        this.methods.remove(invocation.getInstance());
        this.junit.instancePreDestroy(mcontext);
        mcontext.close();
    }

    public void interceptCleanupSpecMethod(IMethodInvocation invocation) throws Throwable {
        this.spockLifecycle("cleanupSpec");
        invocation.proceed();
        this.junit.afterAll(this.context);
        this.context.close();
    }

    private MethodContext createMethodContext(FeatureInfo featureInfo, Object instance) {
        Method method = (Method)featureInfo.getFeatureMethod().getReflection();
        ExtensionRegistry methodRegistry = ExtensionUtils.createMethodRegistry(this.context.getRegistry(), method);
        ExtensionUtils.registerExtensionsFromExecutableParameters(methodRegistry, method);
        ExtensionUtils.registerExtensionsFromFields(methodRegistry, this.context.getRequiredTestClass(), instance);
        return new MethodContext(this.context, methodRegistry, featureInfo, instance);
    }

    private void spockLifecycle(String name) {
        this.logger.debug(() -> "Spock " + ((Class)this.context.getSpec().getReflection()).getSimpleName() + "." + name);
    }

    private void injectArguments(IMethodInvocation invocation, AbstractContext context) {
        Method method = (Method)invocation.getMethod().getReflection();
        Object[] arguments = invocation.getArguments();
        if (method == null || arguments.length == 0) {
            return;
        }
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] != MethodInfo.MISSING_ARGUMENT) continue;
            Parameter param = parameters[i];
            DefaultParameterContext parameterContext = new DefaultParameterContext(param, i, Optional.ofNullable(invocation.getTarget()));
            arguments[i] = ExtensionUtils.resolveParameter(parameterContext, method, context);
        }
    }
}

