/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy;

import java.io.ByteArrayOutputStream;

public class AudioSample {
    private static final byte[] header = new byte[]{82, 73, 70, 70, 48, 48, 48, 48, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 16, 0, 100, 97, 116, 97, 0, 0, 0, 0};
    private int sampleRate;
    private int bitsPerSample;
    private int channels;
    private int source;
    private float timestamp;
    private byte[] audioData;
    private byte[] wavFile;

    public AudioSample(int n2, int n3, int n4, int n5, float f2, byte[] byArray) {
        this.sampleRate = n2;
        this.bitsPerSample = n3;
        this.channels = n4;
        this.source = n5;
        this.timestamp = f2;
        this.audioData = byArray;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSource() {
        return this.source;
    }

    public float getTimestamp() {
        return this.timestamp;
    }

    public int getDurationInMilliseconds() {
        AudioSample audioSample = this;
        int n2 = audioSample.audioData.length;
        if (audioSample.getChannels() == 2) {
            n2 >>= 1;
        }
        if (this.getBitsPerSample() == 16) {
            n2 >>= 1;
        }
        return (int)((float)(n2 / this.sampleRate) * 1000.0f);
    }

    public void destroy() {
        AudioSample audioSample = this;
        audioSample.audioData = null;
        audioSample.wavFile = null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toWavFile() {
        void var0_3;
        ByteArrayOutputStream byteArrayOutputStream;
        block32: {
            Object object;
            block31: {
                byte[] byArray;
                ByteArrayOutputStream byteArrayOutputStream2;
                object = null;
                if (this.wavFile != null) {
                    return this.wavFile;
                }
                if (this.audioData == null) break block31;
                AudioSample audioSample = this;
                byteArrayOutputStream = byteArrayOutputStream2;
                AudioSample audioSample2 = this;
                AudioSample audioSample3 = audioSample2;
                AudioSample audioSample4 = audioSample2;
                ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream;
                ByteArrayOutputStream byteArrayOutputStream4 = byteArrayOutputStream3;
                ByteArrayOutputStream byteArrayOutputStream5 = byteArrayOutputStream3;
                AudioSample audioSample5 = this;
                ByteArrayOutputStream byteArrayOutputStream6 = byteArrayOutputStream;
                ByteArrayOutputStream byteArrayOutputStream7 = byteArrayOutputStream6;
                byteArrayOutputStream6();
                try {
                    byteArrayOutputStream7.write(header);
                    byteArrayOutputStream4.write(audioSample5.audioData, 0, this.audioData.length);
                    byArray = byteArrayOutputStream5.toByteArray();
                }
                catch (Throwable throwable) {}
                object = byArray;
                int n2 = this.sampleRate * this.bitsPerSample;
                int n3 = n2 * this.channels;
                int n4 = n3 / 8;
                int n5 = n4;
                Object object2 = object;
                int n6 = n5;
                Object object3 = object;
                int n7 = n5;
                Object object4 = object;
                int n8 = n5;
                Object object5 = object;
                Object object6 = object5;
                Object object7 = object5;
                Object object8 = object5;
                Object object9 = object5;
                Object object10 = object5;
                Object object11 = object5;
                n5 = ((Object)object5).length + header.length - 4;
                object[4] = (byte)(n5 & 0xFF);
                object[5] = (byte)(n5 >> 8 & 0xFF);
                object[6] = (byte)(n5 >> 16 & 0xFF);
                object9[7] = (byte)(n5 >> 24 & 0xFF);
                int n9 = 22;
                int n10 = this.channels;
                object10[n9] = (byte)(n10 & 0xFF);
                int n11 = 24;
                int n12 = this.sampleRate;
                object11[n11] = (byte)(n12 & 0xFF);
                int n13 = 25;
                int n14 = this.sampleRate;
                object7[n13] = (byte)(n14 >> 8 & 0xFF);
                int n15 = 26;
                int n16 = this.sampleRate;
                object8[n15] = (byte)(n16 >> 16 & 0xFF);
                int n17 = 27;
                int n18 = this.sampleRate;
                object6[n17] = (byte)(n18 >> 24 & 0xFF);
                object4[28] = (byte)(n8 & 0xFF);
                object3[29] = (byte)(n7 >> 8 & 0xFF);
                object2[30] = (byte)(n6 >> 16 & 0xFF);
                byArray[31] = (byte)(n4 >> 24 & 0xFF);
                int n19 = 34;
                int n20 = this.bitsPerSample;
                byArray[n19] = (byte)(n20 & 0xFF);
                int n21 = 35;
                int n22 = this.bitsPerSample;
                byArray[n21] = (byte)(n22 >> 8 & 0xFF);
                int n23 = 40;
                int n24 = ((Object)object).length;
                byArray[n23] = (byte)(n24 & 0xFF);
                int n25 = 41;
                int n26 = ((Object)object).length;
                byArray[n25] = (byte)(n26 >> 8 & 0xFF);
                int n27 = 42;
                int n28 = ((Object)object).length;
                byArray[n27] = (byte)(n28 >> 16 & 0xFF);
                int n29 = 43;
                int n30 = ((Object)object).length;
                byArray[n29] = (byte)(n30 >> 24 & 0xFF);
                audioSample3.wavFile = byArray;
                audioSample4.audioData = null;
                byteArrayOutputStream2.close();
                return audioSample.wavFile;
                break block32;
            }
            try {
                throw new NullPointerException("Non empty audio data must be provided. Have you destroyed the sample by accident?");
            }
            catch (Throwable throwable) {
                byteArrayOutputStream = object;
            }
        }
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        throw var0_3;
    }
}

