/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy.modules.audio;

import java.io.ByteArrayOutputStream;

public class AudioSample {
    private static final byte[] h = new byte[]{82, 73, 70, 70, 48, 48, 48, 48, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 16, 0, 100, 97, 116, 97, 0, 0, 0, 0};
    private int a;
    private int b;
    private int c;
    private int d;
    private float e;
    private byte[] f;
    private byte[] g;

    public AudioSample(int n2, int n3, int n4, int n5, float f2, byte[] byArray) {
        this.a = n2;
        this.b = n3;
        this.c = n4;
        this.d = n5;
        this.e = f2;
        this.f = byArray;
    }

    public int getSampleRate() {
        return this.a;
    }

    public int getBitsPerSample() {
        return this.b;
    }

    public int getChannels() {
        return this.c;
    }

    public int getSource() {
        return this.d;
    }

    public float getTimestamp() {
        return this.e;
    }

    public int getDurationInMilliseconds() {
        AudioSample audioSample = this;
        int n2 = audioSample.f.length;
        if (audioSample.getChannels() == 2) {
            n2 >>= 1;
        }
        if (this.getBitsPerSample() == 16) {
            n2 >>= 1;
        }
        return (int)((float)(n2 / this.a) * 1000.0f);
    }

    public void destroy() {
        AudioSample audioSample = this;
        audioSample.f = null;
        audioSample.g = null;
    }

    public byte[] toWavFile() {
        Object object = this.g;
        if (this.g != null) {
            return object;
        }
        if (this.f != null) {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream;
            object = byteArrayOutputStream;
            AudioSample audioSample = this;
            byte[] byArray = object;
            byte[] byArray2 = object;
            byArray2();
            byArray2.write(h);
            byArray.write(this.f, 0, this.f.length);
            byte[] byArray3 = byArray.toByteArray();
            object = byArray3;
            AudioSample audioSample2 = this;
            int n3 = audioSample2.a;
            int n4 = audioSample2.b;
            int n5 = n2 = n4;
            int n6 = this.c;
            n2 = n3 * n2 * n6 / 8;
            int n7 = n6;
            n6 = ((byte[])object).length + h.length - 4;
            object[4] = (byte)(n6 & 0xFF);
            object[5] = (byte)(n6 >> 8 & 0xFF);
            object[6] = (byte)(n6 >> 16 & 0xFF);
            object[7] = (byte)(n6 >> 24 & 0xFF);
            object[22] = (byte)(n7 & 0xFF);
            object[24] = (byte)(n3 & 0xFF);
            object[25] = (byte)(n3 >> 8 & 0xFF);
            object[26] = (byte)(n3 >> 16 & 0xFF);
            object[27] = (byte)(n3 >> 24 & 0xFF);
            object[28] = (byte)(n2 & 0xFF);
            object[29] = (byte)(n2 >> 8 & 0xFF);
            object[30] = (byte)(n2 >> 16 & 0xFF);
            object[31] = (byte)(n2 >> 24 & 0xFF);
            object[34] = (byte)(n5 & 0xFF);
            byArray3[35] = (byte)(n4 >> 8 & 0xFF);
            byArray3[40] = (byte)(byArray3.length & 0xFF);
            byArray3[41] = (byte)(byArray3.length >> 8 & 0xFF);
            byArray3[42] = (byte)(byArray3.length >> 16 & 0xFF);
            byArray3[43] = (byte)(byArray3.length >> 24 & 0xFF);
            audioSample.g = byArray3;
            audioSample.f = null;
            byteArrayOutputStream.close();
            return this.g;
        }
        throw new NullPointerException("Non empty audio data must be provided. Have you destroyed the sample by accident?");
    }
}

