/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.address;

import th.or.nectec.thai.address.AddressEntity;
import th.or.nectec.thai.address.AddressPrinter;
import th.or.nectec.thai.address.District;
import th.or.nectec.thai.address.Province;
import th.or.nectec.thai.address.SubDistrict;

public class Address
implements AddressEntity {
    private final SubDistrict subDistrict;
    private final District district;
    private final Province province;

    public Address(SubDistrict subDistrict, District district, Province province) {
        this.subDistrict = subDistrict;
        this.district = district;
        this.province = province;
    }

    public SubDistrict getSubDistrict() {
        return this.subDistrict;
    }

    public District getDistrict() {
        return this.district;
    }

    public Province getProvince() {
        return this.province;
    }

    public int hashCode() {
        return this.subDistrict.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Address otherAddress = (Address)other;
        return this.getCode().equals(otherAddress.getCode()) && this.getName().equals(otherAddress.getName());
    }

    public String toString() {
        return "Address{subDistrict=" + this.subDistrict + ", district=" + this.district + ", province=" + this.province + '}';
    }

    @Override
    public String getCode() {
        return this.subDistrict.getCode();
    }

    @Override
    public String getName() {
        return AddressPrinter.print(this.subDistrict, this.district, this.province);
    }
}

