/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.address;

import th.or.nectec.thai.address.AddressEntity;
import th.or.nectec.thai.address.InvalidAddressCodeFormatException;
import th.or.nectec.util.TextUtils;

public class SubDistrict
implements AddressEntity,
Comparable<SubDistrict> {
    private final String code;
    private final String name;
    private final String postcode;

    public SubDistrict(String code, String name, String postcode) {
        if (code.length() != 6 || !TextUtils.isDigitOnly(code)) {
            throw new InvalidAddressCodeFormatException.InvalidSubDistrictCodeException(code);
        }
        this.code = code;
        if (postcode.length() != 5 || !TextUtils.isDigitOnly(postcode)) {
            throw new InvalidAddressCodeFormatException("Invalid postcode format", postcode);
        }
        this.postcode = postcode;
        this.name = name;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDistrictCode() {
        return this.code.substring(0, 4);
    }

    public String getProvinceCode() {
        return this.code.substring(0, 2);
    }

    public String getPostcode() {
        return this.postcode;
    }

    public int hashCode() {
        int result = this.code.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.postcode != null ? this.postcode.hashCode() : 0);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SubDistrict otherSubDistrict = (SubDistrict)other;
        return this.code.equals(otherSubDistrict.code) && this.name.equals(otherSubDistrict.name);
    }

    public String toString() {
        return "SubDistrict{code='" + this.code + '\'' + ", name='" + this.name + '\'' + ", postcode='" + this.postcode + '\'' + '}';
    }

    @Override
    public int compareTo(SubDistrict that) {
        return this.name.compareTo(that.name);
    }
}

