/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.identity;

import th.or.nectec.thai.identity.IdPrettyPrinter;
import th.or.nectec.thai.identity.Identity;
import th.or.nectec.thai.identity.PrettyPrinter;
import th.or.nectec.util.TextUtils;

public class HouseId
implements Identity {
    public static final int LENGTH = 11;
    private static final int[] MULTIPLIER_TABLE = new int[]{11, 10, 9, 8, 7, 6, 5, 4, 3, 2};
    private final String id;
    private final PrettyPrinter printer = new IdPrettyPrinter(){

        @Override
        protected boolean positionToInsertSeparatorBefore(int position) {
            switch (position) {
                case 4: 
                case 10: {
                    return true;
                }
            }
            return false;
        }
    };

    public HouseId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID must not be null");
        }
        this.id = id.replace(this.printer.separator(), "");
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HouseId)) {
            return false;
        }
        HouseId houseId = (HouseId)o;
        return this.id.equals(houseId.id);
    }

    public String toString() {
        return this.printer.print(this.id);
    }

    @Override
    public boolean isValidFormat() {
        return this.id.length() == 11 && TextUtils.isDigitOnly(this.id);
    }

    protected int getCheckDigit() {
        if (!this.isValidFormat()) {
            return -1;
        }
        int lastIndex = 10;
        return Character.digit(this.id.charAt(lastIndex), 10);
    }

    @Override
    public boolean validate() {
        return this.isValidFormat() && !TextUtils.isRepeatingNumber(this.id) && this.calculateCheckDigit() == this.getCheckDigit();
    }

    protected int calculateCheckDigit() {
        int sum = 0;
        for (int position = 0; position < 10; ++position) {
            sum += Character.digit(this.id.charAt(position), 10) * MULTIPLIER_TABLE[position];
        }
        int x = sum % 11;
        return (11 - x) % 10;
    }

    @Override
    public String prettyPrint() {
        return this.printer.print(this.id);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

