/*
 * Decompiled with CFR 0.152.
 */
package wo.lf.lifx.api;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.flowables.GroupedFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import wo.lf.lifx.api.BroadcastGetServiceCommand;
import wo.lf.lifx.api.DefaultLightFactory;
import wo.lf.lifx.api.ILightFactory;
import wo.lf.lifx.api.ILightSource;
import wo.lf.lifx.api.ILightsChangeDispatcher;
import wo.lf.lifx.api.LifxMessage;
import wo.lf.lifx.api.LifxMessageParserImpl;
import wo.lf.lifx.api.Light;
import wo.lf.lifx.api.LightService;
import wo.lf.lifx.api.LightServiceKt;
import wo.lf.lifx.domain.Lifx;
import wo.lf.lifx.domain.LifxMessagePayload;
import wo.lf.lifx.extensions.LifxDomainExtensionsKt;
import wo.lf.lifx.extensions.RxExtensionsKt;
import wo.lf.lifx.net.SourcedLifxMessage;
import wo.lf.lifx.net.TargetedLifxMessage;
import wo.lf.lifx.net.Transport;
import wo.lf.lifx.net.TransportFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 *2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001*B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u001c\u0010#\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020&H\u0016J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00160\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lwo/lf/lifx/api/LightService;", "Lwo/lf/lifx/api/ILightSource;", "Lwo/lf/lifx/api/LifxMessage;", "Lwo/lf/lifx/domain/LifxMessagePayload;", "transportFactory", "Lwo/lf/lifx/net/TransportFactory;", "changeDispatcher", "Lwo/lf/lifx/api/ILightsChangeDispatcher;", "lightFactory", "Lwo/lf/lifx/api/ILightFactory;", "ioScheduler", "Lio/reactivex/Scheduler;", "observeScheduler", "(Lwo/lf/lifx/net/TransportFactory;Lwo/lf/lifx/api/ILightsChangeDispatcher;Lwo/lf/lifx/api/ILightFactory;Lio/reactivex/Scheduler;Lio/reactivex/Scheduler;)V", "disposables", "Lio/reactivex/disposables/CompositeDisposable;", "getIoScheduler", "()Lio/reactivex/Scheduler;", "legacyTransport", "Lwo/lf/lifx/net/Transport;", "messages", "Lio/reactivex/Flowable;", "Lwo/lf/lifx/net/SourcedLifxMessage;", "getMessages", "()Lio/reactivex/Flowable;", "sourceId", "", "getSourceId", "()I", "tick", "Lio/reactivex/Observable;", "", "getTick", "()Lio/reactivex/Observable;", "transport", "send", "", "message", "Lwo/lf/lifx/net/TargetedLifxMessage;", "start", "", "stop", "Companion", "RxLifxKotlin"})
public final class LightService
implements ILightSource<LifxMessage<? extends LifxMessagePayload>> {
    private final Transport<LifxMessage<LifxMessagePayload>> transport;
    private final Transport<LifxMessage<LifxMessagePayload>> legacyTransport;
    @NotNull
    private final Flowable<SourcedLifxMessage<LifxMessage<LifxMessagePayload>>> messages;
    @NotNull
    private final Observable<Long> tick;
    private final int sourceId;
    private final CompositeDisposable disposables;
    private final ILightsChangeDispatcher changeDispatcher;
    private final ILightFactory lightFactory;
    @NotNull
    private final Scheduler ioScheduler;
    public static final long REFRESH_INTERVAL_SECONDS = 5L;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Flowable<SourcedLifxMessage<LifxMessage<LifxMessagePayload>>> getMessages() {
        return this.messages;
    }

    @Override
    @NotNull
    public Observable<Long> getTick() {
        return this.tick;
    }

    @Override
    public int getSourceId() {
        return this.sourceId;
    }

    @Override
    public boolean send(@NotNull TargetedLifxMessage<? extends LifxMessage<? extends LifxMessagePayload>> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        return this.transport.send(message);
    }

    public final void start() {
        this.disposables.add(this.getMessages().groupBy((Function)start.1.INSTANCE).subscribe((Consumer)new Consumer<GroupedFlowable<Long, SourcedLifxMessage<? extends LifxMessage<? extends LifxMessagePayload>>>>(this){
            final /* synthetic */ LightService this$0;

            public final void accept(GroupedFlowable<Long, SourcedLifxMessage<LifxMessage<LifxMessagePayload>>> lightMessages) {
                Light light;
                ILightFactory iLightFactory = LightService.access$getLightFactory$p(this.this$0);
                GroupedFlowable<Long, SourcedLifxMessage<LifxMessage<LifxMessagePayload>>> groupedFlowable = lightMessages;
                Intrinsics.checkExpressionValueIsNotNull(groupedFlowable, (String)"lightMessages");
                Object object = groupedFlowable.getKey();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"lightMessages.key!!");
                Light $receiver = light = iLightFactory.create(((Number)object).longValue(), this.this$0, LightService.access$getChangeDispatcher$p(this.this$0));
                LightService.access$getChangeDispatcher$p(this.this$0).onLightAdded($receiver);
                LightService.access$getDisposables$p(this.this$0).add($receiver.attach(lightMessages));
            }
            {
                this.this$0 = lightService;
            }
        }));
        this.disposables.add(this.getTick().subscribe((Consumer)new Consumer<Long>(this){
            final /* synthetic */ LightService this$0;

            public final void accept(Long it) {
                RxExtensionsKt.fireAndForget(BroadcastGetServiceCommand.INSTANCE.create(this.this$0));
            }
            {
                this.this$0 = lightService;
            }
        }));
        RxExtensionsKt.fireAndForget(BroadcastGetServiceCommand.INSTANCE.create(this));
    }

    public final void stop() {
        this.disposables.clear();
    }

    @Override
    @NotNull
    public Scheduler getIoScheduler() {
        return this.ioScheduler;
    }

    public LightService(@NotNull TransportFactory transportFactory, @NotNull ILightsChangeDispatcher changeDispatcher2, @NotNull ILightFactory lightFactory, @NotNull Scheduler ioScheduler, @NotNull Scheduler observeScheduler) {
        Intrinsics.checkParameterIsNotNull((Object)transportFactory, (String)"transportFactory");
        Intrinsics.checkParameterIsNotNull((Object)changeDispatcher2, (String)"changeDispatcher");
        Intrinsics.checkParameterIsNotNull((Object)lightFactory, (String)"lightFactory");
        Intrinsics.checkParameterIsNotNull((Object)ioScheduler, (String)"ioScheduler");
        Intrinsics.checkParameterIsNotNull((Object)observeScheduler, (String)"observeScheduler");
        this.changeDispatcher = changeDispatcher2;
        this.lightFactory = lightFactory;
        this.ioScheduler = ioScheduler;
        this.transport = transportFactory.create(0, new LifxMessageParserImpl());
        this.legacyTransport = transportFactory.create(Lifx.INSTANCE.getDefaultPort(), new LifxMessageParserImpl());
        Flowable flowable = LightServiceKt.access$retryConnect(this.transport.getMessages()).subscribeOn(this.getIoScheduler()).mergeWith((Publisher)LightServiceKt.access$retryConnect(this.legacyTransport.getMessages()).subscribeOn(this.getIoScheduler())).observeOn(observeScheduler);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"transport.messages.retry\u2026serveOn(observeScheduler)");
        Flowable flowable2 = LifxDomainExtensionsKt.discardBroadcasts((Flowable<SourcedLifxMessage<LifxMessage<LifxMessagePayload>>>)flowable).share();
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable2, (String)"transport.messages.retry\u2026scardBroadcasts().share()");
        this.messages = flowable2;
        Observable observable = Observable.interval((long)5L, (TimeUnit)TimeUnit.SECONDS).share();
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.interval(REFR\u2026TimeUnit.SECONDS).share()");
        this.tick = observable;
        this.sourceId = (int)(Math.random() * (double)Integer.MAX_VALUE);
        this.disposables = new CompositeDisposable();
    }

    public /* synthetic */ LightService(TransportFactory transportFactory, ILightsChangeDispatcher iLightsChangeDispatcher, ILightFactory iLightFactory, Scheduler scheduler, Scheduler scheduler2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            iLightFactory = DefaultLightFactory.INSTANCE;
        }
        if ((n & 8) != 0) {
            Scheduler scheduler3 = Schedulers.io();
            Intrinsics.checkExpressionValueIsNotNull((Object)scheduler3, (String)"Schedulers.io()");
            scheduler = scheduler3;
        }
        if ((n & 0x10) != 0) {
            Scheduler scheduler4 = Schedulers.single();
            Intrinsics.checkExpressionValueIsNotNull((Object)scheduler4, (String)"Schedulers.single()");
            scheduler2 = scheduler4;
        }
        this(transportFactory, iLightsChangeDispatcher, iLightFactory, scheduler, scheduler2);
    }

    @NotNull
    public static final /* synthetic */ ILightFactory access$getLightFactory$p(LightService $this) {
        return $this.lightFactory;
    }

    @NotNull
    public static final /* synthetic */ ILightsChangeDispatcher access$getChangeDispatcher$p(LightService $this) {
        return $this.changeDispatcher;
    }

    @NotNull
    public static final /* synthetic */ CompositeDisposable access$getDisposables$p(LightService $this) {
        return $this.disposables;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lwo/lf/lifx/api/LightService$Companion;", "", "()V", "REFRESH_INTERVAL_SECONDS", "", "RxLifxKotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

