/*
 * Decompiled with CFR 0.152.
 */
package wo.lf.lifx.net;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.NotYetConnectedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import wo.lf.lifx.domain.Lifx;
import wo.lf.lifx.net.DatagramSocketFactory;
import wo.lf.lifx.net.DefaultDatagramSocketFactory;
import wo.lf.lifx.net.LifxMessageParser;
import wo.lf.lifx.net.SourcedLifxMessage;
import wo.lf.lifx.net.TargetedLifxMessage;
import wo.lf.lifx.net.Transport;
import wo.lf.lifx.net.TransportFactory;
import wo.lf.lifx.net.UdpTransport;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0019B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012RJ\u0010\u0013\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0016*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00150\u0015 \u0016*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0016*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00150\u0015\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lwo/lf/lifx/net/UdpTransport;", "T", "Lwo/lf/lifx/net/Transport;", "port", "", "parser", "Lwo/lf/lifx/net/LifxMessageParser;", "datagramSocketFactory", "Lwo/lf/lifx/net/DatagramSocketFactory;", "(ILwo/lf/lifx/net/LifxMessageParser;Lwo/lf/lifx/net/DatagramSocketFactory;)V", "isConnected", "", "messages", "Lio/reactivex/Flowable;", "Lwo/lf/lifx/net/SourcedLifxMessage;", "getMessages", "()Lio/reactivex/Flowable;", "getPort", "()I", "publisher", "Lio/reactivex/subjects/PublishSubject;", "Lwo/lf/lifx/net/TargetedLifxMessage;", "kotlin.jvm.PlatformType", "send", "message", "Companion", "RxLifxKotlin"})
public final class UdpTransport<T>
implements Transport<T> {
    private final PublishSubject<TargetedLifxMessage<T>> publisher;
    private boolean isConnected;
    @NotNull
    private final Flowable<SourcedLifxMessage<T>> messages;
    private final int port;
    private final LifxMessageParser<T> parser;
    private final DatagramSocketFactory datagramSocketFactory;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Flowable<SourcedLifxMessage<T>> getMessages() {
        return this.messages;
    }

    @Override
    public boolean send(@NotNull TargetedLifxMessage<? extends T> message) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.isConnected) {
            this.publisher.onNext(message);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final int getPort() {
        return this.port;
    }

    public UdpTransport(int port, @NotNull LifxMessageParser<T> parser, @NotNull DatagramSocketFactory datagramSocketFactory) {
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Intrinsics.checkParameterIsNotNull((Object)datagramSocketFactory, (String)"datagramSocketFactory");
        this.port = port;
        this.parser = parser;
        this.datagramSocketFactory = datagramSocketFactory;
        this.publisher = PublishSubject.create();
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(this){
            final /* synthetic */ UdpTransport this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void subscribe(@NotNull FlowableEmitter<SourcedLifxMessage<T>> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                DatagramSocket datagramSocket = UdpTransport.access$getDatagramSocketFactory$p(this.this$0).create();
                Object $receiver = datagramSocket;
                ((DatagramSocket)$receiver).setReuseAddress(true);
                ((DatagramSocket)$receiver).bind(new InetSocketAddress(this.this$0.getPort()));
                DatagramSocket channel = datagramSocket;
                Object $receiver2 = $receiver = ByteBuffer.allocate(1024);
                ((ByteBuffer)$receiver2).clear();
                ((ByteBuffer)$receiver2).order(ByteOrder.LITTLE_ENDIAN);
                Object buffer = $receiver;
                DatagramPacket datagram = new DatagramPacket(((ByteBuffer)buffer).array(), 1024);
                Disposable disposable2 = UdpTransport.access$getPublisher$p(this.this$0).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<TargetedLifxMessage<? extends T>>(this, channel){
                    final /* synthetic */ messages.1 this$0;
                    final /* synthetic */ DatagramSocket $channel;

                    public final void accept(TargetedLifxMessage<? extends T> it) {
                        try {
                            ByteBuffer byteBuffer;
                            ByteBuffer $receiver = byteBuffer = UdpTransport.access$getParser$p(this.this$0.this$0).serialise(it.getMessage());
                            this.$channel.send(new DatagramPacket($receiver.array(), $receiver.position(), it.getTarget(), Lifx.INSTANCE.getDefaultPort()));
                        }
                        catch (NotYetConnectedException e) {
                            this.$channel.close();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$channel = datagramSocket;
                    }
                });
                UdpTransport.access$setConnected$p(this.this$0, true);
                emitter.setCancellable(new Cancellable(this, channel){
                    final /* synthetic */ messages.1 this$0;
                    final /* synthetic */ DatagramSocket $channel;

                    public final void cancel() {
                        if (UdpTransport.access$isConnected$p(this.this$0.this$0)) {
                            this.$channel.close();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$channel = datagramSocket;
                    }
                });
                try {
                    while (!emitter.isCancelled()) {
                        short size;
                        int startingPosition = ((Buffer)buffer).position();
                        ((ByteBuffer)buffer).mark();
                        channel.receive(datagram);
                        for (int length = datagram.getLength(); length >= 36; length -= size) {
                            ((ByteBuffer)buffer).mark();
                            size = ((ByteBuffer)buffer).getShort(((Buffer)buffer).position());
                            short type = ((ByteBuffer)buffer).getShort(((Buffer)buffer).position() + 32);
                            if (length >= size) {
                                LifxMessageParser lifxMessageParser = UdpTransport.access$getParser$p(this.this$0);
                                Object object = buffer;
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"buffer");
                                if (lifxMessageParser.parse((ByteBuffer)object, size, type) != null) {
                                    T t;
                                    T message = t;
                                    InetAddress inetAddress = datagram.getAddress();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"datagram.address");
                                    emitter.onNext(new SourcedLifxMessage<T>(message, inetAddress));
                                }
                            }
                            if (((Buffer)buffer).position() != length + startingPosition) continue;
                            ((ByteBuffer)buffer).clear();
                        }
                    }
                }
                catch (IOException e) {
                    if (!emitter.isCancelled()) {
                        emitter.onError((Throwable)e);
                    }
                }
                catch (Exception e) {
                    if (!emitter.isCancelled()) {
                        emitter.onError((Throwable)e);
                    }
                }
                finally {
                    UdpTransport.access$setConnected$p(this.this$0, false);
                    disposable2.dispose();
                    channel.disconnect();
                }
            }
            {
                this.this$0 = udpTransport;
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.create({ emitte\u2026kpressureStrategy.BUFFER)");
        this.messages = flowable;
    }

    public /* synthetic */ UdpTransport(int n, LifxMessageParser lifxMessageParser, DatagramSocketFactory datagramSocketFactory, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            datagramSocketFactory = DefaultDatagramSocketFactory.INSTANCE;
        }
        this(n, lifxMessageParser, datagramSocketFactory);
    }

    @NotNull
    public static final /* synthetic */ DatagramSocketFactory access$getDatagramSocketFactory$p(UdpTransport $this) {
        return $this.datagramSocketFactory;
    }

    public static final /* synthetic */ PublishSubject access$getPublisher$p(UdpTransport $this) {
        return $this.publisher;
    }

    @NotNull
    public static final /* synthetic */ LifxMessageParser access$getParser$p(UdpTransport $this) {
        return $this.parser;
    }

    public static final /* synthetic */ boolean access$isConnected$p(UdpTransport $this) {
        return $this.isConnected;
    }

    public static final /* synthetic */ void access$setConnected$p(UdpTransport $this, boolean bl) {
        $this.isConnected = bl;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0016\u00a8\u0006\n"}, d2={"Lwo/lf/lifx/net/UdpTransport$Companion;", "Lwo/lf/lifx/net/TransportFactory;", "()V", "create", "Lwo/lf/lifx/net/Transport;", "T", "port", "", "parser", "Lwo/lf/lifx/net/LifxMessageParser;", "RxLifxKotlin"})
    public static final class Companion
    implements TransportFactory {
        @Override
        @NotNull
        public <T> Transport<T> create(int port, @NotNull LifxMessageParser<T> parser) {
            Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
            return new UdpTransport(port, parser, null, 4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

