/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class EjbUtils {
    public EjbUtils() throws ClassNotFoundException {
        this.getClass().getClassLoader().loadClass("javax.ejb.EntityBean");
    }

    public String getEjbName(JavaClass clazz) {
        String result = clazz.getNamedParameter("ejb.bean", "name");
        if (result == null) {
            result = clazz.getName();
        }
        return result;
    }

    public Collection getInterfaceMethods(final JavaClass clazz, final String desiredViewType) {
        if (clazz == null || desiredViewType == null) {
            throw new Error();
        }
        return CollectionUtils.select(Arrays.asList(clazz.getMethods()), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                JavaMethod method = (JavaMethod)object;
                String viewType = method.getNamedParameter("ejb.interface-method", "view-type");
                if (viewType == null) {
                    viewType = clazz.getNamedParameter("ejb.bean", "view-type");
                }
                if (viewType != null) {
                    boolean isRemote;
                    boolean isLocal = "local".equals(viewType) || "both".equals(viewType);
                    boolean bl = isRemote = "remote".equals(viewType) || "both".equals(viewType);
                    if (desiredViewType.equals("local")) {
                        return isLocal;
                    }
                    if (desiredViewType.equals("remote")) {
                        return isRemote;
                    }
                }
                return false;
            }
        });
    }

    public boolean shouldGenerate(Object metadata) {
        JavaClass javaClass = (JavaClass)metadata;
        boolean isEjb = javaClass.isA("javax.ejb.EntityBean");
        boolean ignore = "false".equals(javaClass.getNamedParameter("ejb.bean", "generate"));
        return isEjb && !ignore;
    }
}

