/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.xdoclet.plugin.ejb.EjbRuntime;
import org.xdoclet.plugin.ejb.EjbUtils;
import org.xdoclet.plugin.ejb.entity.PrimaryKeyClassPlugin;
import org.xdoclet.plugin.ejb.qtags.EjbFinderTag;
import org.xdoclet.plugin.ejb.util.DuplicatedJavaMethod;

public class EjbHomeUtils {
    public static final String COMPLETE_NAME_CONST_NAME = "COMP_NAME";
    public static final String JNDI_NAME_CONST_NAME = "JNDI_NAME";
    protected EjbUtils ejbUtils;
    static /* synthetic */ Class class$javax$ejb$CreateException;
    static /* synthetic */ Class class$javax$ejb$FinderException;

    public EjbHomeUtils(EjbUtils ejbUtils) {
        this.ejbUtils = ejbUtils;
    }

    public String getJndiNameConst() {
        return JNDI_NAME_CONST_NAME;
    }

    public String getCompleteNameConst() {
        return COMPLETE_NAME_CONST_NAME;
    }

    protected JavaMethod fixReturnType(JavaMethod method, Type newType) {
        method = new DuplicatedJavaMethod(method);
        method.setReturns(newType);
        return method;
    }

    protected JavaMethod fixFinderReturnType(JavaMethod method, Type newType) {
        String returnType = method.getReturns().toString();
        boolean isColection = false;
        isColection |= returnType.equals("java.util.Collection");
        isColection |= returnType.equals("java.util.Enumeration");
        if (!(isColection |= returnType.equals("java.util.Set"))) {
            method = this.fixReturnType(method, newType);
        }
        return method;
    }

    public Collection getCreateMethods(final JavaClass javaClass, final int viewType, final Type newType) {
        Collection createMethods = CollectionUtils.select(Arrays.asList(javaClass.getMethods(true)), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                JavaMethod method = (JavaMethod)object;
                boolean retVal = EjbUtils.hasFlag(EjbHomeUtils.this.ejbUtils.getMethodType(method), 2);
                retVal = retVal && EjbUtils.hasFlag(EjbHomeUtils.this.ejbUtils.getViewType(method, javaClass), viewType);
                return retVal;
            }
        });
        if ((createMethods = CollectionUtils.collect((Collection)createMethods, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return EjbHomeUtils.this.ejbUtils.externalizeMethodName((JavaMethod)object);
            }
        })).size() == 0 && this.ejbUtils.isStateLess(javaClass)) {
            JavaMethod createMethod = new JavaMethod();
            createMethod.setName("create");
            createMethods.add(createMethod);
        }
        createMethods = CollectionUtils.collect((Collection)createMethods, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return EjbHomeUtils.this.fixReturnType((JavaMethod)object, newType);
            }
        });
        createMethods = this.ejbUtils.injectMethodThrowException(createMethods, class$javax$ejb$CreateException == null ? (class$javax$ejb$CreateException = EjbHomeUtils.class$("javax.ejb.CreateException")) : class$javax$ejb$CreateException);
        return createMethods;
    }

    public Collection getHomeMethods(final JavaClass clazz, final int viewType) {
        Collection homeMethods = CollectionUtils.select(Arrays.asList(clazz.getMethods(true)), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                JavaMethod method = (JavaMethod)object;
                boolean retVal = EjbUtils.hasFlag(EjbHomeUtils.this.ejbUtils.getMethodType(method), 4);
                retVal = retVal && EjbUtils.hasFlag(EjbHomeUtils.this.ejbUtils.getViewType(method, clazz), viewType);
                return retVal;
            }
        });
        homeMethods = CollectionUtils.collect((Collection)homeMethods, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return EjbHomeUtils.this.ejbUtils.externalizeMethodName((JavaMethod)object);
            }
        });
        return homeMethods;
    }

    public Collection getFinderMethods(final JavaClass javaClass, final int viewType, final Type newType) throws Error {
        if (!this.ejbUtils.isEntityBean(javaClass)) {
            throw new Error("This must only be called for Entity Beans");
        }
        Collection finderMethods = CollectionUtils.select(Arrays.asList(javaClass.getMethods(true)), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                JavaMethod method = (JavaMethod)object;
                boolean retVal = EjbUtils.hasFlag(EjbHomeUtils.this.ejbUtils.getMethodType(method), 16);
                retVal = retVal && EjbUtils.hasFlag(EjbHomeUtils.this.ejbUtils.getViewType(method, javaClass), viewType);
                return retVal;
            }
        });
        finderMethods = CollectionUtils.collect((Collection)finderMethods, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return EjbHomeUtils.this.ejbUtils.externalizeMethodName((JavaMethod)object);
            }
        });
        Collection finderMethodsBySignature = CollectionUtils.select(Arrays.asList(javaClass.getTagsByName("ejb.finder", true)), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                EjbFinderTag finderTag = (EjbFinderTag)object;
                boolean retVal = finderTag.getResultTypeMapping() == null || finderTag.getResultTypeMapping().equals("Remote");
                retVal = retVal && EjbUtils.hasFlag(EjbHomeUtils.this.ejbUtils.getViewType(finderTag.getViewType()), viewType);
                return retVal;
            }
        });
        finderMethods.addAll(CollectionUtils.collect((Collection)finderMethodsBySignature, (Transformer)new Transformer(){

            public Object transform(Object object) {
                EjbFinderTag finderTag = (EjbFinderTag)object;
                return EjbHomeUtils.this.ejbUtils.getFinderMethodBySignature(finderTag.getSignature());
            }
        }));
        int count = CollectionUtils.countMatches((Collection)finderMethods, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                JavaMethod method = (JavaMethod)object;
                return "findByPrimaryKey".equals(method.getName());
            }
        });
        if (count == 0) {
            PrimaryKeyClassPlugin pkPlugin = EjbRuntime.getPrimaryKeyClassPlugin();
            JavaParameter javaParameter = new JavaParameter(new Type(pkPlugin.pkClass(javaClass)), "pk");
            JavaMethod finderMethod = new JavaMethod();
            finderMethod.setName("findByPrimaryKey");
            finderMethod.setParameters(new JavaParameter[]{javaParameter});
            finderMethods.add(finderMethod);
        }
        finderMethods = CollectionUtils.collect((Collection)finderMethods, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return EjbHomeUtils.this.fixFinderReturnType((JavaMethod)object, newType);
            }
        });
        finderMethods = this.ejbUtils.injectMethodThrowException(finderMethods, class$javax$ejb$FinderException == null ? (class$javax$ejb$FinderException = EjbHomeUtils.class$("javax.ejb.FinderException")) : class$javax$ejb$FinderException);
        return finderMethods;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

