/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb;

import java.util.HashMap;
import java.util.Map;

public class EjbIds {
    private static EjbIds instance = new EjbIds();
    private Map idManagers = new HashMap();

    private EjbIds() {
    }

    public static EjbIds get() {
        return instance;
    }

    private synchronized IdManager getManager(String prefix) {
        IdManager manager = (IdManager)this.idManagers.get(prefix);
        if (manager == null) {
            manager = new IdManager(prefix);
            this.idManagers.put(prefix, manager);
        }
        return manager;
    }

    public static String escapeId(String id) {
        String retVal = id.replace(' ', '_');
        retVal = retVal.replace('-', '_');
        retVal = retVal.replace('/', '_');
        return retVal;
    }

    public String prefixedId(String prefix) {
        IdManager manager = this.getManager(prefix);
        return manager.getId();
    }

    private final class IdManager {
        private int count = 0;
        private String prefix;

        public IdManager(String prefix) {
            this.prefix = prefix;
        }

        private synchronized int inc() {
            return ++this.count;
        }

        public String getId() {
            return EjbIds.escapeId(this.prefix + ' ' + this.inc());
        }
    }
}

