/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb;

import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.generama.MetadataProvider;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.VelocityTemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.JavaGeneratingPlugin;
import org.xdoclet.plugin.ejb.EjbConfig;
import org.xdoclet.plugin.ejb.EjbJavaType;
import org.xdoclet.plugin.ejb.EjbTypeResolver;
import org.xdoclet.plugin.ejb.EjbUtils;
import org.xdoclet.plugin.ejb.EjbVersion;
import org.xdoclet.plugin.ejb.qtags.TagLibrary;

public abstract class EjbJavaGeneratingPlugin
extends JavaGeneratingPlugin
implements EjbTypeResolver {
    protected final Log log;
    private final VelocityTemplateEngine templateEngine;
    protected final EjbConfig config;
    protected final EjbUtils ejbUtils;
    protected File mergeDir;
    protected String fileregex;
    protected String filereplace;
    protected String packageregex;
    protected String packagereplace;

    public EjbJavaGeneratingPlugin(VelocityTemplateEngine templateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper, EjbConfig config) {
        super((TemplateEngine)templateEngine, metadataProvider, writerMapper);
        this.templateEngine = templateEngine;
        this.config = config;
        this.ejbUtils = new EjbUtils(config);
        this.log = this.getLog();
        this.registerTagLibraries(metadataProvider);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.getClass().getName() + " constructor was called."));
        }
    }

    protected void registerTagLibraries(QDoxCapableMetadataProvider provider) {
        new TagLibrary((MetadataProvider)provider);
    }

    public void setFileregex(String fileregex) {
        if (fileregex == null) {
            throw new NullPointerException();
        }
        this.fileregex = fileregex;
        super.setFileregex(fileregex);
    }

    protected void populateContextMap(Map map) {
        super.populateContextMap(map);
        map.put("util", this.getEjbUtils());
        map.put("version", this.getVersion());
    }

    public EjbVersion getVersion() {
        return this.getConfig().getEjbVersion();
    }

    public EjbUtils getEjbUtils() {
        return this.ejbUtils;
    }

    public EjbConfig getConfig() {
        return this.config;
    }

    public static Log getLog(Class clazz) {
        return LogFactory.getLog((Class)clazz);
    }

    public Log getLog() {
        return EjbJavaGeneratingPlugin.getLog(this.getClass());
    }

    public Log getLogEx() {
        StackTraceElement[] stack = new Exception().getStackTrace();
        StackTraceElement callingMethod = stack[1];
        return LogFactory.getLog((String)(callingMethod.getClassName() + '.' + callingMethod.getMethodName()));
    }

    public void setFilereplace(String filereplace) {
        if (filereplace == null) {
            throw new NullPointerException();
        }
        this.filereplace = filereplace;
        super.setFilereplace(filereplace);
    }

    public void setPackageregex(String packageregex) {
        if (packageregex == null) {
            throw new NullPointerException();
        }
        this.packageregex = packageregex;
        super.setPackageregex(packageregex);
    }

    public void setPackagereplace(String packagereplace) {
        if (packagereplace == null) {
            throw new NullPointerException();
        }
        this.packagereplace = packagereplace;
        super.setPackagereplace(packagereplace);
    }

    protected String getLocalyDefinedFullClassName(JavaClass clazz) {
        return null;
    }

    protected String getLocalyDefinedPackageName(JavaClass clazz) {
        return null;
    }

    protected String getPatternBasedUnqualifiedName(JavaClass clazz) {
        return null;
    }

    public EjbJavaType getPhysicalType(JavaClass clazz) {
        EjbJavaType retType = null;
        String fullType = this.getLocalyDefinedFullClassName(clazz);
        if (fullType != null) {
            retType = new EjbJavaType(fullType);
        }
        if (retType == null) {
            String javaPackage;
            String unqualifiedName = this.getPatternBasedUnqualifiedName(clazz);
            if (unqualifiedName == null) {
                unqualifiedName = clazz.getName();
                unqualifiedName = unqualifiedName.replaceAll(this.fileregex, this.filereplace);
            }
            if ((javaPackage = this.getLocalyDefinedPackageName(clazz)) == null) {
                javaPackage = clazz.getPackage();
                javaPackage = javaPackage.replaceAll(this.packageregex, this.packagereplace);
            }
            retType = new EjbJavaType(javaPackage, unqualifiedName);
        }
        return retType;
    }

    public EjbJavaType getVirtualType(JavaClass clazz) {
        return this.getPhysicalType(clazz);
    }

    public String getDestinationFilename(Object metadata) {
        return this.getPhysicalType((JavaClass)metadata).getName() + ".java";
    }

    public String getDestinationPackage(Object metadata) {
        return this.getPhysicalType((JavaClass)metadata).getPackage();
    }

    protected void preGenerate() {
    }

    public String getSetterName(BeanProperty prop) {
        StringBuffer retBuf = new StringBuffer(prop.getName());
        retBuf.setCharAt(0, Character.toUpperCase(retBuf.charAt(0)));
        retBuf.insert(0, "set");
        return retBuf.toString();
    }

    public String getGetterName(BeanProperty prop) {
        StringBuffer retBuf = new StringBuffer(prop.getName());
        retBuf.setCharAt(0, Character.toUpperCase(retBuf.charAt(0)));
        if (prop.getType().isA(new Type("boolean")) || prop.getType().isA(new Type("java.lang.Boolean"))) {
            retBuf.insert(0, "is");
        } else {
            retBuf.insert(0, "get");
        }
        return retBuf.toString();
    }

    public void setMergedir(File mergeDir) {
        this.mergeDir = mergeDir;
    }

    public File getMergeFile(String mergeFile) {
        if (mergeFile != null && this.mergeDir != null && this.mergeDir.isDirectory()) {
            File[] files = this.mergeDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!mergeFile.trim().equals(files[i].getName())) continue;
                return files[i];
            }
        }
        return null;
    }

    public String getPad(int depth) {
        StringBuffer retBuf = new StringBuffer();
        while (depth-- > 1) {
            retBuf.append("    ");
        }
        return retBuf.toString();
    }
}

