/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.generama.MetadataProvider;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.QDoxPlugin;
import org.xdoclet.plugin.ejb.EjbConfig;
import org.xdoclet.plugin.ejb.EjbUtils;
import org.xdoclet.plugin.ejb.EjbVersion;
import org.xdoclet.plugin.ejb.qtags.TagLibrary;

public abstract class EjbQDoxPlugin
extends QDoxPlugin {
    protected Log log;
    protected final EjbConfig config;
    protected final EjbUtils ejbUtils;
    private File mergeDir;

    public EjbQDoxPlugin(TemplateEngine templateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper, EjbConfig config) {
        super(templateEngine, metadataProvider, writerMapper);
        this.config = config;
        this.ejbUtils = new EjbUtils(config);
        this.log = this.getLog();
        this.registerTagLibraries(metadataProvider);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(((Object)((Object)this)).getClass().getName() + " constructor was called."));
        }
    }

    protected void registerTagLibraries(QDoxCapableMetadataProvider provider) {
        new TagLibrary((MetadataProvider)provider);
    }

    public static Log getLog(Class clazz) {
        return LogFactory.getLog((Class)clazz);
    }

    public Log getLog() {
        return EjbQDoxPlugin.getLog(((Object)((Object)this)).getClass());
    }

    public Log getLogEx() {
        StackTraceElement[] stack = new Exception().getStackTrace();
        StackTraceElement callingMethod = stack[1];
        return LogFactory.getLog((String)(callingMethod.getClassName() + '.' + callingMethod.getMethodName()));
    }

    public EjbConfig getConfig() {
        return this.config;
    }

    public EjbVersion getVersion() {
        return this.getConfig().getEjbVersion();
    }

    public EjbUtils getEjbUtils() {
        return this.ejbUtils;
    }

    public void setMergedir(File mergeDir) {
        this.mergeDir = mergeDir;
    }

    public File getMergeFile(String mergeFile) {
        if (mergeFile != null && this.mergeDir != null && this.mergeDir.isDirectory()) {
            File[] files = this.mergeDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!mergeFile.trim().equals(files[i].getName())) continue;
                return files[i];
            }
        }
        return null;
    }
}

