/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb;

import org.xdoclet.plugin.ejb.EjbConfig;
import org.xdoclet.plugin.ejb.descriptor.EjbJarXmlPlugin;
import org.xdoclet.plugin.ejb.entity.PrimaryKeyClassPlugin;
import org.xdoclet.plugin.ejb.interfaces.LocalHomeInterfacePlugin;
import org.xdoclet.plugin.ejb.interfaces.LocalInterfacePlugin;
import org.xdoclet.plugin.ejb.interfaces.RemoteHomeInterfacePlugin;
import org.xdoclet.plugin.ejb.interfaces.RemoteInterfacePlugin;
import org.xdoclet.plugin.ejb.interfaces.ServiceEndpointPlugin;

public class EjbRuntime {
    protected static EjbRuntime instance;
    protected final EjbConfig config;
    protected EjbJarXmlPlugin ejbJarXmlPlugin;
    protected PrimaryKeyClassPlugin primaryKeyClassPlugin;
    protected LocalHomeInterfacePlugin localHomeInterfacePlugin;
    protected LocalInterfacePlugin localInterfacePlugin;
    protected RemoteHomeInterfacePlugin remoteHomeInterfacePlugin;
    protected RemoteInterfacePlugin remoteInterfacePlugin;
    protected ServiceEndpointPlugin serviceEndpointPlugin;

    protected EjbRuntime(EjbConfig config) {
        this.config = config;
    }

    public static synchronized void init(EjbConfig config) {
        if (config == null) {
            throw new Error("NullPointerException");
        }
        if (instance == null) {
            instance = new EjbRuntime(config);
        }
    }

    public static LocalInterfacePlugin getLocalInterfacePlugin() {
        EjbRuntime.checkInit();
        return instance._getLocalInterfacePlugin();
    }

    public static RemoteHomeInterfacePlugin getRemoteHomeInterfacePlugin() {
        EjbRuntime.checkInit();
        return instance._getRemoteHomeInterfacePlugin();
    }

    public static RemoteInterfacePlugin getRemoteInterfacePlugin() {
        EjbRuntime.checkInit();
        return instance._getRemoteInterfacePlugin();
    }

    public static ServiceEndpointPlugin getServiceEndpointPlugin() {
        EjbRuntime.checkInit();
        return instance._getServiceEndpointPlugin();
    }

    protected synchronized ServiceEndpointPlugin _getServiceEndpointPlugin() {
        if (this.serviceEndpointPlugin == null) {
            this.serviceEndpointPlugin = new ServiceEndpointPlugin(null, this.config.getMetadataProvider(), null, this.config);
        }
        return this.serviceEndpointPlugin;
    }

    protected synchronized LocalInterfacePlugin _getLocalInterfacePlugin() {
        if (this.localInterfacePlugin == null) {
            this.localInterfacePlugin = new LocalInterfacePlugin(null, this.config.getMetadataProvider(), null, this.config);
        }
        return this.localInterfacePlugin;
    }

    protected synchronized RemoteHomeInterfacePlugin _getRemoteHomeInterfacePlugin() {
        if (this.remoteHomeInterfacePlugin == null) {
            this.remoteHomeInterfacePlugin = new RemoteHomeInterfacePlugin(null, this.config.getMetadataProvider(), null, this.config);
        }
        return this.remoteHomeInterfacePlugin;
    }

    protected synchronized RemoteInterfacePlugin _getRemoteInterfacePlugin() {
        if (this.remoteInterfacePlugin == null) {
            this.remoteInterfacePlugin = new RemoteInterfacePlugin(null, this.config.getMetadataProvider(), null, this.config);
        }
        return this.remoteInterfacePlugin;
    }

    public static EjbJarXmlPlugin getEjbJarXmlPlugin() {
        EjbRuntime.checkInit();
        return instance._getEjbJarXmlPlugin();
    }

    protected synchronized EjbJarXmlPlugin _getEjbJarXmlPlugin() {
        if (this.ejbJarXmlPlugin == null) {
            this.ejbJarXmlPlugin = new EjbJarXmlPlugin(null, this.config.getMetadataProvider(), null, this.config);
        }
        return this.ejbJarXmlPlugin;
    }

    public static PrimaryKeyClassPlugin getPrimaryKeyClassPlugin() {
        EjbRuntime.checkInit();
        return instance._getPrimaryKeyClassPlugin();
    }

    protected synchronized PrimaryKeyClassPlugin _getPrimaryKeyClassPlugin() {
        if (this.primaryKeyClassPlugin == null) {
            this.primaryKeyClassPlugin = new PrimaryKeyClassPlugin(null, this.config.getMetadataProvider(), null, this.config);
        }
        return this.primaryKeyClassPlugin;
    }

    public static LocalHomeInterfacePlugin getLocalHomeInterfacePlugin() {
        EjbRuntime.checkInit();
        return instance._getLocalHomeInterfacePlugin();
    }

    protected synchronized LocalHomeInterfacePlugin _getLocalHomeInterfacePlugin() {
        if (this.localHomeInterfacePlugin == null) {
            this.localHomeInterfacePlugin = new LocalHomeInterfacePlugin(null, this.config.getMetadataProvider(), null, this.config);
        }
        return this.localHomeInterfacePlugin;
    }

    public static void setPlugin(PrimaryKeyClassPlugin plugin) {
        if (plugin == null) {
            throw new Error("NullPointerException");
        }
        EjbRuntime.checkInit();
        instance._setPlugin(plugin);
    }

    public static void setPlugin(EjbJarXmlPlugin plugin) {
        if (plugin == null) {
            throw new Error("NullPointerException");
        }
        EjbRuntime.checkInit();
        instance._setPlugin(plugin);
    }

    public static void setPlugin(LocalHomeInterfacePlugin plugin) {
        if (plugin == null) {
            throw new Error("NullPointerException");
        }
        EjbRuntime.checkInit();
        instance._setPlugin(plugin);
    }

    public static void setPlugin(LocalInterfacePlugin plugin) {
        if (plugin == null) {
            throw new Error("NullPointerException");
        }
        EjbRuntime.checkInit();
        instance._setPlugin(plugin);
    }

    public static void setPlugin(RemoteHomeInterfacePlugin plugin) {
        if (plugin == null) {
            throw new Error("NullPointerException");
        }
        EjbRuntime.checkInit();
        instance._setPlugin(plugin);
    }

    public static void setPlugin(RemoteInterfacePlugin plugin) {
        if (plugin == null) {
            throw new Error("NullPointerException");
        }
        EjbRuntime.checkInit();
        instance._setPlugin(plugin);
    }

    public static void setPlugin(ServiceEndpointPlugin plugin) {
        if (plugin == null) {
            throw new Error("NullPointerException");
        }
        EjbRuntime.checkInit();
        instance._setPlugin(plugin);
    }

    protected synchronized void _setPlugin(ServiceEndpointPlugin plugin) {
        this.serviceEndpointPlugin = plugin;
    }

    protected synchronized void _setPlugin(RemoteInterfacePlugin plugin) {
        this.remoteInterfacePlugin = plugin;
    }

    protected synchronized void _setPlugin(RemoteHomeInterfacePlugin plugin) {
        this.remoteHomeInterfacePlugin = plugin;
    }

    protected synchronized void _setPlugin(LocalInterfacePlugin plugin) {
        this.localInterfacePlugin = plugin;
    }

    protected synchronized void _setPlugin(LocalHomeInterfacePlugin plugin) {
        this.localHomeInterfacePlugin = plugin;
    }

    protected synchronized void _setPlugin(EjbJarXmlPlugin plugin) {
        this.ejbJarXmlPlugin = plugin;
    }

    protected synchronized void _setPlugin(PrimaryKeyClassPlugin plugin) {
        this.primaryKeyClassPlugin = plugin;
    }

    protected static synchronized void checkInit() {
        if (instance == null) {
            throw new Error("EjbRuntime wasn't initialized");
        }
    }

    public static EjbConfig getConfig() {
        EjbRuntime.checkInit();
        return instance._getConfig();
    }

    protected EjbConfig _getConfig() {
        return this.config;
    }
}

