/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.generama.ConfigurableDocletTagFactory;
import org.xdoclet.plugin.ejb.EjbBeanResolver;
import org.xdoclet.plugin.ejb.EjbConfig;
import org.xdoclet.plugin.ejb.EjbRuntime;
import org.xdoclet.plugin.ejb.EjbVersion;
import org.xdoclet.plugin.ejb.Relation;
import org.xdoclet.plugin.ejb.RelationManager;
import org.xdoclet.plugin.ejb.qtags.EjbActivationConfigPropertyTag;
import org.xdoclet.plugin.ejb.qtags.EjbBeanTag;
import org.xdoclet.plugin.ejb.qtags.EjbEjbExternalRefTag;
import org.xdoclet.plugin.ejb.qtags.EjbEjbRefTag;
import org.xdoclet.plugin.ejb.qtags.EjbEjbServiceRefTag;
import org.xdoclet.plugin.ejb.qtags.EjbFinderTag;
import org.xdoclet.plugin.ejb.qtags.EjbPermissionTag;
import org.xdoclet.plugin.ejb.qtags.EjbPkTag;
import org.xdoclet.plugin.ejb.qtags.EjbRelationTag;
import org.xdoclet.plugin.ejb.qtags.EjbResourceEnvRefTag;
import org.xdoclet.plugin.ejb.qtags.EjbResourceRefTag;
import org.xdoclet.plugin.ejb.qtags.EjbTransactionTag;
import org.xdoclet.plugin.ejb.qtags.parameter.RoleList;
import org.xdoclet.plugin.ejb.util.DuplicatedJavaMethod;

public class EjbUtils {
    public static final int REMOTE = 1;
    public static final int REMOTE_HOME = 2;
    public static final int LOCAL = 4;
    public static final int LOCAL_HOME = 8;
    public static final int SERVICE_END_POINT = 16;
    public static final int BEAN_EJB = 1;
    public static final int BEAN_ENTITY = 2;
    public static final int BEAN_BMP = 4;
    public static final int BEAN_CMP = 8;
    public static final int BEAN_SESSION = 16;
    public static final int BEAN_STATE_FULL = 32;
    public static final int BEAN_STATE_LESS = 64;
    public static final int BEAN_MESSAGE_DRIVEN = 128;
    public static final int TAG_FIND_CLASS = 1;
    public static final int TAG_FIND_METHOD = 2;
    public static final int TAG_FIND_FIELD = 4;
    public static final int TAG_FIND_RECURSIVE = 8;
    public static final int IFACE_METHOD_COMPONENT = 1;
    public static final int IFACE_METHOD_CREATE = 2;
    public static final int IFACE_METHOD_HOME = 4;
    public static final int IFACE_METHOD_REMOVE = 8;
    public static final int IFACE_METHOD_FINDER = 16;
    public static final int IFACE_METHOD_SELECT = 32;
    public static final int METADATA_METHOD_PERSISTENCE_FIELD = 64;
    public static final int METADATA_METHOD_PRIMARY_KEY_FIELD = 128;
    public static final int METADATA_METHOD_RELATION_FIELD = 256;
    public static final String REMOTE_INTERFACE = "Remote";
    public static final String REMOTE_HOME_INTERFACE = "Home";
    public static final String LOCAL_INTERFACE = "Local";
    public static final String LOCAL_HOME_INTERFACE = "LocalHome";
    public static final String SERVICE_END_POINT_INTERFACE = "ServiceEndpoint";
    protected static Log log = LogFactory.getLog((Class)(class$org$xdoclet$plugin$ejb$EjbUtils == null ? (class$org$xdoclet$plugin$ejb$EjbUtils = EjbUtils.class$("org.xdoclet.plugin.ejb.EjbUtils")) : class$org$xdoclet$plugin$ejb$EjbUtils));
    private static final Map wrappers;
    private static final Pattern methodPattern;
    private static final Pattern paramPattern;
    private static final Pattern dimensionPattern;
    private final EjbConfig config;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$EjbUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$EjbUtils$RelationImpl;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$EjbUtils$RelationManagerImpl;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$EjbUtils$EjbBeanResolverImpl;

    public EjbUtils() {
        this(EjbRuntime.getConfig());
    }

    public EjbUtils(EjbConfig config) {
        this.config = config;
    }

    public String getEjbName(JavaClass clazz) {
        String result = clazz.getNamedParameter("ejb.bean", "name");
        if (result == null) {
            result = clazz.getName();
            result = result.replaceAll(this.config.getEjbReplaceRegex(), "");
        }
        return result;
    }

    public String expandPattern(String pattern, String arg) {
        return this.expandPattern(pattern, new String[]{arg});
    }

    public String expandPattern(String pattern, String[] args) {
        if (pattern == null) {
            return null;
        }
        String formattedName = MessageFormat.format(pattern, args);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expanded value is '" + formattedName + "'"));
        }
        return formattedName;
    }

    public String expandPattern(String pattern, JavaClass clazz) {
        if (pattern == null) {
            return null;
        }
        String ejbName = this.getEjbName(clazz);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expanding pattern '" + pattern + "' with ejb name as argument '" + ejbName + "'"));
        }
        return this.expandPattern(pattern, ejbName);
    }

    public int getMethodType(JavaMethod method) {
        int retVal = 0;
        if (method.getTagByName("ejb.interface-method") != null) {
            retVal = 1;
        } else if (method.getName().equals("ejbCreate") && method.getTagByName("ejb.create-method") != null) {
            retVal = 2;
        } else if (method.getName().startsWith("ejbHome") && method.getName().length() > "ejbHome".length() && method.getTagByName("ejb.home-method") != null) {
            retVal = 4;
        } else if (method.getName().equals("ejbRemove")) {
            retVal = 8;
        } else if (method.getName().startsWith("ejbFind") && method.getName().length() > "ejbFind".length()) {
            if (method.getReturns() != null && !method.getReturns().isVoid()) {
                retVal = 16;
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Inconsistent return type for finder method. Ignoring method. " + method.getDeclarationSignature(true)));
            }
        } else if (method.getName().startsWith("ejbSelect") && method.getName().length() > "ejbSelect".length()) {
            if (method.getReturns() != null && !method.getReturns().isVoid()) {
                retVal = 32;
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Inconsistent return type for select method. Ignoring method. Return-type=" + method.getDeclarationSignature(true)));
            }
        }
        return retVal;
    }

    public int getMethodMetadata(JavaMethod method) {
        return this.getMethodMetadata(method.getParentClass(), method);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMethodMetadata(JavaClass javaClass, JavaMethod method) {
        int retVal = this.getMethodType(method);
        EjbBeanTag beanTag = (EjbBeanTag)javaClass.getTagByName("ejb.bean");
        DocletTag tag = method.getTagByName("ejb.persistence-field");
        if (tag != null) {
            if (method.isPropertyAccessor()) {
                retVal |= 0x40;
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Ignoring ejb.persistence-field tag. It should be place on property accessor. " + method.getDeclarationSignature(true) + " - " + EjbUtils.tagToString(tag)));
            }
        } else {
            tag = method.getTagByName("ejb.relation");
            if (tag != null) {
                if (method.isPropertyAccessor()) {
                    retVal |= 0x100;
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)("Ignoring ejb.relation tag. It should be place on property accessor." + method.getDeclarationSignature(true) + " - " + EjbUtils.tagToString(tag)));
                }
            }
        }
        if (beanTag != null && beanTag.getPrimkeyField() != null) {
            BeanProperty prop = javaClass.getBeanProperty(beanTag.getPrimkeyField());
            try {
                if (prop == null || prop.getAccessor() == null) {
                    throw this.getErrorWithTagLocation(beanTag, "Could not find getter for prim-key-field: " + beanTag.getPrimkeyField());
                }
                if (method != prop.getAccessor()) return retVal;
                retVal |= 0x80;
                return retVal;
            }
            catch (Error e) {
                log.error((Object)e.getMessage());
                throw e;
            }
        } else {
            tag = method.getTagByName("ejb.pk-field");
            if (tag == null) return retVal;
            if (method.isPropertyAccessor()) {
                retVal |= 0x80;
                return retVal;
            } else {
                if (!log.isWarnEnabled()) return retVal;
                log.warn((Object)("Ignoring ejb.pk-field tag. It should be place on property accessor." + method.getDeclarationSignature(true) + " - " + EjbUtils.tagToString(tag)));
            }
        }
        return retVal;
    }

    public Collection getBeans(Collection metadata) {
        return this.getBeans(metadata, 1);
    }

    public Collection getCMPBeans(Collection metadata) {
        return this.getBeans(metadata, 8);
    }

    public Collection getBMPBeans(Collection metadata) {
        return this.getBeans(metadata, 4);
    }

    public Collection getEntityBeans(Collection metadata) {
        return this.getBeans(metadata, 2);
    }

    public Collection getSessionBeans(Collection metadata) {
        return this.getBeans(metadata, 16);
    }

    public Collection getMessageDrivenBeans(Collection metadata) {
        return this.getBeans(metadata, 128);
    }

    public Collection getStateFullBeans(Collection metadata) {
        return this.getBeans(metadata, 32);
    }

    public Collection getStateLessBeans(Collection metadata) {
        return this.getBeans(metadata, 64);
    }

    public Collection getBeans(Collection metadata, final int beanType) {
        return CollectionUtils.select((Collection)metadata, (Predicate)new Predicate(){

            public boolean evaluate(Object meta) {
                JavaClass javaClass = (JavaClass)meta;
                return EjbUtils.hasFlag(EjbUtils.this.getBeanType(javaClass), beanType);
            }
        });
    }

    public Collection getSelectMethods(JavaClass clazz) {
        if (!this.isCMP(clazz)) {
            return null;
        }
        return CollectionUtils.select(Arrays.asList(clazz.getMethods(true)), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                JavaMethod method = (JavaMethod)object;
                int methodType = EjbUtils.this.getMethodType(method);
                boolean retVal = EjbUtils.hasFlag(methodType, 32);
                retVal = retVal && method.isAbstract();
                retVal = retVal && method.isPublic();
                return retVal;
            }
        });
    }

    public static boolean hasFlag(int fullFlag, int checkFlag) {
        return (fullFlag & checkFlag) == checkFlag;
    }

    public Collection getCMPFields(JavaClass clazz) {
        if (clazz == null) {
            throw new Error();
        }
        if (!this.isCMP(clazz)) {
            return null;
        }
        return CollectionUtils.select(Arrays.asList(clazz.getMethods(true)), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                int methodFlags = EjbUtils.this.getMethodMetadata((JavaMethod)object);
                return EjbUtils.hasFlag(methodFlags, 64);
            }
        });
    }

    public boolean shouldGenerate(Object metadata) {
        JavaClass javaClass = (JavaClass)metadata;
        boolean isEjb = this.isEJB(javaClass);
        EjbBeanTag beanTag = (EjbBeanTag)javaClass.getTagByName("ejb.bean");
        boolean ignore = beanTag != null && !beanTag.isGenerate();
        return isEjb && !ignore;
    }

    public String firstSentence(String comment) {
        if (comment == null) {
            return null;
        }
        int idx = comment.indexOf(10);
        return idx >= 0 ? comment.substring(0, idx) : comment;
    }

    public String description(JavaClass javaClass) {
        String description = javaClass.getNamedParameter("ejb.bean", "description");
        if (description == null) {
            description = this.firstSentence(javaClass.getComment());
        }
        if (description == null) {
            description = "No description";
        }
        return description;
    }

    public JavaMethod getFinderMethodBySignature(String finderSignature) {
        return this.getMethodBySignature(finderSignature);
    }

    public JavaMethod getMethodBySignature(String signature) {
        Matcher matcher = methodPattern.matcher(signature);
        if (matcher.matches()) {
            JavaMethod method = new JavaMethod(new Type(matcher.group(1)), matcher.group(2));
            matcher = paramPattern.matcher(matcher.group(3));
            int beginIdx = 0;
            int count = 0;
            String paramType = null;
            String paramName = null;
            ArrayList<JavaParameter> paramLst = new ArrayList<JavaParameter>();
            while (matcher.find(beginIdx)) {
                int paramDim = 0;
                if (matcher.group(1) != null) {
                    paramType = matcher.group(2) + (matcher.group(4) != null ? matcher.group(4) : "");
                    paramName = matcher.group(3);
                } else {
                    paramType = matcher.group(6);
                    paramName = "_arg" + count++;
                }
                Matcher dMatcher = dimensionPattern.matcher(paramType);
                if (dMatcher.find()) {
                    paramType = paramType.substring(0, dMatcher.start());
                    paramDim = 1;
                    while (dMatcher.find(dMatcher.end())) {
                        ++paramDim;
                    }
                }
                paramLst.add(new JavaParameter(new Type(paramType, paramDim), paramName));
                beginIdx = matcher.end();
            }
            method.setParameters(paramLst.toArray(new JavaParameter[0]));
            return method;
        }
        throw new Error("Invalid finder signature '" + signature + "'");
    }

    public boolean isViewType(JavaClass javaClass, String viewType) {
        return EjbUtils.hasFlag(this.getViewType(javaClass), this.getViewType(viewType));
    }

    public int getInterfaceType(String ifaceType) {
        EjbVersion version = this.config.getEjbVersion();
        int retVal = 0;
        if (REMOTE_INTERFACE.equals(ifaceType)) {
            retVal |= 1;
        } else if (REMOTE_HOME_INTERFACE.equals(ifaceType)) {
            retVal |= 2;
        } else if (LOCAL_INTERFACE.equals(ifaceType)) {
            retVal |= 4;
        } else if (LOCAL_HOME_INTERFACE.equals(ifaceType)) {
            retVal |= 8;
        } else if (version.greaterOrEquals("2.1") && SERVICE_END_POINT_INTERFACE.equals(ifaceType)) {
            retVal |= 0x10;
        }
        return retVal;
    }

    public int getViewType(String viewType) {
        EjbVersion version = this.config.getEjbVersion();
        int retVal = 0;
        viewType = viewType.toLowerCase();
        if (version.greaterOrEquals("2.1")) {
            if ("all".equals(viewType)) {
                retVal |= 0x10;
            } else if (viewType.indexOf("service-endpoint") != -1) {
                retVal |= 0x10;
            }
        }
        if ("both".equals(viewType) || "all".equals(viewType)) {
            retVal |= 3;
            retVal |= 0xC;
        }
        if (viewType.indexOf("remote") != -1) {
            retVal |= 3;
        }
        if (viewType.indexOf("local") != -1) {
            retVal |= 0xC;
        }
        return retVal;
    }

    public int getViewType(JavaClass javaClass) {
        EjbVersion version = this.config.getEjbVersion();
        String viewType = javaClass.getNamedParameter("ejb.bean", "view-type");
        if (!version.greaterOrEquals("2.0")) {
            viewType = "remote";
        }
        if (viewType == null) {
            viewType = "both";
        }
        return this.getViewType(viewType);
    }

    public int getViewType(JavaMethod method, JavaClass javaClass) {
        int beanViewType = this.getViewType(javaClass);
        int retVal = 0;
        int filterMask = beanViewType;
        String viewType = null;
        int methodType = this.getMethodType(method);
        switch (methodType) {
            case 1: {
                viewType = method.getNamedParameter("ejb.interface-method", "view-type");
                retVal = viewType != null ? this.getViewType(viewType) : beanViewType;
                filterMask &= 0xFFFFFFF5;
                break;
            }
            case 2: {
                viewType = method.getNamedParameter("ejb.create-method", "view-type");
                retVal = viewType != null ? this.getViewType(viewType) : beanViewType;
                filterMask &= 0xA;
                break;
            }
            case 4: {
                viewType = method.getNamedParameter("ejb.home-method", "view-type");
                retVal = viewType != null ? this.getViewType(viewType) : beanViewType;
                filterMask &= 0xA;
                break;
            }
            case 8: 
            case 16: 
            case 32: {
                retVal = 10;
                break;
            }
        }
        return retVal &= filterMask;
    }

    public boolean isEJB(JavaClass javaClass) {
        return EjbUtils.hasFlag(this.getBeanType(javaClass), 1);
    }

    public boolean isCMP(JavaClass javaClass) {
        return EjbUtils.hasFlag(this.getBeanType(javaClass), 8);
    }

    public boolean isBMP(JavaClass javaClass) {
        return EjbUtils.hasFlag(this.getBeanType(javaClass), 4);
    }

    public boolean isEntityBean(JavaClass javaClass) {
        return EjbUtils.hasFlag(this.getBeanType(javaClass), 2);
    }

    public boolean isSessionBean(JavaClass javaClass) {
        return EjbUtils.hasFlag(this.getBeanType(javaClass), 16);
    }

    public boolean isMessageDrivenBean(JavaClass javaClass) {
        return EjbUtils.hasFlag(this.getBeanType(javaClass), 128);
    }

    public boolean isStateFull(JavaClass javaClass) {
        return EjbUtils.hasFlag(this.getBeanType(javaClass), 32);
    }

    public boolean isStateLess(JavaClass javaClass) {
        return EjbUtils.hasFlag(this.getBeanType(javaClass), 64);
    }

    public int getBeanType(JavaClass javaClass) {
        EjbVersion version = this.config.getEjbVersion();
        String beanType = javaClass.getNamedParameter("ejb.bean", "type");
        int retVal = 0;
        if (javaClass.isA("javax.ejb.EntityBean")) {
            retVal |= 1;
            retVal |= 2;
            retVal = beanType != null && "bmp".equalsIgnoreCase(beanType) ? (retVal |= 4) : (retVal |= 8);
        } else if (javaClass.isA("javax.ejb.SessionBean")) {
            retVal |= 1;
            retVal |= 0x10;
            retVal = beanType != null && "stateful".equalsIgnoreCase(beanType) ? (retVal |= 0x20) : (retVal |= 0x40);
        } else if (version.greaterOrEquals("2.0") && javaClass.isA("javax.ejb.MessageDrivenBean")) {
            retVal |= 1;
            retVal |= 0x80;
        }
        return retVal;
    }

    public String reentrant(JavaClass javaClass) {
        EjbVersion version = this.config.getEjbVersion();
        String reentrant = javaClass.getNamedParameter("ejb.bean", "reentrant");
        String retVal = Boolean.valueOf(reentrant).toString();
        if (!version.greaterOrEquals("2.1")) {
            retVal = retVal.substring(0, 1).toUpperCase() + retVal.substring(1);
        }
        return retVal;
    }

    public String persistenceType(JavaClass javaClass) {
        int beanType = this.getBeanType(javaClass);
        String retVal = null;
        if (EjbUtils.hasFlag(beanType, 8)) {
            retVal = "Container";
        } else if (EjbUtils.hasFlag(beanType, 4)) {
            retVal = "Bean";
        }
        return retVal;
    }

    public String entityType(JavaClass javaClass) {
        int beanType = this.getBeanType(javaClass);
        if (EjbUtils.hasFlag(beanType, 2)) {
            return "entity";
        }
        if (EjbUtils.hasFlag(beanType, 16)) {
            return "session";
        }
        if (EjbUtils.hasFlag(beanType, 128)) {
            return "message-driven";
        }
        return null;
    }

    public String beanType(JavaClass javaClass) {
        int beanType = this.getBeanType(javaClass);
        if (EjbUtils.hasFlag(beanType, 2)) {
            return "Entity";
        }
        if (EjbUtils.hasFlag(beanType, 16)) {
            return "Session";
        }
        if (EjbUtils.hasFlag(beanType, 128)) {
            return "Message Driven";
        }
        return null;
    }

    public String sessionType(JavaClass javaClass) {
        int beanType = this.getBeanType(javaClass);
        String retVal = null;
        if (EjbUtils.hasFlag(beanType, 32)) {
            retVal = "Stateful";
        } else if (EjbUtils.hasFlag(beanType, 64)) {
            retVal = "Stateless";
        }
        return retVal;
    }

    public String getNamedParameter(AbstractJavaEntity javaEntity, String tagName, String parameterName, String defValue) {
        String value = javaEntity.getNamedParameter(tagName, parameterName);
        if (value == null) {
            value = defValue;
        }
        return value;
    }

    public String getNamedParameter(DocletTag tag, String parameterName, String defValue) {
        String value = tag.getNamedParameter(parameterName);
        if (value == null) {
            value = defValue;
        }
        return value;
    }

    public boolean hasActivationConfig(JavaClass javaClass) {
        EjbBeanTag beanTag = (EjbBeanTag)javaClass.getTagByName("ejb.bean");
        EjbActivationConfigPropertyTag actTag = (EjbActivationConfigPropertyTag)javaClass.getTagByName("ejb.activation-config-property");
        boolean retVal = false;
        if (beanTag != null) {
            retVal |= beanTag.getDestinationType() != null;
            retVal |= beanTag.getAcknowledgeMode() != null;
            retVal |= beanTag.getSubscriptionDurability() != null;
            retVal |= beanTag.getMessageSelector() != null;
        }
        return retVal |= actTag != null;
    }

    public boolean isUseSoftLocking(JavaClass javaClass) {
        EjbBeanTag beanTag = (EjbBeanTag)javaClass.getTagByName("ejb.bean");
        return beanTag != null && beanTag.isUseSoftLocking();
    }

    public Collection findTagsByName(JavaClass javaClass, String tagName) {
        ArrayList list = new ArrayList();
        this.findTagsByNameRecursive(list, javaClass, tagName, 15);
        return list;
    }

    private void findTagsByNameRecursive(List list, JavaClass javaClass, String tagName, int findFlags) {
        int j;
        int i;
        DocletTag[] tags;
        if (EjbUtils.hasFlag(findFlags, 1)) {
            tags = javaClass.getTagsByName(tagName);
            for (int i2 = 0; i2 < tags.length; ++i2) {
                list.add(new TagReference(tags[i2], javaClass));
            }
        }
        if (EjbUtils.hasFlag(findFlags, 2)) {
            JavaMethod[] methods = javaClass.getMethods();
            for (i = 0; i < methods.length; ++i) {
                tags = methods[i].getTagsByName(tagName);
                for (j = 0; j < tags.length; ++j) {
                    list.add(new TagReference(tags[j], methods[i]));
                }
            }
        }
        if (EjbUtils.hasFlag(findFlags, 4)) {
            JavaField[] fields = javaClass.getFields();
            for (i = 0; i < fields.length; ++i) {
                tags = fields[i].getTagsByName(tagName);
                for (j = 0; j < tags.length; ++j) {
                    list.add(new TagReference(tags[j], fields[i]));
                }
            }
        }
        if (EjbUtils.hasFlag(findFlags, 8)) {
            JavaClass superclass = javaClass.getSuperJavaClass();
            if (superclass != null && superclass != javaClass) {
                this.findTagsByNameRecursive(list, superclass, tagName, findFlags);
            }
            JavaClass[] implementz = javaClass.getImplementedInterfaces();
            for (int h = 0; h < implementz.length; ++h) {
                if (implementz[h] == null) continue;
                this.findTagsByNameRecursive(list, implementz[h], tagName, findFlags);
            }
        }
    }

    private Type wrapType(Type type) {
        Type wrapperType = (Type)wrappers.get(type.toString());
        return wrapperType != null ? wrapperType : type;
    }

    public String refType(TagReference reference) {
        DocletTag tag = reference.getTag();
        String refType = null;
        String paramName = null;
        if (tag instanceof EjbEjbServiceRefTag) {
            refType = ((EjbEjbServiceRefTag)tag).getInterface();
            paramName = "interface";
        } else if (tag instanceof EjbResourceRefTag) {
            refType = ((EjbResourceRefTag)tag).getResType();
            paramName = "res-type";
        } else if (tag instanceof EjbResourceEnvRefTag) {
            refType = ((EjbResourceEnvRefTag)tag).getType();
            paramName = "type";
        } else {
            throw this.getErrorWithTagLocation(tag, "Unexpected tag type");
        }
        if (reference.getClazz() != null) {
            if (refType == null) {
                throw this.getErrorWithTagLocation(tag, "'" + paramName + "' is mandatory for class level tag");
            }
        } else if (reference.getField() != null) {
            refType = this.wrapType(reference.getField().getType()).toString();
        } else if (reference.getMethod() != null) {
            if (reference.getMethod().getReturns().isVoid()) {
                throw this.getErrorWithTagLocation(tag, "Cannot set @" + tag.getName() + " on a method with a void return type");
            }
            refType = this.wrapType(reference.getMethod().getReturns()).toString();
        }
        if (refType == null) {
            throw this.getErrorWithTagLocation(tag, "'" + paramName + "' could not be resolved");
        }
        return refType;
    }

    public Error getErrorWithTagLocation(DocletTag tag, String message) {
        return new Error(EjbUtils.tagToString(tag) + ": " + message);
    }

    public static String getMessageWithTagLocation(DocletTag tag, String message) {
        return EjbUtils.tagToString(tag) + ": " + message;
    }

    public static String getMessageWithMethodLocation(JavaMethod method, String message) {
        return EjbUtils.methodToString(method) + ": " + message;
    }

    public static String methodToString(JavaMethod method) {
        StringBuffer locationBuf = new StringBuffer();
        locationBuf.append(method.getParentClass().getFullyQualifiedName());
        locationBuf.append(':');
        locationBuf.append(method.getDeclarationSignature(false));
        return locationBuf.toString();
    }

    public static String tagToString(DocletTag tag) {
        StringBuffer retBuf = new StringBuffer();
        retBuf.append("@");
        retBuf.append(tag.getName());
        retBuf.append(" ");
        retBuf.append(tag.getValue());
        retBuf.append(" (");
        retBuf.append(ConfigurableDocletTagFactory.getLocation((DocletTag)tag));
        retBuf.append(":");
        retBuf.append(tag.getLineNumber());
        retBuf.append(")");
        return retBuf.toString();
    }

    public String refName(TagReference reference) {
        DocletTag tag = reference.getTag();
        String refName = null;
        String paramName = null;
        if (tag instanceof EjbEjbServiceRefTag) {
            refName = ((EjbEjbServiceRefTag)tag).getName_();
            paramName = "name";
        } else if (tag instanceof EjbResourceRefTag) {
            refName = ((EjbResourceRefTag)tag).getResRefName();
            paramName = "res-ref-name";
        } else if (tag instanceof EjbResourceEnvRefTag) {
            refName = ((EjbResourceEnvRefTag)tag).getName_();
            paramName = "name";
        } else {
            throw this.getErrorWithTagLocation(tag, "Unexpected tag type");
        }
        if (refName == null) {
            if (reference.getClazz() != null) {
                throw this.getErrorWithTagLocation(tag, "'" + paramName + "' is mandatory for class level tag");
            }
            if (reference.getField() != null) {
                refName = reference.getField().getName();
            } else if (reference.getMethod() != null) {
                refName = reference.getMethod().getName();
            }
        }
        if (refName == null) {
            throw this.getErrorWithTagLocation(tag, "'" + paramName + "' could not be resolved");
        }
        return refName;
    }

    public String ejbRefName(TagReference reference) {
        return this.ejbRefName(reference, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String ejbRefName(TagReference reference, JavaClass refClass) {
        DocletTag tag = reference.getTag();
        String ejbRefName = null;
        String viewType = null;
        String paramName = null;
        if (tag instanceof EjbEjbRefTag) {
            ejbRefName = ((EjbEjbRefTag)tag).getRefName();
            viewType = ((EjbEjbRefTag)tag).getViewType();
            paramName = "ref-name";
        } else {
            if (!(tag instanceof EjbEjbExternalRefTag)) throw this.getErrorWithTagLocation(tag, "Unexpected tag type");
            ejbRefName = ((EjbEjbExternalRefTag)tag).getRefName();
            viewType = ((EjbEjbExternalRefTag)tag).getViewType();
            paramName = "ref-name";
        }
        if (ejbRefName == null) {
            if (reference.getClazz() != null) {
                if (refClass == null) throw this.getErrorWithTagLocation(tag, "'" + paramName + "' is mandatory for class level tag");
                ejbRefName = this.ejbJndiName(refClass, this.isRemoteEjbRef(viewType, refClass) ? 1 : 4);
            } else if (reference.getField() != null) {
                ejbRefName = reference.getField().getName();
            } else if (reference.getMethod() != null) {
                ejbRefName = reference.getMethod().getName();
            }
        }
        if (ejbRefName != null) return ejbRefName;
        throw this.getErrorWithTagLocation(tag, "'" + paramName + "' could not be resolved");
    }

    public String ejbJndiName(JavaClass clazz, int viewType) {
        StringBuffer retName = new StringBuffer();
        retName.append("ejb/");
        retName.append(this.jndiName(clazz, viewType));
        return retName.toString();
    }

    public String jndiName(JavaClass clazz, int viewType) {
        String ejbName = this.getEjbName(clazz);
        ejbName = ejbName.replace('.', '/');
        StringBuffer retName = new StringBuffer(ejbName);
        if (viewType == 4) {
            retName.append(LOCAL_INTERFACE);
        } else if (viewType == 1) {
            retName.append(REMOTE_INTERFACE);
        }
        return retName.toString();
    }

    public boolean isLocalEjbRef(String viewType, JavaClass refClass) {
        return this.isEjbRefType(viewType, refClass, 4);
    }

    public boolean isLocalEjbRef(String viewType) {
        return this.isEjbRefType(viewType, 4);
    }

    public boolean isRemoteEjbRef(String viewType, JavaClass refClass) {
        return this.isEjbRefType(viewType, refClass, 1) && !this.isEjbRefType(viewType, refClass, 4);
    }

    public boolean isRemoteEjbRef(String viewType) {
        return this.isEjbRefType(viewType, 1) && !this.isEjbRefType(viewType, 4);
    }

    private boolean isEjbRefType(String viewType, JavaClass refClass, int desiredView) {
        int beanType = viewType != null ? this.getViewType(viewType) & this.getViewType(refClass) : this.getViewType(refClass);
        return EjbUtils.hasFlag(beanType, desiredView);
    }

    private boolean isEjbRefType(String viewType, int desiredView) {
        return EjbUtils.hasFlag(this.getViewType(viewType), desiredView);
    }

    public JavaClass findEjbRef(String ejbName, EjbBeanResolver beanResolver) {
        JavaClass javaClass = beanResolver.findEjbByName(ejbName);
        if (javaClass == null) {
            throw new Error("Couldn't find named ejb: " + ejbName);
        }
        int beanType = this.getBeanType(javaClass);
        if (!EjbUtils.hasFlag(beanType, 2) && !EjbUtils.hasFlag(beanType, 16)) {
            throw new Error("Referenced bean must be a session bean or entity bean: " + ejbName);
        }
        return javaClass;
    }

    public JavaMethod externalizeMethodName(JavaMethod method) {
        int methodType = this.getMethodType(method);
        String removeString = null;
        switch (methodType) {
            case 2: 
            case 16: 
            case 32: {
                removeString = "ejb";
                break;
            }
            case 4: {
                removeString = "ejbHome";
            }
        }
        JavaMethod retVal = method;
        if (removeString != null) {
            retVal = this.removeFromMethodName(method, removeString);
        }
        return retVal;
    }

    private JavaMethod removeFromMethodName(JavaMethod method, String removeString) {
        if (!method.getName().startsWith(removeString) || method.getName().length() <= removeString.length()) {
            throw new Error("Method name: " + method.getName() + ", must start with " + removeString);
        }
        StringBuffer methodName = new StringBuffer(method.getName());
        methodName.delete(0, removeString.length());
        methodName.setCharAt(0, Character.toLowerCase(methodName.charAt(0)));
        method = new DuplicatedJavaMethod(method);
        method.setName(methodName.toString());
        return method;
    }

    public Collection getSecurityRoles(Collection metadata) {
        ArrayList<DocletTag> roleTags = new ArrayList<DocletTag>();
        Collection ejbBeans = this.getBeans(metadata);
        Iterator iter = ejbBeans.iterator();
        while (iter.hasNext()) {
            JavaClass javaClass = (JavaClass)iter.next();
            roleTags.addAll(Arrays.asList(javaClass.getTagsByName("ejb.permission")));
            JavaMethod[] methods = javaClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                int methodType;
                if (methods[i].getTagByName("ejb.permission") != null && (methodType = this.getMethodType(methods[i])) != 2 && methodType != 1) {
                    throw this.getErrorWithTagLocation(methods[i].getTagByName("ejb.permission"), "Can't mark a method permission on a non interface or create method");
                }
                roleTags.addAll(Arrays.asList(methods[i].getTagsByName("ejb.permission")));
            }
            if (this.isEntityBean(javaClass)) {
                roleTags.addAll(Arrays.asList(javaClass.getTagsByName("ejb.finder")));
                roleTags.addAll(Arrays.asList(javaClass.getTagsByName("ejb.pk")));
            }
            roleTags.addAll(Arrays.asList(javaClass.getTagsByName("ejb.security-roles")));
        }
        TreeSet<String> roles = new TreeSet<String>();
        Iterator iter2 = roleTags.iterator();
        while (iter2.hasNext()) {
            RoleList roleLst = (RoleList)iter2.next();
            if (roleLst == null || roleLst.getRoleNames() == null) continue;
            roles.addAll(Arrays.asList(roleLst.getRoleNames()));
        }
        return roles;
    }

    public RelationManager createRelationManager(Collection metadata) {
        Collection cmpBeans = CollectionUtils.select((Collection)this.getBeans(metadata, 8), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                JavaClass javaClass = (JavaClass)arg0;
                boolean retVal = EjbUtils.this.shouldGenerate(javaClass);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(javaClass.getFullyQualifiedName() + (retVal ? " is a concrete bean" : " isn't a concrete bean")));
                }
                return retVal;
            }
        });
        RelationManagerImpl manager = new RelationManagerImpl();
        Iterator iter = cmpBeans.iterator();
        while (iter.hasNext()) {
            JavaClass javaClass = (JavaClass)iter.next();
            JavaMethod[] methods = javaClass.getMethods(true);
            for (int i = 0; i < methods.length; ++i) {
                if (!EjbUtils.hasFlag(this.getMethodMetadata(javaClass, methods[i]), 256)) continue;
                manager.manage((EjbRelationTag)methods[i].getTagByName("ejb.relation"), methods[i], javaClass);
            }
        }
        return manager;
    }

    public Collection getMethodPermissions(JavaClass javaClass) {
        EjbVersion version = this.config.getEjbVersion();
        ArrayList retLst = new ArrayList();
        if (!this.isEJB(javaClass)) {
            throw new Error();
        }
        DocletTag[] tags = javaClass.getTagsByName("ejb.permission");
        for (int i = 0; i < tags.length; ++i) {
            boolean canContinue;
            EjbPermissionTag permTag = (EjbPermissionTag)tags[i];
            int permType = this.getViewType(javaClass);
            if (permTag.getViewType() != null) {
                permType &= this.getViewType(permTag.getViewType());
            } else if (permTag.getMethodIntf() != null) {
                permType &= this.getInterfaceType(permTag.getMethodIntf());
            }
            if (permType == 0) {
                throw this.getErrorWithTagLocation(permTag, "Couldn't resolve a compatible interface type reference. Maybe bean/view-type/version doesn't support it!");
            }
            boolean bl = canContinue = permTag.getRoleNames() != null && permTag.getRoleNames().length > 0;
            if (version.greaterOrEquals("2.0")) {
                canContinue |= permTag.isUnchecked();
            }
            if (!canContinue) {
                throw this.getErrorWithTagLocation(permTag, "Couldn't resolve role-names for method permission" + (version.greaterOrEquals("2.0") ? " or unchecked is false" : ""));
            }
            retLst.addAll(MethodPermission.unroll(permType, permTag.getRoleNames()));
        }
        JavaMethod[] methods = javaClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            JavaMethod method = methods[j];
            tags = method.getTagsByName("ejb.permission");
            for (int k = 0; k < tags.length; ++k) {
                boolean canContinue;
                EjbPermissionTag permTag = (EjbPermissionTag)tags[k];
                int methodType = this.getMethodType(method);
                if (methodType != 2 && methodType != 1) {
                    throw this.getErrorWithTagLocation(permTag, "Can't mark a method permission on a non interface or create method");
                }
                int permType = this.getViewType(method, javaClass);
                if (permTag.getViewType() != null) {
                    permType &= this.getViewType(permTag.getViewType());
                } else if (permTag.getMethodIntf() != null) {
                    permType &= this.getInterfaceType(permTag.getMethodIntf());
                }
                if (permType == 0) {
                    throw this.getErrorWithTagLocation(permTag, "Couldn't resolve a compatible interface type reference.  Maybe bean/view-type/version doesn't support it!");
                }
                boolean bl = canContinue = permTag.getRoleNames() != null && permTag.getRoleNames().length > 0;
                if (version.greaterOrEquals("2.0")) {
                    canContinue |= permTag.isUnchecked();
                }
                if (!canContinue) {
                    throw this.getErrorWithTagLocation(permTag, "Couldn't resolve role-names for method permission" + (version.greaterOrEquals("2.0") ? " or unchecked is false" : ""));
                }
                retLst.addAll(MethodPermission.unroll(permType, this.externalizeMethodName(method), permTag.getRoleNames()));
            }
        }
        if (this.isEntityBean(javaClass)) {
            tags = javaClass.getTagsByName("ejb.finder");
            for (int i = 0; i < tags.length; ++i) {
                boolean canContinue;
                EjbFinderTag finderTag = (EjbFinderTag)tags[i];
                int permType = this.getViewType(finderTag.getViewType()) & 0xA;
                if (finderTag.getMethodIntf() != null) {
                    permType &= this.getInterfaceType(finderTag.getMethodIntf());
                }
                if (permType == 0) {
                    throw this.getErrorWithTagLocation(finderTag, "Couldn't resolve a compatible interface type reference. Maybe bean/view-type/version doesn't support it!");
                }
                boolean bl = canContinue = finderTag.getRoleNames() != null && finderTag.getRoleNames().length > 0;
                if (version.greaterOrEquals("2.0")) {
                    canContinue |= finderTag.isUnchecked();
                }
                if (!canContinue) {
                    throw this.getErrorWithTagLocation(finderTag, "Couldn't resolve role-names for method permission" + (version.greaterOrEquals("2.0") ? " or unchecked is false" : ""));
                }
                retLst.addAll(MethodPermission.unroll(permType, this.getFinderMethodBySignature(finderTag.getSignature()), finderTag.getRoleNames()));
            }
            EjbPkTag pkTag = (EjbPkTag)javaClass.getTagByName("ejb.pk");
            if (pkTag != null) {
                boolean canContinue;
                boolean bl = canContinue = pkTag.getRoleNames() != null && pkTag.getRoleNames().length > 0;
                if (version.greaterOrEquals("2.0")) {
                    canContinue |= pkTag.isUnchecked();
                }
                if (canContinue) {
                    int permType = this.getViewType(javaClass) & 0xA;
                    if (pkTag.getMethodIntf() != null) {
                        permType &= this.getInterfaceType(pkTag.getMethodIntf());
                    }
                    if (permType == 0) {
                        throw this.getErrorWithTagLocation(pkTag, "Couldn't resolve a compatible interface type reference. Maybe bean/view-type/version doesn't support it!");
                    }
                    retLst.addAll(MethodPermission.unroll(permType, this.getFinderMethodBySignature("void findByPrimaryKey()"), pkTag.getRoleNames()));
                }
            }
        }
        return retLst;
    }

    public Collection getContainerTransaction(JavaClass javaClass) {
        ArrayList retLst = new ArrayList();
        if (!this.isEJB(javaClass)) {
            throw new Error();
        }
        DocletTag[] tags = javaClass.getTagsByName("ejb.transaction");
        for (int i = 0; i < tags.length; ++i) {
            EjbTransactionTag transTag = (EjbTransactionTag)tags[i];
            int permType = this.getViewType(javaClass);
            if (permType == 0) {
                throw this.getErrorWithTagLocation(transTag, "Couldn't resolve a compatible interface type reference. Maybe bean/view-type/version doesn't support it!");
            }
            retLst.addAll(ContainerTransaction.unroll(permType, transTag.getType()));
        }
        JavaMethod[] methods = javaClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            JavaMethod method = methods[j];
            tags = method.getTagsByName("ejb.transaction");
            for (int k = 0; k < tags.length; ++k) {
                EjbTransactionTag transTag = (EjbTransactionTag)tags[k];
                int methodType = this.getMethodType(method);
                if (methodType != 2 && methodType != 1) {
                    throw this.getErrorWithTagLocation(transTag, "Can't mark a method transaction on a non interface or create method");
                }
                int permType = this.getViewType(method, javaClass);
                if (permType == 0) {
                    throw this.getErrorWithTagLocation(transTag, "Couldn't resolve a compatible interface type reference. Maybe bean/view-type/version doesn't support it!");
                }
                retLst.addAll(ContainerTransaction.unroll(permType, this.externalizeMethodName(method), transTag.getType()));
            }
        }
        if (this.isEntityBean(javaClass)) {
            tags = javaClass.getTagsByName("ejb.finder");
            for (int i = 0; i < tags.length; ++i) {
                EjbFinderTag finderTag = (EjbFinderTag)tags[i];
                if (finderTag.getTransactionType() == null) continue;
                int permType = this.getViewType(finderTag.getViewType()) & 0xA;
                if (finderTag.getMethodIntf() != null) {
                    permType &= this.getInterfaceType(finderTag.getMethodIntf());
                }
                if (permType == 0) {
                    throw this.getErrorWithTagLocation(finderTag, "Couldn't resolve a compatible interface type reference. Maybe bean/view-type/version doesn't support it!");
                }
                retLst.addAll(ContainerTransaction.unroll(permType, this.getFinderMethodBySignature(finderTag.getSignature()), finderTag.getTransactionType()));
            }
        }
        return retLst;
    }

    public Collection injectMethodThrowException(Collection methods, final Class exceptionClass) {
        return CollectionUtils.collect((Collection)methods, (Transformer)new Transformer(){

            public Object transform(Object method) {
                SignatureDuplicatedJavaMethod retVal = new SignatureDuplicatedJavaMethod((JavaMethod)method);
                Type ex = new Type(exceptionClass.getName());
                if (!retVal.containsException(ex)) {
                    retVal.addException(ex);
                }
                return retVal;
            }
        });
    }

    public EjbBeanResolver createEjbBeanResolver(Collection metadata) {
        EjbBeanResolverImpl retVal = null;
        if (metadata != null) {
            retVal = new EjbBeanResolverImpl(metadata);
        }
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<String, Type> wps = new HashMap<String, Type>();
        wps.put("boolean", new Type((class$java$lang$Boolean == null ? (class$java$lang$Boolean = EjbUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName()));
        wps.put("byte", new Type((class$java$lang$Byte == null ? (class$java$lang$Byte = EjbUtils.class$("java.lang.Byte")) : class$java$lang$Byte).getName()));
        wps.put("char", new Type((class$java$lang$Character == null ? (class$java$lang$Character = EjbUtils.class$("java.lang.Character")) : class$java$lang$Character).getName()));
        wps.put("short", new Type((class$java$lang$Short == null ? (class$java$lang$Short = EjbUtils.class$("java.lang.Short")) : class$java$lang$Short).getName()));
        wps.put("int", new Type((class$java$lang$Integer == null ? (class$java$lang$Integer = EjbUtils.class$("java.lang.Integer")) : class$java$lang$Integer).getName()));
        wps.put("float", new Type((class$java$lang$Float == null ? (class$java$lang$Float = EjbUtils.class$("java.lang.Float")) : class$java$lang$Float).getName()));
        wps.put("long", new Type((class$java$lang$Long == null ? (class$java$lang$Long = EjbUtils.class$("java.lang.Long")) : class$java$lang$Long).getName()));
        wps.put("double", new Type((class$java$lang$Double == null ? (class$java$lang$Double = EjbUtils.class$("java.lang.Double")) : class$java$lang$Double).getName()));
        wrappers = Collections.unmodifiableMap(wps);
        String space = "[ \\t]";
        String spaces = "(?:" + space + ")*";
        String typeIdentifier = "[a-zA-Z_][a-zA-Z0-9_]+";
        String typeDimension = "\\[" + spaces + "\\]";
        String typeDimensions = "(?:" + spaces + typeDimension + ")*";
        String typeDefination = "(?:" + typeIdentifier + "(?:\\." + typeIdentifier + ")*" + typeDimensions + ")";
        String paramWithName = "(" + typeDefination + ")" + space + spaces + "(" + typeIdentifier + ")" + "(" + typeDimensions + ")";
        String paramWithoutName = "(" + typeDefination + ")";
        String paramDefinition = "(?:(" + paramWithName + ")|(" + paramWithoutName + "))";
        String paramsDefinition = "(?:(?:" + spaces + ")|(?:" + spaces + paramDefinition + spaces + ")|(?:" + spaces + paramDefinition + spaces + "(?:," + spaces + paramDefinition + spaces + ")+))";
        String methodDefination = spaces + "(" + typeDefination + ")" + space + spaces + "(" + typeIdentifier + ")" + spaces + "\\((" + paramsDefinition + ")\\)" + spaces;
        methodPattern = Pattern.compile(methodDefination);
        paramPattern = Pattern.compile(paramDefinition);
        dimensionPattern = Pattern.compile(typeDimension);
    }

    public static class MethodPermission
    extends Permission {
        private final String[] roles;

        public MethodPermission(String ifaceType, String[] roles) {
            this(ifaceType, null, roles);
        }

        public MethodPermission(String ifaceType, JavaMethod method, String[] roles) {
            super(ifaceType, method);
            this.roles = roles;
        }

        public String[] getRoles() {
            return this.roles;
        }

        public static Collection unroll(int permType, String[] roles) {
            return MethodPermission.unroll(permType, null, roles);
        }

        public static Collection unroll(int permType, JavaMethod method, String[] roles) {
            ArrayList<MethodPermission> retLst = new ArrayList<MethodPermission>();
            if (EjbUtils.hasFlag(permType, 1)) {
                retLst.add(new MethodPermission(EjbUtils.REMOTE_INTERFACE, method, roles));
            }
            if (EjbUtils.hasFlag(permType, 2)) {
                retLst.add(new MethodPermission(EjbUtils.REMOTE_HOME_INTERFACE, method, roles));
            }
            if (EjbUtils.hasFlag(permType, 4)) {
                retLst.add(new MethodPermission(EjbUtils.LOCAL_INTERFACE, method, roles));
            }
            if (EjbUtils.hasFlag(permType, 8)) {
                retLst.add(new MethodPermission(EjbUtils.LOCAL_HOME_INTERFACE, method, roles));
            }
            if (EjbUtils.hasFlag(permType, 16)) {
                retLst.add(new MethodPermission(EjbUtils.SERVICE_END_POINT_INTERFACE, method, roles));
            }
            return retLst;
        }
    }

    public static class ContainerTransaction
    extends Permission {
        private final String transType;

        public ContainerTransaction(String ifaceType, String transType) {
            this(ifaceType, null, transType);
        }

        public ContainerTransaction(String ifaceType, JavaMethod method, String transType) {
            super(ifaceType, method);
            this.transType = transType;
        }

        public String getTransType() {
            return this.transType;
        }

        public static Collection unroll(int permType, String transType) {
            return ContainerTransaction.unroll(permType, null, transType);
        }

        public static Collection unroll(int permType, JavaMethod method, String transType) {
            ArrayList<ContainerTransaction> retLst = new ArrayList<ContainerTransaction>();
            if (EjbUtils.hasFlag(permType, 1)) {
                retLst.add(new ContainerTransaction(EjbUtils.REMOTE_INTERFACE, method, transType));
            }
            if (EjbUtils.hasFlag(permType, 2)) {
                retLst.add(new ContainerTransaction(EjbUtils.REMOTE_HOME_INTERFACE, method, transType));
            }
            if (EjbUtils.hasFlag(permType, 4)) {
                retLst.add(new ContainerTransaction(EjbUtils.LOCAL_INTERFACE, method, transType));
            }
            if (EjbUtils.hasFlag(permType, 8)) {
                retLst.add(new ContainerTransaction(EjbUtils.LOCAL_HOME_INTERFACE, method, transType));
            }
            if (EjbUtils.hasFlag(permType, 16)) {
                retLst.add(new ContainerTransaction(EjbUtils.SERVICE_END_POINT_INTERFACE, method, transType));
            }
            return retLst;
        }
    }

    public static class Permission {
        private final String ifaceType;
        private final JavaMethod method;

        public Permission(String ifaceType) {
            this(ifaceType, null);
        }

        public Permission(String ifaceType, JavaMethod method) {
            this.ifaceType = ifaceType;
            this.method = method;
        }

        public String getIfaceType() {
            return this.ifaceType;
        }

        public JavaMethod getMethod() {
            return this.method;
        }
    }

    public static class SignatureDuplicatedJavaMethod
    extends DuplicatedJavaMethod {
        public SignatureDuplicatedJavaMethod(JavaMethod method) {
            super(method);
        }

        public boolean containsException(Type type) {
            return Arrays.asList(this.getExceptions()).contains(type);
        }

        public void addException(Type type) {
            ArrayList<Type> exceptions = new ArrayList<Type>(Arrays.asList(this.getExceptions()));
            exceptions.add(type);
            this.setExceptions(exceptions.toArray(new Type[0]));
        }
    }

    public class EjbBeanResolverImpl
    implements EjbBeanResolver {
        private final Log log = LogFactory.getLog((Class)(class$org$xdoclet$plugin$ejb$EjbUtils$EjbBeanResolverImpl == null ? (class$org$xdoclet$plugin$ejb$EjbUtils$EjbBeanResolverImpl = EjbUtils.class$("org.xdoclet.plugin.ejb.EjbUtils$EjbBeanResolverImpl")) : class$org$xdoclet$plugin$ejb$EjbUtils$EjbBeanResolverImpl));
        private Map ejbCache = new HashMap();

        public EjbBeanResolverImpl(Collection metadata) {
            Iterator iter = metadata.iterator();
            while (iter.hasNext()) {
                JavaClass javaClass = (JavaClass)iter.next();
                if (!EjbUtils.this.isEJB(javaClass)) continue;
                String ejbName = EjbUtils.this.getEjbName(javaClass);
                if (this.ejbCache.containsKey(ejbName)) {
                    JavaClass otherClass = (JavaClass)this.ejbCache.get(ejbName);
                    String errorMsg = "We cannot have two diferent ejb with same name: " + javaClass.getFullyQualifiedName() + " and " + otherClass.getFullyQualifiedName();
                    this.log.error((Object)errorMsg);
                    throw new Error(errorMsg);
                }
                this.ejbCache.put(ejbName, javaClass);
            }
        }

        public JavaClass findEjbByName(String ejbName) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("findEjbByName: " + ejbName));
            }
            return (JavaClass)this.ejbCache.get(ejbName);
        }
    }

    public static class TagReference {
        private DocletTag tag;
        private JavaClass clazz;
        private JavaMethod method;
        private JavaField field;

        public TagReference(DocletTag tag, JavaClass clazz) {
            this.tag = tag;
            this.clazz = clazz;
        }

        public TagReference(DocletTag tag, JavaMethod method) {
            this.tag = tag;
            this.method = method;
        }

        public TagReference(DocletTag tag, JavaField field) {
            this.tag = tag;
            this.field = field;
        }

        public JavaClass getClazz() {
            return this.clazz;
        }

        public void setClazz(JavaClass clazz) {
            this.clazz = clazz;
        }

        public JavaField getField() {
            return this.field;
        }

        public void setField(JavaField field) {
            this.field = field;
        }

        public JavaMethod getMethod() {
            return this.method;
        }

        public void setMethod(JavaMethod method) {
            this.method = method;
        }

        public DocletTag getTag() {
            return this.tag;
        }

        public void setTag(DocletTag tag) {
            this.tag = tag;
        }
    }

    public class RelationManagerImpl
    implements RelationManager {
        protected Log log = LogFactory.getLog((Class)(class$org$xdoclet$plugin$ejb$EjbUtils$RelationManagerImpl == null ? (class$org$xdoclet$plugin$ejb$EjbUtils$RelationManagerImpl = EjbUtils.class$("org.xdoclet.plugin.ejb.EjbUtils$RelationManagerImpl")) : class$org$xdoclet$plugin$ejb$EjbUtils$RelationManagerImpl));
        private SortedMap relations = new TreeMap();
        private Collection allRelations = null;

        private LinkedHashMap getMapFor(String relationName) {
            LinkedHashMap retVal = (LinkedHashMap)this.relations.get(relationName);
            if (retVal == null) {
                retVal = new LinkedHashMap();
                this.relations.put(relationName, retVal);
            }
            return retVal;
        }

        public void manage(EjbRelationTag relTag, JavaMethod method, JavaClass sourceBean) {
            RelationEntryHolder entryHolder;
            LinkedHashMap mapFor = this.getMapFor(relTag.getName_());
            if (mapFor.containsKey(method)) {
                entryHolder = (RelationEntryHolder)mapFor.get(method);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Existing relation entry pair for relation named '" + relTag.getName_() + "' found at " + EjbUtils.tagToString(relTag)));
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("A new relation entry pair for relation named '" + relTag.getName_() + "' is being created at " + EjbUtils.tagToString(relTag)));
                }
                entryHolder = new RelationEntryHolder(relTag, method);
                mapFor.put(method, entryHolder);
            }
            entryHolder.addSourceBean(sourceBean);
        }

        private Collection validateAndCreateRelations(String relationName, LinkedHashMap mapFor) {
            int i;
            JavaClass[] sourceBeans;
            RelationEntryHolder holder;
            ArrayList<RelationImpl> relationLst = new ArrayList<RelationImpl>();
            ArrayList entryList = new ArrayList(mapFor.values());
            if (entryList.size() > 2) {
                RelationEntryHolder firstHolder = (RelationEntryHolder)entryList.get(0);
                RelationEntryHolder secondHolder = (RelationEntryHolder)entryList.get(1);
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("The relation named '" + relationName + "' has more entries that it should."));
                    this.log.error((Object)("The first node is declared at " + EjbUtils.tagToString(firstHolder.getRelTag())));
                    this.log.error((Object)("The second node is declared at " + EjbUtils.tagToString(secondHolder.getRelTag())));
                    for (int i2 = 2; i2 < entryList.size(); ++i2) {
                        RelationEntryHolder holder2 = (RelationEntryHolder)entryList.get(i2);
                        this.log.error((Object)("Invalid/duplicated at " + EjbUtils.tagToString(holder2.getRelTag())));
                    }
                }
            } else if (entryList.size() == 1) {
                RelationImpl relation;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("It is a unidirectional relation named '" + relationName + "'"));
                }
                holder = (RelationEntryHolder)entryList.get(0);
                sourceBeans = holder.getSourceBeans();
                if (holder.countSourceBeans() > 1) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"This is an unidirectional relation used in several beans");
                        for (int i3 = 0; i3 < sourceBeans.length; ++i3) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug((Object)("Used in " + EjbUtils.this.getEjbName(sourceBeans[i3])));
                        }
                    }
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)"To support unidirectional relations used in various beans we are going to extend the relation name");
                    }
                    for (i = 0; i < sourceBeans.length; ++i) {
                        String genRelationName = relationName + "-" + EjbUtils.this.getEjbName(sourceBeans[i]);
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)("Relation name = '" + relationName + "', extendedName='" + genRelationName + "'"));
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Creating RelationImpl for '" + genRelationName + "'"));
                        }
                        relation = new RelationImpl(genRelationName);
                        relationLst.add(relation);
                        relation.addHolder(holder, sourceBeans[i]);
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Creating RelationImpl for '" + relationName + "'"));
                    }
                    relation = new RelationImpl(relationName);
                    relationLst.add(relation);
                    relation.addHolder(holder, sourceBeans[0]);
                }
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Creating RelationImpl for '" + relationName + "'"));
                }
                RelationImpl relation = new RelationImpl(relationName);
                boolean shouldAdd = true;
                for (i = 0; i < entryList.size(); ++i) {
                    holder = (RelationEntryHolder)entryList.get(i);
                    sourceBeans = holder.getSourceBeans();
                    if (holder.countSourceBeans() != 1) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("The bidirectional relation named '" + relationName + "' is declared in more than one bean."));
                            this.log.error((Object)("It is defined in " + EjbUtils.tagToString(holder.getRelTag())));
                            for (int j = 0; j < sourceBeans.length; ++j) {
                                this.log.error((Object)("And therefore used in " + EjbUtils.this.getEjbName(sourceBeans[i]) + " - " + sourceBeans[i].getFullyQualifiedName()));
                            }
                        }
                        shouldAdd = false;
                        continue;
                    }
                    relation.addHolder(holder, sourceBeans[0]);
                }
                if (shouldAdd) {
                    relationLst.add(relation);
                } else if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("The bidirectional relation named '" + relationName + "' is being discarded because is declared in more than one bean."));
                }
            }
            Iterator iter = relationLst.iterator();
            while (iter.hasNext()) {
                RelationImpl relation = (RelationImpl)iter.next();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Working on relation " + relation));
                }
                if (relation.isLeftMany() && !relation.isRightMany()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"This is N-1 relation. Swapping into 1-N.");
                    }
                    relation.swap();
                }
                if (relation.isBidirectional() || !relation.isOne2Many() || relation.getLeftMethod() != null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"This is 1-N without a left method. Swapping.");
                }
                relation.swap();
            }
            return relationLst;
        }

        private Relation selectByBean(Relation[] relationLst, JavaClass bean) {
            Relation retVal = null;
            if (relationLst != null) {
                for (int i = 0; retVal == null && i < relationLst.length; ++i) {
                    Relation current = relationLst[i];
                    if (current.getLeftBean() != null && current.getLeftBean().getFullyQualifiedName().equals(bean.getFullyQualifiedName())) {
                        retVal = current;
                        continue;
                    }
                    if (current.getRightBean() == null || !current.getRightBean().getFullyQualifiedName().equals(bean.getFullyQualifiedName())) continue;
                    retVal = current;
                }
            }
            return retVal;
        }

        public String toString() {
            StringBuffer retBuf = new StringBuffer();
            Relation[] relLst = this.getRelations();
            for (int i = 0; i < relLst.length; ++i) {
                retBuf.append("[");
                retBuf.append(i);
                retBuf.append("]={");
                retBuf.append(relLst[i]);
                retBuf.append("}\n");
            }
            return retBuf.toString();
        }

        public Relation getRelationFor(JavaMethod method, JavaClass bean) {
            return this.selectByBean(this.getRelationsFor(method), bean);
        }

        public Relation[] getRelationsFor(JavaMethod method) {
            Collection retLst = CollectionUtils.select(Arrays.asList(this.getRelations()), (Predicate)new Predicate(this, method){
                private final /* synthetic */ JavaMethod val$method;
                private final /* synthetic */ RelationManagerImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$method = val$method;
                }

                public boolean evaluate(Object arg0) {
                    Relation current = (Relation)arg0;
                    boolean isFound = current.getLeftMethod() != null && current.getLeftMethod().equals((Object)this.val$method);
                    isFound = isFound || current.getRightMethod() != null && current.getRightMethod().equals((Object)this.val$method);
                    return isFound;
                }
            });
            return retLst.toArray(new Relation[0]);
        }

        public Relation getRelationByName(String relationName, JavaClass bean) {
            return this.selectByBean(this.getRelationsByName(relationName), bean);
        }

        public Relation[] getRelationsByName(String relationName) {
            ArrayList retVal = new ArrayList();
            LinkedHashMap mapFor = (LinkedHashMap)this.relations.get(relationName);
            if (mapFor != null) {
                retVal.addAll(this.validateAndCreateRelations(relationName, mapFor));
            }
            return retVal.toArray(new Relation[0]);
        }

        public Relation[] getRelations() {
            if (this.allRelations == null) {
                this.allRelations = new ArrayList();
                Iterator iter = this.relations.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.allRelations.addAll(this.validateAndCreateRelations((String)entry.getKey(), (LinkedHashMap)entry.getValue()));
                }
            }
            return this.allRelations.toArray(new Relation[0]);
        }
    }

    private class RelationImpl
    implements Relation {
        protected Log log = LogFactory.getLog((Class)(class$org$xdoclet$plugin$ejb$EjbUtils$RelationImpl == null ? (class$org$xdoclet$plugin$ejb$EjbUtils$RelationImpl = EjbUtils.class$("org.xdoclet.plugin.ejb.EjbUtils$RelationImpl")) : class$org$xdoclet$plugin$ejb$EjbUtils$RelationImpl));
        private String name;
        private RelationEntryHolder left;
        private JavaClass leftBean;
        private RelationEntryHolder right;
        private JavaClass rightBean;

        public RelationImpl(String name) {
            this.name = name;
        }

        public void addHolder(RelationEntryHolder holder, JavaClass sourceBean) {
            if (this.left == null) {
                this.left = holder;
                this.leftBean = sourceBean;
            } else if (this.right == null) {
                this.right = holder;
                this.rightBean = sourceBean;
            } else {
                IllegalStateException e = new IllegalStateException();
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"This should not happen", (Throwable)e);
                }
                throw e;
            }
        }

        private EjbRelationTag getRightTag() {
            return this.right != null ? this.right.getRelTag() : null;
        }

        private EjbRelationTag getLeftTag() {
            return this.left != null ? this.left.getRelTag() : null;
        }

        public void swap() {
            RelationEntryHolder t1 = this.left;
            JavaClass t2 = this.leftBean;
            this.left = this.right;
            this.leftBean = this.rightBean;
            this.right = t1;
            this.rightBean = t2;
        }

        public String toString() {
            StringBuffer retBuf = new StringBuffer();
            retBuf.append("[name]={");
            retBuf.append(this.name);
            retBuf.append("},[left]={");
            retBuf.append(this.left);
            retBuf.append("},[leftBean]={");
            retBuf.append(this.leftBean != null ? this.leftBean.getFullyQualifiedName() : null);
            retBuf.append("},[right]={");
            retBuf.append(this.right);
            retBuf.append("},[rightBean]={");
            retBuf.append(this.rightBean != null ? this.rightBean.getFullyQualifiedName() : null);
            retBuf.append("}");
            return retBuf.toString();
        }

        private String getRoleName(EjbRelationTag lTag, EjbRelationTag rTag) {
            String roleName = null;
            roleName = lTag != null ? lTag.getRoleName() : rTag.getTargetRoleName();
            return roleName;
        }

        private boolean isCascadeDelete(EjbRelationTag lTag, EjbRelationTag rTag) {
            boolean retVal = false;
            retVal = lTag != null ? lTag.isCascadeDelete() : rTag.isTargetCascadeDelete();
            return retVal;
        }

        private String getEJBName(JavaClass clazz, EjbRelationTag tag) {
            String ejbName = null;
            if (clazz != null) {
                ejbName = EjbUtils.this.getEjbName(clazz);
            } else {
                ejbName = tag.getTargetEjb();
                if (ejbName == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("'target-ejb' is mandatory for tag " + EjbUtils.tagToString(tag)));
                    }
                    throw EjbUtils.this.getErrorWithTagLocation(tag, "'target-ejb' is mandatory for tag");
                }
            }
            return ejbName;
        }

        public String getName() {
            return this.name;
        }

        public JavaClass getLeftBean() {
            return this.leftBean;
        }

        public JavaClass getRightBean() {
            return this.rightBean;
        }

        public JavaMethod getRightMethod() {
            return this.right != null ? this.right.getMethod() : null;
        }

        public JavaMethod getLeftMethod() {
            return this.left != null ? this.left.getMethod() : null;
        }

        public boolean isLeftMany() {
            boolean retVal = false;
            JavaMethod method = this.getLeftMethod();
            EjbRelationTag tag = this.getRightTag();
            if (method != null) {
                retVal |= method.getReturns().isA(new Type((class$java$util$Collection == null ? (class$java$util$Collection = EjbUtils.class$("java.util.Collection")) : class$java$util$Collection).getName()));
                retVal |= method.getReturns().isA(new Type((class$java$util$Set == null ? (class$java$util$Set = EjbUtils.class$("java.util.Set")) : class$java$util$Set).getName()));
            } else {
                retVal = tag.isTargetMultiple();
            }
            return retVal;
        }

        public boolean isRightMany() {
            boolean retVal = false;
            JavaMethod method = this.getRightMethod();
            EjbRelationTag tag = this.getLeftTag();
            if (method != null) {
                retVal |= method.getReturns().isA(new Type((class$java$util$Collection == null ? (class$java$util$Collection = EjbUtils.class$("java.util.Collection")) : class$java$util$Collection).getName()));
                retVal |= method.getReturns().isA(new Type((class$java$util$Set == null ? (class$java$util$Set = EjbUtils.class$("java.util.Set")) : class$java$util$Set).getName()));
            } else {
                retVal = tag.isTargetMultiple();
            }
            return retVal;
        }

        public boolean isBidirectional() {
            return this.left != null && this.right != null;
        }

        public boolean isOne2Many() {
            return !this.isLeftMany() && this.isRightMany();
        }

        public String getLeftRoleName() {
            return this.getRoleName(this.getLeftTag(), this.getRightTag());
        }

        public String getRightRoleName() {
            return this.getRoleName(this.getRightTag(), this.getLeftTag());
        }

        public boolean isLeftCascadeDelete() {
            return this.isCascadeDelete(this.getLeftTag(), this.getRightTag());
        }

        public boolean isRightCascadeDelete() {
            return this.isCascadeDelete(this.getRightTag(), this.getLeftTag());
        }

        public String getLeftEJBName() {
            return this.getEJBName(this.getLeftBean(), this.getRightTag());
        }

        public String getRightEJBName() {
            return this.getEJBName(this.getRightBean(), this.getLeftTag());
        }

        public Relation reverse() {
            RelationImpl retVal = new RelationImpl(this.name);
            retVal.left = this.right;
            retVal.leftBean = this.rightBean;
            retVal.right = this.left;
            retVal.rightBean = this.leftBean;
            return retVal;
        }
    }

    private static class RelationEntryHolder {
        private EjbRelationTag relTag;
        private JavaMethod method;
        private List beanLst = new ArrayList();

        public RelationEntryHolder(EjbRelationTag relTag, JavaMethod method) {
            this.relTag = relTag;
            this.method = method;
        }

        public void addSourceBean(JavaClass sourceBean) {
            this.beanLst.add(sourceBean);
        }

        public int countSourceBeans() {
            return this.beanLst.size();
        }

        public JavaClass[] getSourceBeans() {
            return this.beanLst.toArray(new JavaClass[0]);
        }

        public JavaMethod getMethod() {
            return this.method;
        }

        public EjbRelationTag getRelTag() {
            return this.relTag;
        }

        public String toString() {
            StringBuffer retBuf = new StringBuffer();
            retBuf.append("[relTag]={");
            retBuf.append(this.relTag != null ? "@" + this.relTag.getName() + " " + this.relTag.getValue() : null);
            retBuf.append("},[method]={");
            retBuf.append(this.method != null ? this.method.getCallSignature() : null);
            retBuf.append("}");
            return retBuf.toString();
        }
    }
}

