/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb;

import java.util.HashMap;
import java.util.Map;

public class EjbVersion {
    public static final String EJB_1_1 = "1.1";
    public static final String EJB_2_0 = "2.0";
    public static final String EJB_2_1 = "2.1";
    private static Map versionMap = new HashMap();
    private String publicId;
    private String systemId;
    private String ns;
    private String xsdLocation;
    private boolean isDtd;
    private String xsiNs;
    private double version;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$EjbVersion;

    private EjbVersion(double version, String publicId, String systemId) {
        this.version = version;
        this.publicId = publicId;
        this.systemId = systemId;
        this.isDtd = true;
    }

    private EjbVersion(double version, String ns, String xsiNs, String xsdLocation) {
        this.version = version;
        this.ns = ns;
        this.xsiNs = xsiNs;
        this.xsdLocation = xsdLocation;
        this.isDtd = false;
    }

    public static EjbVersion get(String version) {
        return (EjbVersion)versionMap.get(version);
    }

    public boolean greaterOrEquals(String ver) {
        return this.greaterOrEquals(Double.parseDouble(ver));
    }

    public boolean greaterOrEquals(double ver) {
        return ver <= this.getVersion();
    }

    public boolean equals(String ver) {
        return this.equals(Double.parseDouble(ver));
    }

    public boolean equals(double ver) {
        return ver == this.getVersion();
    }

    private static String getLocationUrl(String version) {
        EjbVersion ejbVer = EjbVersion.get(version);
        if (ejbVer == null) {
            throw new IllegalStateException();
        }
        return ejbVer.isDtd() ? ejbVer.getSystemId() : ejbVer.getXsdLocation();
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSchemaLocation() {
        if (this.ns == null || this.xsdLocation == null) {
            return null;
        }
        return this.ns + " " + this.xsdLocation;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getNs() {
        return this.ns;
    }

    public String getXsdLocation() {
        return this.xsdLocation;
    }

    public boolean isDtd() {
        return this.isDtd;
    }

    public String getXsiNs() {
        return this.xsiNs;
    }

    public double getVersion() {
        return this.version;
    }

    public static Map fillEntityResolverMap(Map dtds) {
        Class clz = class$org$xdoclet$plugin$ejb$EjbVersion == null ? (class$org$xdoclet$plugin$ejb$EjbVersion = EjbVersion.class$("org.xdoclet.plugin.ejb.EjbVersion")) : class$org$xdoclet$plugin$ejb$EjbVersion;
        dtds.put(EjbVersion.getLocationUrl(EJB_1_1), clz.getResource("dtd/ejb-jar_1_1.dtd"));
        dtds.put(EjbVersion.getLocationUrl(EJB_2_0), clz.getResource("dtd/ejb-jar_2_0.dtd"));
        dtds.put(EjbVersion.getLocationUrl(EJB_2_1), clz.getResource("dtd/ejb-jar_2_1.xsd"));
        dtds.put("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", clz.getResource("dtd/j2ee_1_4.xsd"));
        dtds.put("http://www.w3.org/2001/xml.xsd", clz.getResource("dtd/xml.xsd"));
        dtds.put("http://www.w3.org/2001/XMLSchema.dtd", clz.getResource("dtd/XMLSchema.dtd"));
        dtds.put("http://www.w3.org/2001/datatypes.dtd", clz.getResource("dtd/datatypes.dtd"));
        dtds.put("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", clz.getResource("dtd/j2ee_web_services_client_1_1.xsd"));
        return dtds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        versionMap.put(EJB_1_1, new EjbVersion(1.1, "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd"));
        versionMap.put(EJB_2_0, new EjbVersion(2.0, "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/dtd/ejb-jar_2_0.dtd"));
        versionMap.put(EJB_2_1, new EjbVersion(2.1, "http://java.sun.com/xml/ns/j2ee", "http://www.w3.org/2001/XMLSchema-instance", "http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd"));
    }
}

