/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb.descriptor;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.generama.JellyTemplateEngine;
import org.generama.OutputValidator;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.XMLOutputValidator;
import org.xdoclet.plugin.ejb.EjbBeanResolver;
import org.xdoclet.plugin.ejb.EjbConfig;
import org.xdoclet.plugin.ejb.EjbIds;
import org.xdoclet.plugin.ejb.EjbQDoxPlugin;
import org.xdoclet.plugin.ejb.EjbRuntime;
import org.xdoclet.plugin.ejb.EjbVersion;
import org.xdoclet.plugin.ejb.Relation;
import org.xdoclet.plugin.ejb.RelationManager;
import org.xdoclet.plugin.ejb.entity.PrimaryKeyClassPlugin;
import org.xdoclet.plugin.ejb.interfaces.LocalHomeInterfacePlugin;
import org.xdoclet.plugin.ejb.interfaces.LocalInterfacePlugin;
import org.xdoclet.plugin.ejb.interfaces.RemoteHomeInterfacePlugin;
import org.xdoclet.plugin.ejb.interfaces.RemoteInterfacePlugin;
import org.xdoclet.plugin.ejb.interfaces.ServiceEndpointPlugin;
import org.xdoclet.plugin.ejb.util.QDoxCachedMetadataProvider;

public class EjbJarXmlPlugin
extends EjbQDoxPlugin {
    private String description;
    private String displayname;
    private String smallicon;
    private String largeicon;
    private boolean useids = true;
    private String fileName = "ejb-jar.xml";
    private String clientjar;
    private EjbBeanResolver beanResolver = null;

    public EjbJarXmlPlugin(JellyTemplateEngine jellyTemplateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper, EjbConfig config) {
        super((TemplateEngine)jellyTemplateEngine, new QDoxCachedMetadataProvider(metadataProvider), writerMapper, config);
        EjbRuntime.setPlugin(this);
        Map dtds = EjbVersion.fillEntityResolverMap(new HashMap());
        super.setMultioutput(false);
        this.setOutputValidator((OutputValidator)new XMLOutputValidator(dtds));
    }

    protected void populateContextMap(Map map) {
        super.populateContextMap(map);
        map.put("util", this.getEjbUtils());
        map.put("version", this.getVersion());
    }

    public void setMultioutput(boolean multioutput) {
        throw new RuntimeException("Can't set multioutput for plugin");
    }

    public void setFilename(String fileName) {
        if (fileName == null) {
            throw new NullPointerException();
        }
        this.fileName = fileName;
    }

    public File getMergeFile(String mergeFile, JavaClass clazz) {
        return this.getMergeFile(this.expandFileName(mergeFile, clazz));
    }

    public String expandFileName(String mergeFile, JavaClass clazz) {
        return MessageFormat.format(mergeFile, clazz.getName());
    }

    public LocalInterfacePlugin getLocalInterfacePlugin() {
        return EjbRuntime.getLocalInterfacePlugin();
    }

    public RemoteInterfacePlugin getRemoteInterfacePlugin() {
        return EjbRuntime.getRemoteInterfacePlugin();
    }

    public boolean shouldGenerate(Object metadata) {
        return this.ejbUtils.shouldGenerate(metadata);
    }

    public String idFor(JavaClass javaClass) {
        return this.useids ? EjbIds.escapeId(this.ejbUtils.entityType(javaClass) + ' ' + this.ejbUtils.getEjbName(javaClass)) : null;
    }

    public String prefixedId(String prefix) {
        return this.useids ? EjbIds.get().prefixedId(prefix) : null;
    }

    public Collection getRelationships(Collection metadata) {
        RelationManager relationManager = this.ejbUtils.createRelationManager(metadata);
        return CollectionUtils.collect(Arrays.asList(relationManager.getRelations()), (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                return new RelationHolder((Relation)arg0);
            }
        });
    }

    public LocalHomeInterfacePlugin getLocalHomeInterfacePlugin() {
        return EjbRuntime.getLocalHomeInterfacePlugin();
    }

    public RemoteHomeInterfacePlugin getRemoteHomeInterfacePlugin() {
        return EjbRuntime.getRemoteHomeInterfacePlugin();
    }

    public PrimaryKeyClassPlugin getPrimaryKeyClassPlugin() {
        return EjbRuntime.getPrimaryKeyClassPlugin();
    }

    public ServiceEndpointPlugin getServiceEndpointPlugin() {
        return EjbRuntime.getServiceEndpointPlugin();
    }

    public String getClientjar() {
        return this.clientjar;
    }

    public void setClientjar(String clientjar) {
        this.clientjar = clientjar;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public String getLargeicon() {
        return this.largeicon;
    }

    public void setLargeicon(String largeicon) {
        this.largeicon = largeicon;
    }

    public String getSmallicon() {
        return this.smallicon;
    }

    public void setSmallicon(String smallicon) {
        this.smallicon = smallicon;
    }

    public void setUseids(boolean useids) {
        this.useids = useids;
    }

    public void start() {
        this.setFilereplace(this.fileName);
        this.beanResolver = this.ejbUtils.createEjbBeanResolver(this.getMetadata());
        super.start();
    }

    public JavaClass findEjbRef(String ejbName) {
        return this.ejbUtils.findEjbRef(ejbName, this.beanResolver);
    }

    public class RelationHolder {
        public static final String ONE = "One";
        public static final String MANY = "Many";
        private final Relation relation;

        public RelationHolder(Relation relation) {
            this.relation = relation;
        }

        public String getName() {
            return this.relation.getName();
        }

        public String getLeftRoleName() {
            return this.relation.getLeftRoleName();
        }

        public boolean isLeftCascadeDelete() {
            return this.relation.isLeftCascadeDelete();
        }

        public boolean isRightCascadeDelete() {
            return this.relation.isRightCascadeDelete();
        }

        public JavaMethod getLeftMethod() {
            return this.relation.getLeftMethod();
        }

        public JavaMethod getRightMethod() {
            return this.relation.getRightMethod();
        }

        public boolean isLeftMany() {
            return this.relation.isLeftMany();
        }

        public boolean isRightMany() {
            return this.relation.isRightMany();
        }

        public String getRightRoleName() {
            return this.relation.getRightRoleName();
        }

        public String getLeftEJBName() {
            return this.relation.getLeftEJBName();
        }

        public String getRightEJBName() {
            return this.relation.getRightEJBName();
        }

        public String getRightMultiplicity() {
            return this.relation.isRightMany() ? MANY : ONE;
        }

        public String getLeftMultiplicity() {
            return this.relation.isLeftMany() ? MANY : ONE;
        }
    }
}

