/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb.entity;

import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.generama.GeneramaException;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.VelocityTemplateEngine;
import org.generama.WriterMapper;
import org.xdoclet.plugin.ejb.EjbBeanResolver;
import org.xdoclet.plugin.ejb.EjbConfig;
import org.xdoclet.plugin.ejb.EjbJavaGeneratingPlugin;
import org.xdoclet.plugin.ejb.EjbRuntime;
import org.xdoclet.plugin.ejb.EjbUtils;
import org.xdoclet.plugin.ejb.Relation;
import org.xdoclet.plugin.ejb.RelationManager;
import org.xdoclet.plugin.ejb.entity.PkMetadata;
import org.xdoclet.plugin.ejb.interfaces.LocalInterfacePlugin;
import org.xdoclet.plugin.ejb.interfaces.RemoteInterfacePlugin;
import org.xdoclet.plugin.ejb.qtags.EjbValueObjectFieldTag;
import org.xdoclet.plugin.ejb.qtags.EjbValueObjectTag;
import org.xdoclet.plugin.ejb.util.DuplicatedJavaClass;
import org.xdoclet.plugin.ejb.util.QDoxCachedMetadataProvider;

public class ValueObjectPlugin
extends EjbJavaGeneratingPlugin {
    public static final Type SET_TYPE = new Type((class$java$util$Set == null ? (class$java$util$Set = ValueObjectPlugin.class$("java.util.Set")) : class$java$util$Set).getName());
    public static final Type COLLECTION_TYPE = new Type((class$java$util$Collection == null ? (class$java$util$Collection = ValueObjectPlugin.class$("java.util.Collection")) : class$java$util$Collection).getName());
    private static final Map immutableKnownTypes;
    private final EjbBeanResolver beanResolver;
    private final RelationManager relationManager;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Cloneable;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectRelationMetadata;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectFieldMetadata;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectMetadata;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$EjbConfig;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$QDoxValueObjectExpanderFilterMetadataProvider;

    public ValueObjectPlugin(VelocityTemplateEngine templateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper, EjbConfig config) {
        super(templateEngine, new QDoxValueObjectExpanderFilterMetadataProvider(metadataProvider), writerMapper, config);
        this.getValueObjectMetadataProvider().setPlugin(this);
        this.setPackageregex("beans");
        this.setPackagereplace("util");
        super.setFileregex(config.getEjbReplaceRegex());
        this.setFilereplace("ValueObject");
        super.setMultioutput(true);
        this.beanResolver = this.ejbUtils.createEjbBeanResolver(this.getOriginalMetadata());
        this.relationManager = this.ejbUtils.createRelationManager(this.getOriginalMetadata());
    }

    private QDoxValueObjectExpanderFilterMetadataProvider getValueObjectMetadataProvider() {
        return (QDoxValueObjectExpanderFilterMetadataProvider)this.getMetadataProvider();
    }

    private Collection getOriginalMetadata() {
        return this.getValueObjectMetadataProvider().getOriginalMetadata();
    }

    public boolean isImmutable(Type type) {
        return immutableKnownTypes.containsKey(type.getValue());
    }

    public boolean isCloneable(Type type) {
        JavaMethod cloneMethod = type.getJavaClass().getMethodBySignature("clone", null);
        return type.isA(new Type((class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = ValueObjectPlugin.class$("java.lang.Cloneable")) : class$java$lang$Cloneable).getName())) && cloneMethod != null && cloneMethod.isPublic();
    }

    private JavaClass findBeanByInterface(Collection metadata, Type type) {
        JavaClass retVal = null;
        LocalInterfacePlugin localPlugin = EjbRuntime.getLocalInterfacePlugin();
        RemoteInterfacePlugin remotePlugin = EjbRuntime.getRemoteInterfacePlugin();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Looking for bean with local|remote interface named " + type));
        }
        Iterator iter = metadata.iterator();
        while (retVal == null && iter.hasNext()) {
            JavaClass javaClass = (JavaClass)iter.next();
            Type localType = localPlugin.getVirtualType(javaClass).getType();
            Type remoteType = remotePlugin.getVirtualType(javaClass).getType();
            if (!localType.equals((Object)type) && !remoteType.equals((Object)type)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Match found for " + javaClass.getFullyQualifiedName()));
                this.log.debug((Object)("Local Interface " + localType));
                this.log.debug((Object)("Remote Interface " + remoteType));
            }
            retVal = javaClass;
        }
        if (retVal == null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("bean with local|remote interface named " + type + " wasn't found"));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("bean with local|remote interface named " + type + " found: " + retVal.getFullyQualifiedName()));
        }
        return retVal;
    }

    public ValueObjectMetadata getMetaVO(JavaClass javaClass) {
        ValueObjectMetadata retVal = null;
        DocletTag[] valueTags = javaClass.getTagsByName("ejb.value-object");
        if (valueTags.length > 0 && this.log.isDebugEnabled()) {
            StringBuffer retBuf = new StringBuffer();
            retBuf.append("The list of @ejb.value-object for ").append(javaClass.getFullyQualifiedName()).append(" is {");
            for (int i = 0; i < valueTags.length; ++i) {
                if (i > 0) {
                    retBuf.append(";");
                }
                retBuf.append(EjbUtils.tagToString(valueTags[i]));
            }
            retBuf.append("}");
            this.log.debug((Object)retBuf.toString());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getMetaVO is working in " + javaClass.getFullyQualifiedName()));
        }
        if (valueTags.length > 0) {
            EjbValueObjectTag valueTag = (EjbValueObjectTag)valueTags[0];
            retVal = new ValueObjectMetadata(javaClass, valueTag, EjbRuntime.getPrimaryKeyClassPlugin().collectPkHierarchy(javaClass));
            JavaMethod[] methods = javaClass.getMethods(true);
            for (int i = 0; i < methods.length; ++i) {
                Relation relation;
                boolean isValueObjectField;
                int metaFlags;
                JavaMethod method = methods[i];
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(method.getName() + " seeing if this is a value-object-field"));
                }
                if (!EjbUtils.hasFlag(metaFlags = this.ejbUtils.getMethodMetadata(javaClass, method), 128) && !EjbUtils.hasFlag(metaFlags, 64) && !EjbUtils.hasFlag(metaFlags, 256)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(method.getName() + " is candidate for checking. It's a persistence field, relation field or primary key field"));
                }
                boolean bl = isValueObjectField = (isValueObjectField = this.isSelectedValueObjectField(valueTag.getMatch(), method)) || EjbUtils.hasFlag(metaFlags, 128);
                if (!isValueObjectField) continue;
                EjbValueObjectFieldTag vTag = this.findMatchedTag(valueTag.getMatch(), method);
                BeanProperty prop = javaClass.getBeanProperty(method.getPropertyName(), true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(method.getName() + " is a value-object-field: matches or is a pk-field."));
                }
                if ((relation = this.relationManager.getRelationFor(method, javaClass)) != null || vTag != null && (vTag.getAggregate() != null || vTag.getCompose() != null)) {
                    if (vTag != null && vTag.getAggregate() != null ^ vTag.getCompose() != null) {
                        JavaClass relationEjb = null;
                        Type collectionType = null;
                        if (relation != null) {
                            if (!method.equals((Object)relation.getLeftMethod())) {
                                this.log.debug((Object)"Current method doesn't match relations' left method. Reversing relation");
                                relation = relation.reverse();
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("Reversed relation is relation=" + relation));
                                }
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Using relation information. relation=" + relation));
                                this.log.debug((Object)("1# Left bean=" + (relation.getLeftBean() != null ? relation.getLeftBean().getFullyQualifiedName() : null)));
                                this.log.debug((Object)("1# Rigth bean=" + (relation.getRightBean() != null ? relation.getRightBean().getFullyQualifiedName() : null)));
                            }
                            String relationEjbName = relation.getRightEJBName();
                            relationEjb = this.beanResolver.findEjbByName(relationEjbName);
                            collectionType = relation.getLeftMethod().getReturns();
                        } else {
                            this.log.debug((Object)"We don't have relation information for this method");
                            Type returnType = method.getReturns();
                            Type relationType = null;
                            if (returnType.isA(COLLECTION_TYPE) || returnType.isA(SET_TYPE)) {
                                String members = vTag.getMembers();
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)(returnType + ": Is a Set or Collection. Using members='" + members + "'"));
                                }
                                if (members == null) {
                                    if (!this.log.isWarnEnabled()) continue;
                                    this.log.warn((Object)EjbUtils.getMessageWithTagLocation(vTag, "members is null. Skipping."));
                                    continue;
                                }
                                relationType = new Type(members);
                                collectionType = returnType.isA(COLLECTION_TYPE) ? COLLECTION_TYPE : SET_TYPE;
                            } else {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)(returnType + ": Using it to find it's match!"));
                                }
                                relationType = returnType;
                            }
                            relationEjb = this.findBeanByInterface(this.getOriginalMetadata(), relationType);
                        }
                        if (relationEjb == null) {
                            this.log.warn((Object)"Couldn't find the related Ejb! Skipping.");
                            continue;
                        }
                        ValueObjectRelationMetadata vObjRelation = new ValueObjectRelationMetadata(relationEjb, collectionType, vTag.getAggregate() != null, vTag);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Relation is " + vObjRelation));
                        }
                        if (vObjRelation.getAggregateName() == null) {
                            String aggName;
                            String string = aggName = vObjRelation.isAggregate() ? "aggregate" : "compose";
                            if (!this.log.isWarnEnabled()) continue;
                            this.log.warn((Object)EjbUtils.getMessageWithTagLocation(vTag, aggName + "-name can't be null. Ignoring."));
                            continue;
                        }
                        retVal.addRelation(vObjRelation);
                        continue;
                    }
                    if (vTag == null || !this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)EjbUtils.getMessageWithTagLocation(vTag, "Can't be an aggregate and a composition simultaneous! Skipping."));
                    continue;
                }
                ValueObjectFieldMetadata vObjField = new ValueObjectFieldMetadata(prop.getType(), prop.getName(), metaFlags);
                retVal.addField(vObjField);
            }
        }
        return retVal;
    }

    protected String getPatternBasedUnqualifiedName(JavaClass javaClass) {
        EjbValueObjectTag valueObjectTag = (EjbValueObjectTag)javaClass.getTagByName("ejb.value-object");
        return this.ejbUtils.expandPattern(this.getPattern(valueObjectTag), valueObjectTag.getName_());
    }

    private String getPattern(EjbValueObjectTag valueTag) {
        return valueTag.getPattern() != null ? valueTag.getPattern() : "{0}" + this.filereplace;
    }

    private boolean isSelectedValueObjectField(String match, JavaMethod method) {
        if (null == match) {
            match = "*";
        }
        if (!method.isPropertyAccessor()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(method.getName() + " is a not a value-object-field because method is not a property-accessor"));
            }
            return false;
        }
        if ("*".equals(match)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(method.getName() + " is a value-object-field because we used a blind match '" + match + "'"));
            }
            return true;
        }
        if (this.findMatchedTag(match, method) != null) {
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(method.getName() + " doesn't have any compatible match. Searching for match '" + match + "'"));
        }
        return false;
    }

    private EjbValueObjectFieldTag findMatchedTag(String match, JavaMethod method) {
        if (null == match) {
            match = "*";
        }
        DocletTag[] tags = method.getTagsByName("ejb.value-object-field");
        HashMap<String, EjbValueObjectFieldTag> matchValues = new HashMap<String, EjbValueObjectFieldTag>();
        for (int i = 0; i < tags.length; ++i) {
            EjbValueObjectFieldTag valueMethodMatchTag = (EjbValueObjectFieldTag)tags[i];
            String methodMatch = valueMethodMatchTag.getMatch();
            if (matchValues.containsKey(methodMatch)) {
                EjbValueObjectFieldTag savedTag = (EjbValueObjectFieldTag)matchValues.get(methodMatch);
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)(EjbUtils.tagToString(valueMethodMatchTag) + " is being ignored because there is already another tag for same match " + EjbUtils.tagToString(savedTag)));
                continue;
            }
            matchValues.put(methodMatch, valueMethodMatchTag);
        }
        EjbValueObjectFieldTag savedTag = (EjbValueObjectFieldTag)matchValues.get(match);
        if (savedTag == null) {
            savedTag = (EjbValueObjectFieldTag)matchValues.get("*");
        }
        return savedTag;
    }

    protected static JavaClass[] expandClass(JavaClass javaClass) {
        ArrayList<JavaClass> retLst = new ArrayList<JavaClass>();
        DocletTag[] valueTags = javaClass.getTagsByName("ejb.value-object");
        int countTags = valueTags.length;
        if (countTags > 0) {
            for (int i = 0; i < countTags; ++i) {
                DuplicatedJavaClass newClass = new DuplicatedJavaClass(javaClass);
                DocletTag[] tags = newClass.getTags();
                ArrayList<DocletTag> newTags = new ArrayList<DocletTag>();
                int tagIdx = 0;
                for (int j = 0; j < tags.length; ++j) {
                    DocletTag tag = tags[j];
                    if ("ejb.value-object".equals(tag.getName())) {
                        if (tagIdx++ != i) continue;
                        newTags.add(tag);
                        continue;
                    }
                    newTags.add(tag);
                }
                newClass.setTags(newTags);
                retLst.add(newClass);
            }
        } else {
            retLst.add(javaClass);
        }
        return retLst.toArray(new JavaClass[0]);
    }

    public void setFileregex(String fileregex) {
        throw new RuntimeException("Can't set fileregex for plugin. Try setting it in " + (class$org$xdoclet$plugin$ejb$EjbConfig == null ? (class$org$xdoclet$plugin$ejb$EjbConfig = ValueObjectPlugin.class$("org.xdoclet.plugin.ejb.EjbConfig")) : class$org$xdoclet$plugin$ejb$EjbConfig).getName());
    }

    public boolean shouldGenerate(Object metadata) {
        JavaClass javaClass = (JavaClass)metadata;
        boolean generate = this.ejbUtils.shouldGenerate(javaClass);
        generate = generate && this.ejbUtils.isEntityBean(javaClass);
        generate = generate && this.getMetaVO(javaClass) != null;
        return generate;
    }

    public boolean isAbstract(JavaClass javaClass) {
        ValueObjectMetadata metaVo = this.getMetaVO(javaClass);
        return metaVo.getValueTag().isAbstract();
    }

    public String getExtends(JavaClass javaClass) {
        ValueObjectMetadata metaVo = this.getMetaVO(javaClass);
        String extendz = metaVo.getValueTag().getExtends();
        if (extendz == null) {
            extendz = (class$java$lang$Object == null ? (class$java$lang$Object = ValueObjectPlugin.class$("java.lang.Object")) : class$java$lang$Object).getName();
        }
        return extendz;
    }

    public String[] getImplements(JavaClass javaClass) {
        ValueObjectMetadata metaVo = this.getMetaVO(javaClass);
        ArrayList<String> implementsLst = new ArrayList<String>();
        if (metaVo.getValueTag().getImplements() != null) {
            implementsLst.addAll(Arrays.asList(metaVo.getValueTag().getImplements()));
        }
        if (metaVo.isStrictOrdering() && !implementsLst.contains((class$java$lang$Comparable == null ? (class$java$lang$Comparable = ValueObjectPlugin.class$("java.lang.Comparable")) : class$java$lang$Comparable).getName())) {
            implementsLst.add((class$java$lang$Comparable == null ? (class$java$lang$Comparable = ValueObjectPlugin.class$("java.lang.Comparable")) : class$java$lang$Comparable).getName());
        }
        if (!implementsLst.contains((class$java$io$Serializable == null ? (class$java$io$Serializable = ValueObjectPlugin.class$("java.io.Serializable")) : class$java$io$Serializable).getName())) {
            implementsLst.add((class$java$io$Serializable == null ? (class$java$io$Serializable = ValueObjectPlugin.class$("java.io.Serializable")) : class$java$io$Serializable).getName());
        }
        if (!implementsLst.contains((class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = ValueObjectPlugin.class$("java.lang.Cloneable")) : class$java$lang$Cloneable).getName())) {
            implementsLst.add((class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = ValueObjectPlugin.class$("java.lang.Cloneable")) : class$java$lang$Cloneable).getName());
        }
        return implementsLst.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<String, Boolean> typeMap = new HashMap<String, Boolean>();
        typeMap.put((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValueObjectPlugin.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), Boolean.TRUE);
        typeMap.put(Boolean.TYPE.getName(), Boolean.TRUE);
        typeMap.put((class$java$lang$Byte == null ? (class$java$lang$Byte = ValueObjectPlugin.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), Boolean.TRUE);
        typeMap.put(Byte.TYPE.getName(), Boolean.TRUE);
        typeMap.put((class$java$lang$Character == null ? (class$java$lang$Character = ValueObjectPlugin.class$("java.lang.Character")) : class$java$lang$Character).getName(), Boolean.TRUE);
        typeMap.put(Character.TYPE.getName(), Boolean.TRUE);
        typeMap.put((class$java$lang$Short == null ? (class$java$lang$Short = ValueObjectPlugin.class$("java.lang.Short")) : class$java$lang$Short).getName(), Boolean.TRUE);
        typeMap.put(Short.TYPE.getName(), Boolean.TRUE);
        typeMap.put((class$java$lang$Integer == null ? (class$java$lang$Integer = ValueObjectPlugin.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), Boolean.TRUE);
        typeMap.put(Integer.TYPE.getName(), Boolean.TRUE);
        typeMap.put((class$java$lang$Float == null ? (class$java$lang$Float = ValueObjectPlugin.class$("java.lang.Float")) : class$java$lang$Float).getName(), Boolean.TRUE);
        typeMap.put(Float.TYPE.getName(), Boolean.TRUE);
        typeMap.put((class$java$lang$Long == null ? (class$java$lang$Long = ValueObjectPlugin.class$("java.lang.Long")) : class$java$lang$Long).getName(), Boolean.TRUE);
        typeMap.put(Long.TYPE.getName(), Boolean.TRUE);
        typeMap.put((class$java$lang$Double == null ? (class$java$lang$Double = ValueObjectPlugin.class$("java.lang.Double")) : class$java$lang$Double).getName(), Boolean.TRUE);
        typeMap.put(Double.TYPE.getName(), Boolean.TRUE);
        typeMap.put((class$java$lang$String == null ? (class$java$lang$String = ValueObjectPlugin.class$("java.lang.String")) : class$java$lang$String).getName(), Boolean.TRUE);
        immutableKnownTypes = Collections.unmodifiableMap(typeMap);
    }

    private static class QDoxValueObjectExpanderFilterMetadataProvider
    extends QDoxCachedMetadataProvider {
        protected final Log log = LogFactory.getLog((Class)(class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$QDoxValueObjectExpanderFilterMetadataProvider == null ? (class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$QDoxValueObjectExpanderFilterMetadataProvider = ValueObjectPlugin.class$("org.xdoclet.plugin.ejb.entity.ValueObjectPlugin$QDoxValueObjectExpanderFilterMetadataProvider")) : class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$QDoxValueObjectExpanderFilterMetadataProvider));
        private Collection tamperedMetadata;
        protected ValueObjectPlugin vObjPlugin;

        public QDoxValueObjectExpanderFilterMetadataProvider(QDoxCapableMetadataProvider wrapper) {
            super(wrapper);
        }

        void setPlugin(ValueObjectPlugin vObjPlugin) {
            this.vObjPlugin = vObjPlugin;
        }

        public Collection getMetadata() throws GeneramaException {
            Collection meta;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"getMetadata() called");
            }
            if (this.tamperedMetadata == null && (meta = this.getOriginalMetadata()) != null) {
                ArrayList<JavaClass> newMetadata = new ArrayList<JavaClass>();
                Iterator iter = meta.iterator();
                while (iter.hasNext()) {
                    JavaClass javaClass = (JavaClass)iter.next();
                    newMetadata.addAll(Arrays.asList(ValueObjectPlugin.expandClass(javaClass)));
                }
                HashMap vObjsNames = new HashMap();
                this.tamperedMetadata = CollectionUtils.select(newMetadata, (Predicate)new Predicate(this, vObjsNames){
                    private final /* synthetic */ Map val$vObjsNames;
                    private final /* synthetic */ QDoxValueObjectExpanderFilterMetadataProvider this$0;
                    {
                        this.this$0 = this$0;
                        this.val$vObjsNames = val$vObjsNames;
                    }

                    public boolean evaluate(Object arg0) {
                        JavaClass javaClass = (JavaClass)arg0;
                        boolean retVal = true;
                        if (this.this$0.vObjPlugin.shouldGenerate(javaClass)) {
                            String vObjectType = this.this$0.vObjPlugin.getVirtualType(javaClass).toString();
                            if (this.val$vObjsNames.containsKey(vObjectType)) {
                                if (this.this$0.log.isWarnEnabled()) {
                                    this.this$0.log.warn((Object)("There is already an value-object generate with same type '" + vObjectType + "'. Ignoring new one."));
                                }
                                retVal = false;
                            } else {
                                this.val$vObjsNames.put(vObjectType, vObjectType);
                            }
                        }
                        return retVal;
                    }
                });
            }
            return this.tamperedMetadata;
        }

        public Collection getOriginalMetadata() {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"getOriginalMetadata() called");
            }
            return super.getMetadata();
        }

        public String getOriginalFileName(Object meta) {
            JavaClass javaClass = (JavaClass)meta;
            String retVal = super.getOriginalFileName(meta);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("getOriginalFileName() javaClass=" + javaClass.getFullyQualifiedName() + " ==> " + retVal));
            }
            return retVal;
        }

        public String getOriginalPackageName(Object meta) {
            JavaClass javaClass = (JavaClass)meta;
            String retVal = super.getOriginalPackageName(meta);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("getOriginalPackageName() javaClass=" + javaClass.getFullyQualifiedName() + " ==> " + retVal));
            }
            return retVal;
        }
    }

    public class ValueObjectMetadata {
        private Log log = LogFactory.getLog((Class)(class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectMetadata == null ? (class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectMetadata = ValueObjectPlugin.class$("org.xdoclet.plugin.ejb.entity.ValueObjectPlugin$ValueObjectMetadata")) : class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectMetadata));
        private Collection fieldLst;
        private Collection relationLst;
        private final PkMetadata pkMetadata;
        private final JavaClass javaClass;
        private final EjbValueObjectTag valueTag;

        public ValueObjectMetadata(JavaClass javaClass, EjbValueObjectTag valueTag, PkMetadata pkMetadata) {
            this.javaClass = javaClass;
            this.fieldLst = new ArrayList();
            this.relationLst = new ArrayList();
            this.valueTag = valueTag;
            this.pkMetadata = pkMetadata;
        }

        public EjbValueObjectTag getValueTag() {
            return this.valueTag;
        }

        public boolean isStrictOrdering() {
            return "strict".equals(this.valueTag.getOrdering());
        }

        public boolean isFullSynchronization() {
            return "full".equals(this.valueTag.getSynchronization());
        }

        public boolean isPartialSynchronization() {
            return "partial".equals(this.valueTag.getSynchronization());
        }

        public boolean isNoSynchronization() {
            return "none".equals(this.valueTag.getSynchronization());
        }

        public boolean isGeneratePKConstructor() {
            return this.valueTag.isGeneratePKConstructor();
        }

        public boolean isFullClone() {
            return this.valueTag.isFullClone();
        }

        public ValueObjectRelationMetadata[] getRelations() {
            return this.relationLst.toArray(new ValueObjectRelationMetadata[0]);
        }

        public ValueObjectRelationMetadata[] getCollectionRelations() {
            Collection relations = CollectionUtils.select((Collection)this.relationLst, (Predicate)new Predicate(this){
                private final /* synthetic */ ValueObjectMetadata this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean evaluate(Object arg0) {
                    ValueObjectRelationMetadata relation = (ValueObjectRelationMetadata)arg0;
                    return relation.isCollection();
                }
            });
            return relations.toArray(new ValueObjectRelationMetadata[0]);
        }

        public ValueObjectRelationMetadata[] getNonCollectionRelations() {
            Collection relations = CollectionUtils.select((Collection)this.relationLst, (Predicate)new Predicate(this){
                private final /* synthetic */ ValueObjectMetadata this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean evaluate(Object arg0) {
                    ValueObjectRelationMetadata relation = (ValueObjectRelationMetadata)arg0;
                    return !relation.isCollection();
                }
            });
            return relations.toArray(new ValueObjectRelationMetadata[0]);
        }

        public ValueObjectFieldMetadata[] getFields() {
            return this.fieldLst.toArray(new ValueObjectFieldMetadata[0]);
        }

        public ValueObjectFieldMetadata[] getPkFields() {
            Collection fields = CollectionUtils.select((Collection)this.fieldLst, (Predicate)new Predicate(this){
                private final /* synthetic */ ValueObjectMetadata this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean evaluate(Object arg0) {
                    ValueObjectFieldMetadata field = (ValueObjectFieldMetadata)arg0;
                    return field.isPrimaryKeyField();
                }
            });
            return fields.toArray(new ValueObjectFieldMetadata[0]);
        }

        public ValueObjectFieldMetadata[] getNonPkFields() {
            Collection fields = CollectionUtils.select((Collection)this.fieldLst, (Predicate)new Predicate(this){
                private final /* synthetic */ ValueObjectMetadata this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean evaluate(Object arg0) {
                    ValueObjectFieldMetadata field = (ValueObjectFieldMetadata)arg0;
                    return !field.isPrimaryKeyField();
                }
            });
            return fields.toArray(new ValueObjectFieldMetadata[0]);
        }

        public void addField(ValueObjectFieldMetadata field) {
            this.fieldLst.add(field);
        }

        public void addRelation(ValueObjectRelationMetadata relation) {
            this.relationLst.add(relation);
        }

        public boolean isSimplePkProperty() {
            return this.pkMetadata.isSimpleProperty();
        }

        public boolean hasPk() {
            return this.getPkProperty() != null;
        }

        public BeanProperty getPkProperty() {
            Type pkType = null;
            String propName = null;
            if (!this.pkMetadata.isSimpleProperty()) {
                if (this.pkMetadata.isEmptyWithParent()) {
                    PkMetadata pkMeta = this.pkMetadata.getParent();
                    pkType = pkMeta.getType().getType();
                    propName = "primaryKey";
                } else if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("Cannot resolve primary key class name (" + this.javaClass.getFullyQualifiedName() + "). Have you forgot to set @ejb.bean \"primkey-field\" or @ejb.pk-field ? (" + this.pkMetadata + ")"));
                }
            } else {
                BeanProperty singleProp = this.pkMetadata.getProperties()[0];
                pkType = singleProp.getType();
                propName = singleProp.getName();
            }
            BeanProperty prop = null;
            if (pkType != null && propName != null) {
                prop = new BeanProperty(propName);
                prop.setType(pkType);
                JavaMethod getter = new JavaMethod(pkType, ValueObjectPlugin.this.getGetterName(prop));
                JavaMethod setter = new JavaMethod(pkType, ValueObjectPlugin.this.getSetterName(prop));
                setter.setParameters(new JavaParameter[]{new JavaParameter(pkType, prop.getName())});
                prop.setAccessor(getter);
                prop.setMutator(setter);
            }
            return prop;
        }
    }

    public class ValueObjectFieldMetadata {
        private Log log = LogFactory.getLog((Class)(class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectFieldMetadata == null ? (class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectFieldMetadata = ValueObjectPlugin.class$("org.xdoclet.plugin.ejb.entity.ValueObjectPlugin$ValueObjectFieldMetadata")) : class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectFieldMetadata));
        private final BeanProperty property;
        private final int metaFlags;

        public ValueObjectFieldMetadata(Type propertyType, String propertyName, int metaFlags) {
            this.metaFlags = metaFlags;
            this.property = new BeanProperty(propertyName);
            this.property.setType(propertyType);
            JavaMethod getter = new JavaMethod(propertyType, ValueObjectPlugin.this.getGetterName(this.property));
            JavaMethod setter = new JavaMethod(propertyType, ValueObjectPlugin.this.getSetterName(this.property));
            setter.setParameters(new JavaParameter[]{new JavaParameter(propertyType, propertyName)});
            this.property.setAccessor(getter);
            this.property.setMutator(setter);
        }

        public BeanProperty getProperty() {
            return this.property;
        }

        public boolean isPrimaryKeyField() {
            return EjbUtils.hasFlag(this.metaFlags, 128);
        }
    }

    public class ValueObjectRelationMetadata {
        private final Log log = LogFactory.getLog((Class)(class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectRelationMetadata == null ? (class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectRelationMetadata = ValueObjectPlugin.class$("org.xdoclet.plugin.ejb.entity.ValueObjectPlugin$ValueObjectRelationMetadata")) : class$org$xdoclet$plugin$ejb$entity$ValueObjectPlugin$ValueObjectRelationMetadata));
        private final JavaClass relationEjb;
        private final boolean isAggregate;
        private final EjbValueObjectFieldTag vTag;
        private Type relationCollectionType;

        public ValueObjectRelationMetadata(JavaClass relationEjb, Type relationCollectionType, boolean isAggregate, EjbValueObjectFieldTag vTag) {
            this.relationEjb = relationEjb;
            this.relationCollectionType = relationCollectionType;
            this.isAggregate = isAggregate;
            this.vTag = vTag;
        }

        public BeanProperty getProperty() {
            Type propType;
            String propName;
            if (this.isCollection()) {
                propName = this.getAggregateNamePlural();
                propType = this.getCollectionType();
            } else {
                propName = this.getAggregateName();
                propType = new Type(this.getAggregate());
            }
            BeanProperty retVal = new BeanProperty(propName);
            retVal.setType(propType);
            JavaMethod getter = new JavaMethod(propType, ValueObjectPlugin.this.getGetterName(retVal));
            JavaMethod setter = new JavaMethod(propType, ValueObjectPlugin.this.getSetterName(retVal));
            setter.setParameters(new JavaParameter[]{new JavaParameter(propType, propName)});
            retVal.setAccessor(getter);
            retVal.setMutator(setter);
            return retVal;
        }

        public boolean isCollection() {
            boolean isCollection = false;
            isCollection |= this.relationCollectionType != null && this.relationCollectionType.isA(COLLECTION_TYPE);
            return isCollection |= this.relationCollectionType != null && this.relationCollectionType.isA(SET_TYPE);
        }

        public Type getCollectionType() {
            Type retVal = null;
            if (this.relationCollectionType != null) {
                if (this.relationCollectionType.isA(COLLECTION_TYPE)) {
                    retVal = COLLECTION_TYPE;
                } else if (this.relationCollectionType.isA(SET_TYPE)) {
                    retVal = SET_TYPE;
                }
            }
            return retVal;
        }

        public Type getCollectionTypeImpl() {
            String concreteType = this.vTag.getConcreteType();
            if (concreteType == null) {
                Type colType = this.getCollectionType();
                if (colType != null && this.relationCollectionType.isA(COLLECTION_TYPE)) {
                    concreteType = (class$java$util$ArrayList == null ? (class$java$util$ArrayList = ValueObjectPlugin.class$("java.util.ArrayList")) : class$java$util$ArrayList).getName();
                } else if (colType != null && this.relationCollectionType.isA(SET_TYPE)) {
                    concreteType = (class$java$util$HashSet == null ? (class$java$util$HashSet = ValueObjectPlugin.class$("java.util.HashSet")) : class$java$util$HashSet).getName();
                } else if (this.log.isErrorEnabled()) {
                    this.log.error((Object)EjbUtils.getMessageWithTagLocation(this.vTag, "Couldn't resolve concrete type for relation"));
                }
            }
            return concreteType != null ? new Type(concreteType) : null;
        }

        public boolean isAggregate() {
            return this.isAggregate;
        }

        public boolean isCompose() {
            return !this.isAggregate;
        }

        public String getAggregate() {
            String aggName = this.isAggregate ? "aggregate" : "compose";
            return this.vTag.getNamedParameter(aggName);
        }

        public String getAggregateName() {
            String aggName = this.isAggregate ? "aggregate" : "compose";
            return this.vTag.getNamedParameter(aggName + "-name");
        }

        public String getAggregateNamePlural() {
            String aggregateName;
            String aggName = this.isAggregate ? "aggregate" : "compose";
            String aggregateNamePlural = this.vTag.getNamedParameter(aggName + "s-name");
            if (aggregateNamePlural == null && (aggregateName = this.getAggregateName()) != null) {
                this.log.debug((Object)"Agregate's s-name not found. Appending 's' aggregate name");
                aggregateNamePlural = aggregateName + "s";
            }
            return aggregateNamePlural;
        }

        public String toString() {
            StringBuffer retBuf = new StringBuffer();
            retBuf.append("[ValueObjectRelationMetadata: ");
            retBuf.append("relationEjb=" + (this.relationEjb != null ? this.relationEjb.getFullyQualifiedName() : null));
            retBuf.append(", isAggregate=" + this.isAggregate);
            retBuf.append(", vTag=" + EjbUtils.tagToString(this.vTag));
            retBuf.append(", aggregate=" + this.getAggregate());
            retBuf.append(", aggregateName=" + this.getAggregateName());
            retBuf.append(", aggregateNamePlural=" + this.getAggregateNamePlural());
            retBuf.append("]");
            return retBuf.toString();
        }
    }
}

