/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.ejb.qtags.EjbFinderTag;

public class EjbFinderTagImpl
extends XDocletTag
implements EjbFinderTag {
    public static final String NAME = "ejb.finder";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("description", "method-intf", "query", "result-type-mapping", "signature", "transaction-type", "view-type", "unchecked", "role-names", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public EjbFinderTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getDescription() {
        boolean required = false;
        String result = this.getNamedParameter("description");
        if (required && result == null) {
            this.bomb("description=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getMethodIntf() {
        boolean required = false;
        String result = this.getNamedParameter("method-intf");
        if (required && result == null) {
            this.bomb("method-intf=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            if (!result.equals("Home") && !result.equals("LocalHome")) {
                this.bomb("method-intf=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public String getQuery() {
        boolean required = false;
        String result = this.getNamedParameter("query");
        if (required && result == null) {
            this.bomb("query=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getResultTypeMapping() {
        boolean required = false;
        String result = this.getNamedParameter("result-type-mapping");
        if (required && result == null) {
            this.bomb("result-type-mapping=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            if (!result.equals("Local") && !result.equals("Remote")) {
                this.bomb("result-type-mapping=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public String getSignature() {
        boolean required = true;
        String result = this.getNamedParameter("signature");
        if (required && result == null) {
            this.bomb("signature=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getTransactionType() {
        boolean required = false;
        String result = this.getNamedParameter("transaction-type");
        if (required && result == null) {
            this.bomb("transaction-type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            if (!(result.equals("NotSupported") || result.equals("Supports") || result.equals("Required") || result.equals("RequiresNew") || result.equals("Mandatory") || result.equals("Never"))) {
                this.bomb("transaction-type=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public String getViewType() {
        boolean required = false;
        String result = this.getNamedParameter("view-type");
        if (required && result == null) {
            this.bomb("view-type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result == null) {
            result = "both";
        }
        if (result != null) {
            if (!(result.equals("local") || result.equals("remote") || result.equals("both"))) {
                this.bomb("view-type=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public boolean isUnchecked() {
        boolean required = false;
        String result = this.getNamedParameter("unchecked");
        if (required && result == null) {
            this.bomb("unchecked=\"???\" must be specified.");
        }
        boolean retVal = false;
        if (result == null) {
            result = "false";
        }
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String[] getRoleNames() {
        boolean required = false;
        String result = this.getNamedParameter("role-names");
        if (required && result == null) {
            this.bomb("role-names=\"???\" must be specified.");
        }
        String[] retVal = null;
        if (result != null) {
            StringTokenizer strTok = new StringTokenizer(result, ",");
            retVal = new String[strTok.countTokens()];
            int idx = 0;
            while (strTok.hasMoreTokens()) {
                String token = strTok.nextToken();
                retVal[idx++] = token;
            }
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnField) {
            this.bomb("is not allowed on fields");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.isOnMethod) {
            this.bomb("is not allowed on methods");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getDescription();
        this.getMethodIntf();
        this.getQuery();
        this.getResultTypeMapping();
        this.getSignature();
        this.getTransactionType();
        this.getViewType();
        this.isUnchecked();
        this.getRoleNames();
    }
}

