/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.ejb.qtags.EjbPermissionTag;

public class EjbPermissionTagImpl
extends XDocletTag
implements EjbPermissionTag {
    public static final String NAME = "ejb.permission";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("method-intf", "view-type", "unchecked", "role-names", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public EjbPermissionTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getMethodIntf() {
        boolean required = false;
        String result = this.getNamedParameter("method-intf");
        if (required && result == null) {
            this.bomb("method-intf=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            if (!(result.equals("Remote") || result.equals("Home") || result.equals("Local") || result.equals("LocalHome") || result.equals("ServiceEndpoint"))) {
                this.bomb("method-intf=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public String getViewType() {
        boolean required = false;
        String result = this.getNamedParameter("view-type");
        if (required && result == null) {
            this.bomb("view-type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            if (!(result.equals("local") || result.equals("remote") || result.equals("both") || result.equals("service-endpoint") || result.equals("remote-service-endpoint") || result.equals("local-service-endpoint") || result.equals("all"))) {
                this.bomb("view-type=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public boolean isUnchecked() {
        boolean required = false;
        String result = this.getNamedParameter("unchecked");
        if (required && result == null) {
            this.bomb("unchecked=\"???\" must be specified.");
        }
        boolean retVal = false;
        if (result == null) {
            result = "false";
        }
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String[] getRoleNames() {
        boolean required = false;
        String result = this.getNamedParameter("role-names");
        if (required && result == null) {
            this.bomb("role-names=\"???\" must be specified.");
        }
        String[] retVal = null;
        if (result != null) {
            StringTokenizer strTok = new StringTokenizer(result, ",");
            retVal = new String[strTok.countTokens()];
            int idx = 0;
            while (strTok.hasMoreTokens()) {
                String token = strTok.nextToken();
                retVal[idx++] = token;
            }
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnField) {
            this.bomb("is not allowed on fields");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getMethodIntf();
        this.getViewType();
        this.isUnchecked();
        this.getRoleNames();
    }
}

