/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.ejb.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.ejb.qtags.EjbValueObjectTag;

public class EjbValueObjectTagImpl
extends XDocletTag
implements EjbValueObjectTag {
    public static final String NAME = "ejb.value-object";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("name", "pattern", "extends", "implements", "ordering", "synchronization", "abstract", "generate-p-k-constructor", "full-clone", "match", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public EjbValueObjectTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getName_() {
        boolean required = true;
        String result = this.getNamedParameter("name");
        if (required && result == null) {
            this.bomb("name=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getPattern() {
        boolean required = false;
        String result = this.getNamedParameter("pattern");
        if (required && result == null) {
            this.bomb("pattern=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getExtends() {
        boolean required = false;
        String result = this.getNamedParameter("extends");
        if (required && result == null) {
            this.bomb("extends=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String[] getImplements() {
        boolean required = false;
        String result = this.getNamedParameter("implements");
        if (required && result == null) {
            this.bomb("implements=\"???\" must be specified.");
        }
        String[] retVal = null;
        if (result != null) {
            StringTokenizer strTok = new StringTokenizer(result, ",");
            retVal = new String[strTok.countTokens()];
            int idx = 0;
            while (strTok.hasMoreTokens()) {
                String token = strTok.nextToken();
                retVal[idx++] = token;
            }
        }
        return retVal;
    }

    public String getOrdering() {
        boolean required = false;
        String result = this.getNamedParameter("ordering");
        if (required && result == null) {
            this.bomb("ordering=\"???\" must be specified.");
        }
        String retVal = null;
        if (result == null) {
            result = "none";
        }
        if (result != null) {
            if (!result.equals("strict") && !result.equals("none")) {
                this.bomb("ordering=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public String getSynchronization() {
        boolean required = false;
        String result = this.getNamedParameter("synchronization");
        if (required && result == null) {
            this.bomb("synchronization=\"???\" must be specified.");
        }
        String retVal = null;
        if (result == null) {
            result = "partial";
        }
        if (result != null) {
            if (!(result.equals("full") || result.equals("partial") || result.equals("none"))) {
                this.bomb("synchronization=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public boolean isAbstract() {
        boolean required = false;
        String result = this.getNamedParameter("abstract");
        if (required && result == null) {
            this.bomb("abstract=\"???\" must be specified.");
        }
        boolean retVal = false;
        if (result == null) {
            result = "false";
        }
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public boolean isGeneratePKConstructor() {
        boolean required = false;
        String result = this.getNamedParameter("generate-p-k-constructor");
        if (required && result == null) {
            this.bomb("generate-p-k-constructor=\"???\" must be specified.");
        }
        boolean retVal = false;
        if (result == null) {
            result = "false";
        }
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public boolean isFullClone() {
        boolean required = false;
        String result = this.getNamedParameter("full-clone");
        if (required && result == null) {
            this.bomb("full-clone=\"???\" must be specified.");
        }
        boolean retVal = false;
        if (result == null) {
            result = "false";
        }
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getMatch() {
        boolean required = false;
        String result = this.getNamedParameter("match");
        if (required && result == null) {
            this.bomb("match=\"???\" must be specified.");
        }
        String retVal = null;
        if (result == null) {
            result = "*";
        }
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnField) {
            this.bomb("is not allowed on fields");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.isOnMethod) {
            this.bomb("is not allowed on methods");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getName_();
        this.getPattern();
        this.getExtends();
        this.getImplements();
        this.getOrdering();
        this.getSynchronization();
        this.isAbstract();
        this.isGeneratePKConstructor();
        this.isFullClone();
        this.getMatch();
    }
}

