/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.portlet;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PortletUtils {
    public String getPortletName(JavaClass clazz) {
        String result = clazz.getNamedParameter("portlet.portlet", "name");
        if (result == null) {
            result = clazz.getName();
        }
        return result;
    }

    public String getPortletDisplayName(JavaClass clazz) {
        String result = clazz.getNamedParameter("portlet.portlet", "display-name");
        if (result == null) {
            result = clazz.getName();
        }
        return result;
    }

    public String getPortletDescription(JavaClass clazz) {
        String result = clazz.getNamedParameter("portlet.portlet", "description");
        if (result == null) {
            result = clazz.getComment();
        }
        return result;
    }

    public String getExpirationCache(JavaClass clazz) {
        String result = clazz.getNamedParameter("portlet.portlet", "expiration-cache");
        if (result == null) {
            result = "-1";
        }
        return result;
    }

    public DocletTag[] getSupports(JavaClass clazz) {
        return clazz.getTagsByName("portlet.supports");
    }

    public String getSupportedMimeType(DocletTag supportTag) {
        return supportTag.getNamedParameter("mime-type");
    }

    public List getSupportedModes(DocletTag supportTag) {
        ArrayList<String> modesList = new ArrayList<String>();
        String modesString = supportTag.getNamedParameter("modes");
        StringTokenizer tokenizer = new StringTokenizer(modesString, ",");
        while (tokenizer.hasMoreTokens()) {
            String mode = tokenizer.nextToken();
            modesList.add(mode);
        }
        return modesList;
    }

    private String chopQuotes(String in) {
        if (in.startsWith("\"") || in.startsWith("'")) {
            in = in.substring(1);
        }
        if (in.endsWith("\"") || in.endsWith("'")) {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    public List getSupportedLocales(JavaClass clazz) {
        ArrayList<String> localesList = new ArrayList<String>();
        DocletTag[] localeTags = clazz.getTagsByName("portlet.locale");
        int i = 0;
        while (i < localeTags.length) {
            localesList.add(this.chopQuotes(localeTags[i].getNamedParameter("locale")));
            ++i;
        }
        return localesList;
    }

    public String getResourceBundle(JavaClass clazz) {
        return this.chopQuotes(clazz.getTagByName("portlet.resource-bundle").getNamedParameter("bundle"));
    }

    public String getPortletTitle(JavaClass clazz) {
        return clazz.getNamedParameter("portlet.portlet-info", "title");
    }

    public String getPortletShortTitle(JavaClass clazz) {
        return clazz.getNamedParameter("portlet.portlet-info", "short-title");
    }

    public String getPortletKeywords(JavaClass clazz) {
        return clazz.getNamedParameter("portlet.portlet-info", "keywords");
    }

    public DocletTag[] getPortletPreferences(JavaClass clazz) {
        return clazz.getTagsByName("portlet.preference");
    }

    public String getPreferencesValidator(JavaClass clazz) {
        return clazz.getNamedParameter("portlet.preferences-validator", "validator-class");
    }

    public String getPreferenceName(DocletTag prefTag) {
        return prefTag.getNamedParameter("name");
    }

    public String getPreferenceValue(DocletTag prefTag) {
        return prefTag.getNamedParameter("value");
    }

    public String getPreferenceReadOnly(DocletTag prefTag) {
        return prefTag.getNamedParameter("read-only");
    }

    public DocletTag[] getPortletInitParams(JavaClass clazz) {
        return clazz.getTagsByName("portlet.portlet-init-param");
    }

    public String getInitParamName(DocletTag paramTag) {
        return paramTag.getNamedParameter("name");
    }

    public String getInitParamValue(DocletTag paramTag) {
        return paramTag.getNamedParameter("value");
    }

    public String getInitParamDescription(DocletTag paramTag) {
        return paramTag.getNamedParameter("description");
    }

    public boolean shouldGenerate(Object metadata) {
        JavaClass javaClass = (JavaClass)metadata;
        boolean isPortlet = javaClass.isA("javax.portlet.Portlet");
        return isPortlet;
    }
}

