/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.common.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import xin.altitude.common.model.ModelRequest;
import xin.altitude.common.util.QueueUtils;

public class ServiceQueueImpl<M extends BaseMapper<T>, T extends Model<T>>
extends ServiceImpl<M, T> {
    protected LinkedBlockingQueue<ModelRequest<T>> queue = new LinkedBlockingQueue();

    @PostConstruct
    public void init() {
        ScheduledThreadPoolExecutor service = new ScheduledThreadPoolExecutor(1);
        Runnable runnable = () -> {
            int size = Math.min(this.queue.size(), 100);
            if (size == 0) {
                return;
            }
            Collection<ModelRequest<ModelRequest>> requests = QueueUtils.listFromQueue(this.queue, size);
            Set ids = requests.stream().map(ModelRequest::getId).collect(Collectors.toSet());
            List lists = this.listByIds(ids);
            Map<Serializable, Model> map = lists.stream().collect(Collectors.toMap(Model::pkVal, e -> e));
            requests.forEach(e -> e.getFuture().complete(map.get(e.getId())));
        };
        service.scheduleAtFixedRate(runnable, 0L, 200L, TimeUnit.MILLISECONDS);
    }
}

