/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.common.util;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConvertUtils {
    public static <T, R> R convertObj(T source, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        return Optional.ofNullable(source).map(action).orElse(null);
    }

    public static <T, R> List<R> convertList(List<T> source, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        if (Objects.nonNull(source)) {
            return source.stream().map(action).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public static <T, R> IPage<R> convertPage(IPage<? extends T> source, Function<? super T, ? extends R> action) {
        Optional<IPage<T>> optional = Optional.ofNullable(source);
        if (optional.isPresent()) {
            List collect = source.getRecords().stream().map(action).collect(Collectors.toList());
            return source.setRecords(collect);
        }
        return null;
    }
}

