/*
 *
 *  * Copyright (c) 2020-2021, Java知识图谱 (http://www.altitude.xin).
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  * you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  *     http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *
 */

package xin.altitude.common.model;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;

/**
 * 响应式查询主键记录
 *
 * @author explore
 */
public class ModelWrapper<T> {
    /**
     * 查询主键ID
     */
    private Serializable id;
    /**
     * 返回注册值
     */
    private CompletableFuture<T> future;
    
    public ModelWrapper(Serializable id, CompletableFuture<T> future) {
        this.id = id;
        this.future = future;
    }
    
    public Serializable getId() {
        return id;
    }
    
    public void setId(Serializable id) {
        this.id = id;
    }
    
    public CompletableFuture<T> getFuture() {
        return future;
    }
    
    public void setFuture(CompletableFuture<T> future) {
        this.future = future;
    }
}