/*
 *
 *  * Copyright (c) 2020-2021, Java知识图谱 (http://www.altitude.xin).
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  * you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  *     http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *
 */

package xin.altitude.common.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collector;

/**
 * 集合转Map等数据类型
 *
 * @author explore
 * @since 2021/11/29 17:57
 **/
interface IMapService<T> extends IVoService<T> {
    // /**
    //  * 查询集合转化为Map
    //  *
    //  * @param idList 主键ID集合
    //  * @return 转换后Map实例
    //  */
    // default Map<Serializable, T> mapByIds(Collection<? extends Serializable> idList) {
    //     return listByIds(idList).stream().collect(toMap(Model::pkVal, e -> e));
    // }
    //
    // /**
    //  * 查询集合转化为Map，支持自定义Value类型
    //  * 默认使用表的主键作为Key
    //  *
    //  * @param idList 主键ID集合
    //  * @param value  转换规则
    //  * @param <V>    转换实体泛型
    //  * @return 转换后Map实例
    //  */
    // default <V> Map<Serializable, V> mapByIds(Collection<? extends Serializable> idList, final Function<? super T, ? extends V> value) {
    //     return listByIds(idList).stream().collect(toMap(Model::pkVal, value));
    // }
    //
    // /**
    //  * 查询集合转化为Map，支持自定义Value类型
    //  *
    //  * @param idList 主键ID集合
    //  * @param key    key转换规则
    //  * @param value  value转换规则
    //  * @param <V>    转换实体泛型
    //  * @return 转换后Map实例
    //  */
    // default <K, V> Map<K, V> mapByIds(Collection<? extends Serializable> idList, final Function<? super T, ? extends K> key, final Function<? super T, ? extends V> value) {
    //     return listByIds(idList).stream().collect(toMap(key, value));
    // }
    //
    // /**
    //  * 查询集合转化为Map
    //  * 默认使用主键作为key的转换规则
    //  * 集合元素实体作为转换规则
    //  *
    //  * @param queryWrapper 查询条件
    //  * @return 转换后Map实例
    //  */
    // default Map<Serializable, T> map(Wrapper<T> queryWrapper) {
    //     return list(queryWrapper).stream().collect(toMap(Model::pkVal, e -> e));
    // }
    //
    // /**
    //  * 查询集合转化为Map
    //  *
    //  * @param queryWrapper 查询条件
    //  * @param value        转换规则
    //  * @param <V>          转换实体泛型
    //  * @return 转换后Map实例
    //  */
    // default <V> Map<Serializable, V> map(Wrapper<T> queryWrapper, final Function<? super T, ? extends V> value) {
    //     return list(queryWrapper).stream().collect(toMap(Model::pkVal, value));
    // }
    //
    // /**
    //  * 查询集合转化为Map
    //  *
    //  * @param queryWrapper 查询条件
    //  * @param key          key转换规则
    //  * @param value        value转换规则
    //  * @param <V>          转换实体泛型
    //  * @return 转换后Map实例
    //  */
    // default <K, V> Map<K, V> map(Wrapper<T> queryWrapper, final Function<? super T, ? extends K> key, final Function<? super T, ? extends V> value) {
    //     return list(queryWrapper).stream().collect(toMap(key, value));
    // }
    //
    // /**
    //  * 查询集合转化为Map
    //  *
    //  * @return 转换后Map实例
    //  */
    // default Map<Serializable, T> map() {
    //     return map(Wrappers.emptyWrapper());
    // }
    
    /**
     * 查询集合转化为Map
     *
     * @param idList 主键ID集合
     * @return 转换后Map实例
     */
    default <R, A> R collectByIds(Collection<? extends Serializable> idList, Collector<? super T, A, R> collector) {
        return listByIds(idList).stream().collect(collector);
    }
    
    /**
     * 查询集合转化为Map
     * 默认使用主键作为key的转换规则
     * 集合元素实体作为转换规则
     *
     * @param queryWrapper 查询条件
     * @return 转换后Map实例
     */
    default <R, A> R collect(Wrapper<T> queryWrapper, Collector<? super T, A, R> collector) {
        return list(queryWrapper).stream().collect(collector);
    }
    
    /**
     * 查询集合转化为Map
     *
     * @return 转换后Map实例
     */
    default <R, A> R collect(Collector<? super T, A, R> collector) {
        return collect(Wrappers.emptyWrapper(), collector);
    }
}
