/*
 *
 *  * Copyright (c) 2020-2021, Java知识图谱 (http://www.altitude.xin).
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  * you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  *     http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *
 */

package xin.altitude.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collector;

/**
 * 集合转转换
 *
 * @author explore
 * @since 2021/11/29 17:57
 **/
public class MapServiceImpl<M extends BaseMapper<T>, T extends Model<T>> extends ServiceImpl<M, T> {
    public <R, A> R collectByIds(Collection<? extends Serializable> idList, Collector<? super T, A, R> collector) {
        return listByIds(idList).stream().collect(collector);
    }
    
    public <R, A> R collect(Wrapper<T> queryWrapper, Collector<? super T, A, R> collector) {
        return list(queryWrapper).stream().collect(collector);
    }
    
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return collect(Wrappers.emptyWrapper(), collector);
    }
    
    /**
     * 查询集合转化为Map，支持自定义Value类型
     * 默认使用表的主键作为Key
     *
     * @param idList 主键ID集合
     * @param value  转换规则
     * @param <V>    转换实体泛型
     * @return 转换后Map实例
     */
    // public <V> Map<Serializable, V> mapByIds(Collection<? extends Serializable> idList, final Function<? super T, ? extends V> value) {
    //     return listByIds(idList).stream().collect(toMap(Model::pkVal, value));
    // }
    
    /**
     * 查询集合转化为Map，支持自定义Value类型
     *
     * @param idList 主键ID集合
     * @param key    key转换规则
     * @param value  value转换规则
     * @param <V>    转换实体泛型
     * @return 转换后Map实例
     */
    // public <K, V> Map<K, V> mapByIds(Collection<? extends Serializable> idList, final Function<? super T, ? extends K> key, final Function<? super T, ? extends V> value) {
    //     return listByIds(idList).stream().collect(toMap(key, value));
    // }
    
    /**
     * 查询集合转化为Map
     *
     * @param queryWrapper 查询条件
     * @param value        转换规则
     * @param <V>          转换实体泛型
     * @return 转换后Map实例
     */
    // public <V> Map<Serializable, V> map(Wrapper<T> queryWrapper, final Function<? super T, ? extends V> value) {
    //     return list(queryWrapper).stream().collect(toMap(Model::pkVal, value));
    // }
    
    /**
     * 查询集合转化为Map
     *
     * @param queryWrapper 查询条件
     * @param key          key转换规则
     * @param value        value转换规则
     * @param <V>          转换实体泛型
     * @return 转换后Map实例
     */
    // public <K, V> Map<K, V> map(Wrapper<T> queryWrapper, final Function<? super T, ? extends K> key, final Function<? super T, ? extends V> value) {
    //     return list(queryWrapper).stream().collect(toMap(key, value));
    // }
    
}
