/*
 *
 *  * Copyright (c) 2020-2021, Java知识图谱 (http://www.altitude.xin).
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  * you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  *     http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *
 */

package xin.altitude.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

import static xin.altitude.common.util.EntityUtils.convertList;
import static xin.altitude.common.util.EntityUtils.convertObj;
import static xin.altitude.common.util.EntityUtils.convertPage2;

/**
 * 结果集转化为Map
 *
 * @author explore
 * @since 2021/11/29 17:57
 **/
public class VoServiceImpl<M extends BaseMapper<T>, T extends Model<T>> extends ServiceImpl<M, T> {
    public <R> R getById(Serializable id, final Function<? super T, ? extends R> action) {
        return convertObj(getById(id), action);
    }
    
    public <R> R getOne(Wrapper<T> queryWrapper, final Function<? super T, ? extends R> action) {
        return convertObj(getOne(queryWrapper), action);
    }
    
    public <E extends IPage<T>, R> IPage<R> page(E page, Wrapper<T> queryWrapper, final Function<? super T, ? extends R> action) {
        return convertPage2(page(page, queryWrapper), action);
    }
    
    public <E extends IPage<T>, R> IPage<R> page(E page, final Function<? super T, ? extends R> action) {
        return convertPage2(page(page, Wrappers.emptyWrapper()), action);
    }
    
    public <R> List<R> listByIds(Collection<? extends Serializable> idList, final Function<? super T, ? extends R> action) {
        return convertList(listByIds(idList), action);
    }
    
    public <R> List<R> list(Wrapper<T> queryWrapper, final Function<? super T, ? extends R> action) {
        return convertList(list(queryWrapper), action);
    }
    
    public <R> List<R> list(final Function<? super T, ? extends R> action) {
        return convertList(list(), action);
    }
    // /**
    //  * 通过主键ID查询实体VO
    //  *
    //  * @param id     主键ID
    //  * @param action 转换规则
    //  * @param <R>    转化后实体VO的泛型
    //  * @return 转换后实体实例
    //  */
    // public <R> R getById(Serializable id, final Function<? super T, ? extends R> action) {
    //     return convertObj(getById(id), action);
    // }
    //
    // /**
    //  * 通过唯一索引查询
    //  *
    //  * @param queryWrapper 查询条件
    //  * @param action       转换规则
    //  * @param <R>          转化后实体VO的泛型
    //  * @return 转换后实体实例
    //  */
    // public <R> R getOne(Wrapper<T> queryWrapper, final Function<? super T, ? extends R> action) {
    //     return convertObj(getOne(queryWrapper), action);
    // }
    //
    // /**
    //  * 分页查询实体并转化为实体VO
    //  *
    //  * @param page         分页对象
    //  * @param queryWrapper 查询条件
    //  * @param action       转换规则
    //  * @param <E>          分页对象泛型
    //  * @param <R>          实体VO分页对象泛型
    //  * @return 实体VO分页对象
    //  */
    // public <E extends IPage<T>, R> IPage<R> page(E page, Wrapper<T> queryWrapper, final Function<? super T, ? extends R> action) {
    //     return convertPage2(page(page, queryWrapper), action);
    // }
    //
    // /**
    //  * 分页查询实体并转化为实体VO
    //  *
    //  * @param page   分页对象
    //  * @param action 转换规则
    //  * @param <E>    分页对象泛型
    //  * @param <R>    实体VO分页对象泛型
    //  * @return 实体VO分页对象
    //  */
    // public <E extends IPage<T>, R> IPage<R> page(E page, final Function<? super T, ? extends R> action) {
    //     return convertPage2(page(page, Wrappers.emptyWrapper()), action);
    // }
    //
    // /**
    //  * 通过主键ID集合查询，并将实体集合映射为其它类型集合，比如VO
    //  *
    //  * @param idList 主键ID集合
    //  * @param action 转换规则
    //  * @param <R>    转换后的泛型类（通常为实体的子类）
    //  * @return 转换后泛型类的集合
    //  */
    // public <R> List<R> listByIds(Collection<? extends Serializable> idList, final Function<? super T, ? extends R> action) {
    //     return convertList(listByIds(idList), action);
    // }
    //
    // /**
    //  * 查询实体并转化为实体VO
    //  *
    //  * @param queryWrapper 查询条件
    //  * @param action       转换规则
    //  * @param <R>          转换后的泛型类（通常为实体的子类）
    //  * @return 转换后泛型类的集合
    //  */
    // public <R> List<R> list(Wrapper<T> queryWrapper, final Function<? super T, ? extends R> action) {
    //     return convertList(list(queryWrapper), action);
    // }
    //
    // /**
    //  * 查询实体并转化为实体VO
    //  *
    //  * @param action 转换规则
    //  * @param <R>    转换后的泛型类（通常为实体的子类）
    //  * @return 转换后泛型类的集合
    //  */
    // public <R> List<R> list(final Function<? super T, ? extends R> action) {
    //     return convertList(list(), action);
    // }
}
