/*
 *
 *  Copyright (c) 2020-2021, Java知识图谱 (http://www.altitude.xin).
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package xin.altitude.common.util;

import java.util.Collection;
import java.util.function.Consumer;

/**
 * 集合工具类
 *
 * @author explore
 * @since 2021/06/03 23:17
 **/
public class ColUtils {
    public static <E> void ifNotEmpty(Collection<E> collection, Consumer<? super Collection<E>> action) {
        if (collection != null && !collection.isEmpty()) {
            action.accept(collection);
        }
    }
}
