/*
 *
 *  * Copyright (c) 2020-2021, Java知识图谱 (http://www.altitude.xin).
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  * you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  *     http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *
 */

package xin.altitude.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;

/**
 * @author explore
 * @since 2021/11/29 19:04
 **/
public class QueueUtils {
    
    /**
     * 从队列中取出指定个数的元素
     *
     * @param queue 队列
     * @param size  个数
     * @param <T>   泛型实体
     * @return 集合
     */
    public static <T> Collection<T> listFromQueue(final Queue<T> queue, int size) {
        Objects.requireNonNull(queue);
        List<T> lists = new ArrayList<>(size);
        for (int i = 0; i < size; i++) {
            lists.add(queue.poll());
        }
        return lists;
    }
}
