/*
 *
 *  Copyright (c) 2020-2021, Java知识图谱 (http://www.altitude.xin).
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package xin.altitude.common.util;

import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

import java.util.Optional;
import java.util.concurrent.Callable;

/**
 * Spring Cache缓存工具类
 *
 * @author explore
 * @since 2021/10/15 14:26
 **/
public class SpringCacheUtils {
    /**
     *
     */
    private final static CacheManager CACHE_MANAGER = SpringUtils.getBean(CacheManager.class);
    
    /**
     * 获取缓存
     *
     * @param cacheName 缓存名称
     * @param key       缓存key
     * @param type      返回值类型
     * @param <T>       泛型
     * @return 返回值
     */
    public static <T> T get(String cacheName, Object key, Class<T> type) {
        Cache cache = CACHE_MANAGER.getCache(cacheName);
        return Optional.ofNullable(cache).map(e -> e.get(key, type)).orElse(null);
    }
    
    public <T> T get(String cacheName, Object key, Callable<T> valueLoader) {
        return null;
    }
    
    public void put(String cacheName, Object key, Object value) {
    
    }
    
    public void evict(String cacheName, Object key) {
    
    }
    
    public boolean evictIfPresent(String cacheName, Object key) {
        return false;
    }
    
    public void clear(String cacheName) {
    
    }
    
    public boolean invalidate(String cacheName) {
        return false;
    }
}
