/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.stream.test.receiver;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.stream.sdk.receiver.Receiver;
import xin.manong.weapon.base.record.KVRecord;
import xin.manong.weapon.base.record.KVRecords;

public class FakeReceiver
extends Receiver {
    private static final Logger logger = LoggerFactory.getLogger(FakeReceiver.class);
    private boolean running = false;
    private Thread workThread;

    public FakeReceiver(Map<String, Object> configMap) {
        super(configMap);
    }

    public boolean start() {
        this.running = true;
        this.workThread = new Thread(() -> {
            while (this.running) {
                KVRecords kvRecords = new KVRecords();
                KVRecord kvRecord = new KVRecord();
                kvRecords.addRecord(kvRecord);
                try {
                    this.receiveProcessor.process((Object)kvRecords);
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        });
        this.workThread.start();
        return true;
    }

    public void stop() {
        this.running = false;
        this.workThread.interrupt();
        try {
            if (this.workThread.isAlive()) {
                this.workThread.join();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

