/*
 * Decompiled with CFR 0.152.
 */
package xyz.fabiano.spring.localstack;

import cloud.localstack.docker.LocalstackDocker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import xyz.fabiano.spring.localstack.LocalstackService;

public class LocalstackDockerBuilder {
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private List<LocalstackService> services = new ArrayList<LocalstackService>();
    private String externalHost = "localhost";
    private boolean randomPorts;
    private boolean pullNewImage = false;

    public LocalstackDocker build() {
        LocalstackDocker docker = LocalstackDocker.getLocalstackDocker();
        docker.setRandomizePorts(this.randomPorts);
        docker.setPullNewImage(this.pullNewImage);
        docker.setExternalHostName(this.externalHost);
        String servicesJoined = this.services.stream().map(LocalstackService::toString).collect(Collectors.joining(","));
        if (StringUtils.isNotEmpty((CharSequence)servicesJoined)) {
            this.environmentVariables.put("SERVICES", servicesJoined);
        }
        docker.setEnvironmentVariables(this.environmentVariables);
        return docker;
    }

    public LocalstackDockerBuilder withService(LocalstackService service) {
        this.services.add(service);
        return this;
    }

    public LocalstackDockerBuilder withServices(LocalstackService ... services) {
        this.services.addAll(Arrays.asList(services));
        return this;
    }

    public LocalstackDockerBuilder withStaticPorts() {
        this.randomPorts = false;
        return this;
    }

    public LocalstackDockerBuilder withRandomPorts() {
        this.randomPorts = true;
        return this;
    }

    public LocalstackDockerBuilder withRandomPorts(boolean random) {
        this.randomPorts = random;
        return this;
    }

    public LocalstackDockerBuilder notPullingNewImages() {
        this.pullNewImage = false;
        return this;
    }

    public LocalstackDockerBuilder alwaysPullingNewImages() {
        this.pullNewImage = true;
        return this;
    }

    public LocalstackDockerBuilder pullingNewImages(boolean pullNewImage) {
        this.pullNewImage = pullNewImage;
        return this;
    }

    public LocalstackDockerBuilder withExternalHost(String externalHost) {
        this.externalHost = externalHost;
        return this;
    }

    public LocalstackDockerBuilder withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }
}

