/*
 * Decompiled with CFR 0.152.
 */
package xyz.fabiano.spring.localstack.help;

import cloud.localstack.TestUtils;
import cloud.localstack.docker.LocalstackDocker;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.apigateway.AmazonApiGatewayAsync;
import com.amazonaws.services.apigateway.AmazonApiGatewayAsyncClientBuilder;
import com.amazonaws.services.cloudformation.AmazonCloudFormationAsync;
import com.amazonaws.services.cloudformation.AmazonCloudFormationAsyncClientBuilder;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsyncClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsyncClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsAsyncClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.AmazonKinesisAsyncClientBuilder;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseAsync;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseAsyncClientBuilder;
import com.amazonaws.services.lambda.AWSLambdaAsync;
import com.amazonaws.services.lambda.AWSLambdaAsyncClientBuilder;
import com.amazonaws.services.redshift.AmazonRedshiftAsync;
import com.amazonaws.services.redshift.AmazonRedshiftAsyncClientBuilder;
import com.amazonaws.services.route53.AmazonRoute53Async;
import com.amazonaws.services.route53.AmazonRoute53AsyncClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceAsync;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceAsyncClientBuilder;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.AmazonSNSAsyncClientBuilder;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import java.util.function.Supplier;

public class DockerClientsHolder {
    private static final String region = Regions.DEFAULT_REGION.getName();
    private static final LocalstackDocker DOCKER = LocalstackDocker.getLocalstackDocker();

    public static AmazonS3 amazonS3() {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(TestUtils.getCredentialsProvider())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(DOCKER.getEndpointS3(), region))).build();
    }

    public static AmazonSQSAsync amazonSQSAsync() {
        return (AmazonSQSAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonSQSAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointSQS());
    }

    public static AmazonSNSAsync amazonSNSAsync() {
        return (AmazonSNSAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonSNSAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointSNS());
    }

    public static AmazonKinesisAsync amazonKinesisAsync() {
        return (AmazonKinesisAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonKinesisAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointKinesis());
    }

    public static AmazonDynamoDBAsync amazonDynamoDBAsync() {
        return (AmazonDynamoDBAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonDynamoDBAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointDynamoDB());
    }

    public static AmazonDynamoDBStreamsAsync amazonDynamoDBStreamsAsync() {
        return (AmazonDynamoDBStreamsAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonDynamoDBStreamsAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointDynamoDBStreams());
    }

    public static AmazonSimpleEmailServiceAsync amazonSimpleEmailServiceAsync() {
        return (AmazonSimpleEmailServiceAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonSimpleEmailServiceAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointSES());
    }

    public static AmazonApiGatewayAsync amazonApiGatewayAsync() {
        return (AmazonApiGatewayAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonApiGatewayAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointAPIGateway());
    }

    public static AmazonRedshiftAsync amazonRedshiftAsync() {
        return (AmazonRedshiftAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonRedshiftAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointRedshift());
    }

    public static AmazonCloudWatchAsync amazonCloudWatchAsync() {
        return (AmazonCloudWatchAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonCloudWatchAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointCloudWatch());
    }

    public static AmazonCloudFormationAsync amazonCloudFormationAsync() {
        return (AmazonCloudFormationAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonCloudFormationAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointCloudFormation());
    }

    public static AmazonKinesisFirehoseAsync amazonKinesisFirehoseAsync() {
        return (AmazonKinesisFirehoseAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonKinesisFirehoseAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointFirehose());
    }

    public static AmazonRoute53Async amazonRoute53Async() {
        return (AmazonRoute53Async)DockerClientsHolder.decorateWithConfigsAndBuild(AmazonRoute53AsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointRoute53());
    }

    public static AWSLambdaAsync awsLambdaAsync() {
        return (AWSLambdaAsync)DockerClientsHolder.decorateWithConfigsAndBuild(AWSLambdaAsyncClientBuilder.standard(), () -> ((LocalstackDocker)DOCKER).getEndpointLambda());
    }

    public static <S, T extends AwsAsyncClientBuilder<T, S>> S decorateWithConfigsAndBuild(T builder, Supplier<String> endpointSupplier) {
        return (S)((AwsAsyncClientBuilder)((AwsAsyncClientBuilder)builder.withCredentials(TestUtils.getCredentialsProvider())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpointSupplier.get(), region))).build();
    }
}

