/*
 * Decompiled with CFR 0.152.
 */
package xyz.felh.openai.jtokkit.utils;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.felh.openai.chat.tool.Function;
import xyz.felh.openai.chat.tool.Tool;
import xyz.felh.openai.utils.Preconditions;

public class FunctionFormat {
    private static final Logger log = LoggerFactory.getLogger(FunctionFormat.class);

    public static String formatFunctionDefinitions(List<Tool> tools) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("namespace functions {");
        lines.add("");
        for (Tool tool : tools) {
            JSONObject p;
            JSONObject properties;
            Function function = tool.getFunction();
            if (Preconditions.isNotBlank((Object)function.getDescription())) {
                lines.add(String.format("// %s", function.getDescription()));
            }
            if (Preconditions.isNotBlank((Object)(properties = (p = JSONObject.parseObject((String)JSONObject.toJSONString((Object)function.getParameters(), (JSONWriter.Feature[])new JSONWriter.Feature[0]))).getJSONObject("properties"))) && Preconditions.isNotBlank((Object)properties.keySet())) {
                lines.add(String.format("type %s = (_: {", function.getName()));
                lines.add(FunctionFormat.formatObjectProperties(p, 0));
                lines.add("}) => any;");
            } else {
                lines.add(String.format("type %s = () => any;", function.getName()));
            }
            lines.add("");
        }
        lines.add("} // namespace functions");
        return String.join((CharSequence)"\n", lines);
    }

    private static String formatObjectProperties(JSONObject p, int indent) {
        JSONObject properties = p.getJSONObject("properties");
        if (Preconditions.isBlank((Object)properties)) {
            return "";
        }
        List requiredParams = p.getList("required", String.class, new JSONReader.Feature[0]);
        ArrayList<String> lines = new ArrayList<String>();
        for (String key : properties.keySet()) {
            JSONObject props = properties.getJSONObject(key);
            String description = props.getString("description");
            if (Preconditions.isNotBlank((Object)description)) {
                lines.add(String.format("// %s", description));
            }
            String question = "?";
            if (Preconditions.isNotBlank((Object)requiredParams) && requiredParams.contains(key)) {
                question = "";
            }
            lines.add(String.format("%s%s: %s,", key, question, FunctionFormat.formatType(props, indent)));
        }
        return lines.stream().map(it -> " ".repeat(Math.max(0, indent)) + it).collect(Collectors.joining("\n"));
    }

    private static String formatType(JSONObject props, int indent) {
        String type;
        return switch (type = props.getString("type")) {
            case "string" -> {
                if (props.containsKey("enum")) {
                    yield props.getList("enum", String.class, new JSONReader.Feature[0]).stream().map(it -> String.format("\"%s\"", it)).collect(Collectors.joining(" | "));
                }
                yield "string";
            }
            case "array" -> {
                if (props.containsKey("items")) {
                    yield String.format("%s[]", FunctionFormat.formatType(props.getJSONObject("items"), indent));
                }
                yield "any[]";
            }
            case "object" -> String.format("{\n%s\n}", FunctionFormat.formatObjectProperties(props, indent + 2));
            case "integer", "number" -> {
                if (props.containsKey("enum")) {
                    yield String.join((CharSequence)" | ", props.getList("enum", String.class, new JSONReader.Feature[0]).stream().map(it -> String.format("\"%s\"", it)).toList());
                }
                yield "number";
            }
            case "boolean" -> "boolean";
            case "null" -> "null";
            default -> "";
        };
    }
}

