/*
 * Decompiled with CFR 0.152.
 */
package firrtl.proto;

import com.google.protobuf.CodedInputStream;
import firrtl.CDefMPort;
import firrtl.CDefMemory;
import firrtl.FirrtlProtos;
import firrtl.MInfer$;
import firrtl.MPortDir;
import firrtl.MRead$;
import firrtl.MReadWrite$;
import firrtl.MWrite$;
import firrtl.ir.AnalogType;
import firrtl.ir.AsyncResetType$;
import firrtl.ir.Attach;
import firrtl.ir.Block;
import firrtl.ir.BundleType;
import firrtl.ir.Circuit;
import firrtl.ir.ClockType$;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefInstance;
import firrtl.ir.DefMemory;
import firrtl.ir.DefModule;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Default$;
import firrtl.ir.Direction;
import firrtl.ir.DoPrim;
import firrtl.ir.DoubleParam;
import firrtl.ir.EmptyStmt$;
import firrtl.ir.Expression;
import firrtl.ir.ExtModule;
import firrtl.ir.Field;
import firrtl.ir.FileInfo;
import firrtl.ir.FixedLiteral;
import firrtl.ir.FixedType;
import firrtl.ir.Flip$;
import firrtl.ir.Info;
import firrtl.ir.Input$;
import firrtl.ir.IntParam;
import firrtl.ir.IntWidth;
import firrtl.ir.IntWidth$;
import firrtl.ir.IsInvalid;
import firrtl.ir.Module;
import firrtl.ir.Mux;
import firrtl.ir.NoInfo$;
import firrtl.ir.Orientation;
import firrtl.ir.Output$;
import firrtl.ir.Param;
import firrtl.ir.PartialConnect;
import firrtl.ir.Port;
import firrtl.ir.PrimOp;
import firrtl.ir.Print;
import firrtl.ir.RawStringParam;
import firrtl.ir.ReadUnderWrite$;
import firrtl.ir.Reference;
import firrtl.ir.ResetType$;
import firrtl.ir.SIntLiteral;
import firrtl.ir.SIntType;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.StringLit;
import firrtl.ir.StringParam;
import firrtl.ir.SubAccess;
import firrtl.ir.SubField;
import firrtl.ir.SubIndex;
import firrtl.ir.Type;
import firrtl.ir.UIntLiteral;
import firrtl.ir.UIntType;
import firrtl.ir.UnknownType$;
import firrtl.ir.UnknownWidth$;
import firrtl.ir.VectorType;
import firrtl.proto.ToProto$;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class FromProto$ {
    public static FromProto$ MODULE$;
    private final Map<FirrtlProtos.Firrtl.Expression.PrimOp.Op, PrimOp> convert;

    static {
        new FromProto$();
    }

    public Circuit fromFile(String filename) {
        return this.fromInputStream(new FileInputStream(new File(filename)));
    }

    public Circuit fromInputStream(InputStream is2) {
        CodedInputStream cistream = CodedInputStream.newInstance((InputStream)is2);
        cistream.setRecursionLimit(Integer.MAX_VALUE);
        FirrtlProtos.Firrtl pb = FirrtlProtos.Firrtl.parseFrom(cistream);
        return this.convert(pb);
    }

    private Statement compressStmts(Seq<Statement> stmts) {
        Statement statement;
        Seq<Statement> seq = stmts;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            statement = EmptyStmt$.MODULE$;
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                Statement stmt = (Statement)((SeqLike)some2.get()).apply(0);
                statement = stmt;
            } else {
                statement = new Block(seq);
            }
        }
        return statement;
    }

    public Info convert(FirrtlProtos.Firrtl.SourceInfo info) {
        Info info2;
        int n = info.getSourceInfoCase().getNumber();
        switch (n) {
            case 2: {
                FirrtlProtos.Firrtl.SourceInfo.Position pos = info.getPosition();
                String str = new StringBuilder(2).append(pos.getFilename()).append(" ").append(pos.getLine()).append(":").append(pos.getColumn()).toString();
                info2 = new FileInfo(new StringLit(str));
                break;
            }
            case 3: {
                info2 = new FileInfo(new StringLit(info.getText()));
                break;
            }
            default: {
                info2 = NoInfo$.MODULE$;
                break;
            }
        }
        return info2;
    }

    public Map<FirrtlProtos.Firrtl.Expression.PrimOp.Op, PrimOp> convert() {
        return this.convert;
    }

    public BigInt convert(FirrtlProtos.Firrtl.Expression.IntegerLiteral literal) {
        return package$.MODULE$.BigInt().apply(literal.getValue());
    }

    public BigInt convert(FirrtlProtos.Firrtl.BigInt bigint) {
        return package$.MODULE$.BigInt().apply(bigint.getValue().toByteArray());
    }

    public UIntLiteral convert(FirrtlProtos.Firrtl.Expression.UIntLiteral uint) {
        UnknownWidth$ width = uint.hasWidth() ? this.convert(uint.getWidth()) : UnknownWidth$.MODULE$;
        return new UIntLiteral(this.convert(uint.getValue()), width);
    }

    public SIntLiteral convert(FirrtlProtos.Firrtl.Expression.SIntLiteral sint) {
        UnknownWidth$ width = sint.hasWidth() ? this.convert(sint.getWidth()) : UnknownWidth$.MODULE$;
        return new SIntLiteral(this.convert(sint.getValue()), width);
    }

    public FixedLiteral convert(FirrtlProtos.Firrtl.Expression.FixedLiteral fixed) {
        UnknownWidth$ width = fixed.hasWidth() ? this.convert(fixed.getWidth()) : UnknownWidth$.MODULE$;
        UnknownWidth$ point = fixed.hasPoint() ? this.convert(fixed.getPoint()) : UnknownWidth$.MODULE$;
        return new FixedLiteral(this.convert(fixed.getValue()), width, point);
    }

    public SubField convert(FirrtlProtos.Firrtl.Expression.SubField subfield) {
        return new SubField(this.convert(subfield.getExpression()), subfield.getField(), UnknownType$.MODULE$);
    }

    public SubIndex convert(FirrtlProtos.Firrtl.Expression.SubIndex index) {
        return new SubIndex(this.convert(index.getExpression()), this.convert(index.getIndex()).toInt(), UnknownType$.MODULE$);
    }

    public SubAccess convert(FirrtlProtos.Firrtl.Expression.SubAccess access) {
        return new SubAccess(this.convert(access.getExpression()), this.convert(access.getIndex()), UnknownType$.MODULE$);
    }

    public DoPrim convert(FirrtlProtos.Firrtl.Expression.PrimOp primop) {
        Buffer args = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(primop.getArgList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.convert((FirrtlProtos.Firrtl.Expression)x$1), Buffer$.MODULE$.canBuildFrom());
        Buffer consts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(primop.getConstList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.convert((FirrtlProtos.Firrtl.Expression.IntegerLiteral)x$2), Buffer$.MODULE$.canBuildFrom());
        return new DoPrim((PrimOp)this.convert().apply((Object)primop.getOp()), (Seq<Expression>)args, (Seq<BigInt>)consts, UnknownType$.MODULE$);
    }

    public Mux convert(FirrtlProtos.Firrtl.Expression.Mux mux) {
        return new Mux(this.convert(mux.getCondition()), this.convert(mux.getTValue()), this.convert(mux.getFValue()), UnknownType$.MODULE$);
    }

    public Expression convert(FirrtlProtos.Firrtl.Expression expr) {
        Expression expression;
        int n = expr.getExpressionCase().getNumber();
        switch (n) {
            case 1: {
                expression = new Reference(expr.getReference().getId(), UnknownType$.MODULE$);
                break;
            }
            case 7: {
                expression = this.convert(expr.getSubField());
                break;
            }
            case 8: {
                expression = this.convert(expr.getSubIndex());
                break;
            }
            case 9: {
                expression = this.convert(expr.getSubAccess());
                break;
            }
            case 2: {
                expression = this.convert(expr.getUintLiteral());
                break;
            }
            case 3: {
                expression = this.convert(expr.getSintLiteral());
                break;
            }
            case 11: {
                expression = this.convert(expr.getFixedLiteral());
                break;
            }
            case 10: {
                expression = this.convert(expr.getPrimOp());
                break;
            }
            case 6: {
                expression = this.convert(expr.getMux());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return expression;
    }

    public Connect convert(FirrtlProtos.Firrtl.Statement.Connect con, FirrtlProtos.Firrtl.SourceInfo info) {
        return new Connect(this.convert(info), this.convert(con.getLocation()), this.convert(con.getExpression()));
    }

    public PartialConnect convert(FirrtlProtos.Firrtl.Statement.PartialConnect con, FirrtlProtos.Firrtl.SourceInfo info) {
        return new PartialConnect(this.convert(info), this.convert(con.getLocation()), this.convert(con.getExpression()));
    }

    public DefWire convert(FirrtlProtos.Firrtl.Statement.Wire wire, FirrtlProtos.Firrtl.SourceInfo info) {
        return new DefWire(this.convert(info), wire.getId(), this.convert(wire.getType()));
    }

    public DefRegister convert(FirrtlProtos.Firrtl.Statement.Register reg, FirrtlProtos.Firrtl.SourceInfo info) {
        return new DefRegister(this.convert(info), reg.getId(), this.convert(reg.getType()), this.convert(reg.getClock()), this.convert(reg.getReset()), this.convert(reg.getInit()));
    }

    public DefNode convert(FirrtlProtos.Firrtl.Statement.Node node, FirrtlProtos.Firrtl.SourceInfo info) {
        return new DefNode(this.convert(info), node.getId(), this.convert(node.getExpression()));
    }

    public DefInstance convert(FirrtlProtos.Firrtl.Statement.Instance inst, FirrtlProtos.Firrtl.SourceInfo info) {
        return new DefInstance(this.convert(info), inst.getId(), inst.getModuleId());
    }

    public Conditionally convert(FirrtlProtos.Firrtl.Statement.When when2, FirrtlProtos.Firrtl.SourceInfo info) {
        Statement conseq = this.compressStmts((Seq<Statement>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(when2.getConsequentList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.convert((FirrtlProtos.Firrtl.Statement)x$3), Buffer$.MODULE$.canBuildFrom())));
        Statement alt = this.compressStmts((Seq<Statement>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(when2.getOtherwiseList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.convert((FirrtlProtos.Firrtl.Statement)x$4), Buffer$.MODULE$.canBuildFrom())));
        return new Conditionally(this.convert(info), this.convert(when2.getPredicate()), conseq, alt);
    }

    public Enumeration.Value convert(FirrtlProtos.Firrtl.Statement.ReadUnderWrite ruw) {
        Enumeration.Value value;
        FirrtlProtos.Firrtl.Statement.ReadUnderWrite readUnderWrite = ruw;
        if (((Object)((Object)FirrtlProtos.Firrtl.Statement.ReadUnderWrite.UNDEFINED)).equals((Object)readUnderWrite)) {
            value = ReadUnderWrite$.MODULE$.Undefined();
        } else if (((Object)((Object)FirrtlProtos.Firrtl.Statement.ReadUnderWrite.OLD)).equals((Object)readUnderWrite)) {
            value = ReadUnderWrite$.MODULE$.Old();
        } else if (((Object)((Object)FirrtlProtos.Firrtl.Statement.ReadUnderWrite.NEW)).equals((Object)readUnderWrite)) {
            value = ReadUnderWrite$.MODULE$.New();
        } else {
            throw new MatchError((Object)readUnderWrite);
        }
        return value;
    }

    public Tuple2<Type, BigInt> convert(FirrtlProtos.Firrtl.Statement.CMemory.TypeAndDepth dt) {
        return new Tuple2((Object)this.convert(dt.getDataType()), (Object)this.convert(dt.getDepth()));
    }

    public Statement convert(FirrtlProtos.Firrtl.Statement.CMemory cmem, FirrtlProtos.Firrtl.SourceInfo info) {
        Tuple2 tuple2;
        int n = cmem.getTypeCase().getNumber();
        switch (n) {
            case 2: {
                VectorType vtpe = this.convert(cmem.getVectorType());
                tuple2 = new Tuple2((Object)vtpe.tpe(), (Object)package$.MODULE$.BigInt().apply(vtpe.size()));
                break;
            }
            case 4: {
                tuple2 = this.convert(cmem.getTypeAndDepth());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Type tpe = (Type)tuple22._1();
        BigInt depth = (BigInt)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)tpe, (Object)depth);
        Tuple2 tuple24 = tuple23;
        Type tpe2 = (Type)tuple24._1();
        BigInt depth2 = (BigInt)tuple24._2();
        return new CDefMemory(this.convert(info), cmem.getId(), tpe2, depth2, cmem.getSyncRead(), this.convert(cmem.getReadUnderWrite()));
    }

    public MPortDir convert(FirrtlProtos.Firrtl.Statement.MemoryPort.Direction mportdir) {
        MPortDir mPortDir;
        FirrtlProtos.Firrtl.Statement.MemoryPort.Direction direction = mportdir;
        if (((Object)((Object)FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.MEMORY_PORT_DIRECTION_INFER)).equals((Object)direction)) {
            mPortDir = MInfer$.MODULE$;
        } else if (((Object)((Object)FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.MEMORY_PORT_DIRECTION_READ)).equals((Object)direction)) {
            mPortDir = MRead$.MODULE$;
        } else if (((Object)((Object)FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.MEMORY_PORT_DIRECTION_WRITE)).equals((Object)direction)) {
            mPortDir = MWrite$.MODULE$;
        } else if (((Object)((Object)FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.MEMORY_PORT_DIRECTION_READ_WRITE)).equals((Object)direction)) {
            mPortDir = MReadWrite$.MODULE$;
        } else {
            throw new MatchError((Object)direction);
        }
        return mPortDir;
    }

    public CDefMPort convert(FirrtlProtos.Firrtl.Statement.MemoryPort port, FirrtlProtos.Firrtl.SourceInfo info) {
        Seq exprs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.convert(port.getMemoryIndex()), this.convert(port.getExpression())}));
        return new CDefMPort(this.convert(info), port.getId(), UnknownType$.MODULE$, port.getMemoryId(), (Seq<Expression>)exprs, this.convert(port.getDirection()));
    }

    public Print convert(FirrtlProtos.Firrtl.Statement.Printf printf2, FirrtlProtos.Firrtl.SourceInfo info) {
        Buffer args = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(printf2.getArgList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.convert((FirrtlProtos.Firrtl.Expression)x$6), Buffer$.MODULE$.canBuildFrom());
        StringLit str = new StringLit(printf2.getValue());
        return new Print(this.convert(info), str, (Seq<Expression>)args, this.convert(printf2.getClk()), this.convert(printf2.getEn()));
    }

    public Stop convert(FirrtlProtos.Firrtl.Statement.Stop stop2, FirrtlProtos.Firrtl.SourceInfo info) {
        return new Stop(this.convert(info), stop2.getReturnValue(), this.convert(stop2.getClk()), this.convert(stop2.getEn()));
    }

    public DefMemory convert(FirrtlProtos.Firrtl.Statement.Memory mem, FirrtlProtos.Firrtl.SourceInfo info) {
        BigInt bigInt;
        Type dtype = this.convert(mem.getType());
        Buffer rs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((List)mem.getReaderIdList()).asScala();
        Buffer ws = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((List)mem.getWriterIdList()).asScala();
        Buffer rws = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((List)mem.getReadwriterIdList()).asScala();
        int n = mem.getDepthCase().getNumber();
        switch (n) {
            case 3: {
                bigInt = package$.MODULE$.BigInt().apply(mem.getUintDepth());
                break;
            }
            case 9: {
                bigInt = this.convert(mem.getBigintDepth());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        BigInt depth = bigInt;
        return new DefMemory(this.convert(info), mem.getId(), dtype, depth, mem.getWriteLatency(), mem.getReadLatency(), (Seq<String>)rs, (Seq<String>)ws, (Seq<String>)rws, this.convert(mem.getReadUnderWrite()));
    }

    public Attach convert(FirrtlProtos.Firrtl.Statement.Attach attach2, FirrtlProtos.Firrtl.SourceInfo info) {
        Buffer exprs = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(attach2.getExpressionList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.convert((FirrtlProtos.Firrtl.Expression)x$7), Buffer$.MODULE$.canBuildFrom());
        return new Attach(this.convert(info), (Seq<Expression>)exprs);
    }

    public Statement convert(FirrtlProtos.Firrtl.Statement stmt) {
        Statement statement;
        FirrtlProtos.Firrtl.SourceInfo info = stmt.getSourceInfo();
        int n = stmt.getStatementCase().getNumber();
        switch (n) {
            case 6: {
                statement = this.convert(stmt.getNode(), info);
                break;
            }
            case 15: {
                statement = this.convert(stmt.getConnect(), info);
                break;
            }
            case 16: {
                statement = this.convert(stmt.getPartialConnect(), info);
                break;
            }
            case 1: {
                statement = this.convert(stmt.getWire(), info);
                break;
            }
            case 2: {
                statement = this.convert(stmt.getRegister(), info);
                break;
            }
            case 7: {
                statement = this.convert(stmt.getWhen(), info);
                break;
            }
            case 5: {
                statement = this.convert(stmt.getInstance(), info);
                break;
            }
            case 10: {
                statement = this.convert(stmt.getPrintf(), info);
                break;
            }
            case 8: {
                statement = this.convert(stmt.getStop(), info);
                break;
            }
            case 3: {
                statement = this.convert(stmt.getMemory(), info);
                break;
            }
            case 17: {
                statement = new IsInvalid(this.convert(info), this.convert(stmt.getIsInvalid().getExpression()));
                break;
            }
            case 4: {
                statement = this.convert(stmt.getCmemory(), info);
                break;
            }
            case 18: {
                statement = this.convert(stmt.getMemoryPort(), info);
                break;
            }
            case 20: {
                statement = this.convert(stmt.getAttach(), info);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return statement;
    }

    public IntWidth convert(FirrtlProtos.Firrtl.Width width) {
        return IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(width.getValue()));
    }

    public UIntType convert(FirrtlProtos.Firrtl.Type.UIntType ut) {
        UnknownWidth$ w = ut.hasWidth() ? this.convert(ut.getWidth()) : UnknownWidth$.MODULE$;
        return new UIntType(w);
    }

    public SIntType convert(FirrtlProtos.Firrtl.Type.SIntType st) {
        UnknownWidth$ w = st.hasWidth() ? this.convert(st.getWidth()) : UnknownWidth$.MODULE$;
        return new SIntType(w);
    }

    public FixedType convert(FirrtlProtos.Firrtl.Type.FixedType fixed) {
        UnknownWidth$ w = fixed.hasWidth() ? this.convert(fixed.getWidth()) : UnknownWidth$.MODULE$;
        UnknownWidth$ p = fixed.hasPoint() ? this.convert(fixed.getPoint()) : UnknownWidth$.MODULE$;
        return new FixedType(w, p);
    }

    public AnalogType convert(FirrtlProtos.Firrtl.Type.AnalogType analog) {
        UnknownWidth$ w = analog.hasWidth() ? this.convert(analog.getWidth()) : UnknownWidth$.MODULE$;
        return new AnalogType(w);
    }

    public Field convert(FirrtlProtos.Firrtl.Type.BundleType.Field field) {
        Orientation flip = field.getIsFlipped() ? Flip$.MODULE$ : Default$.MODULE$;
        return new Field(field.getId(), flip, this.convert(field.getType()));
    }

    public VectorType convert(FirrtlProtos.Firrtl.Type.VectorType vtpe) {
        return new VectorType(this.convert(vtpe.getType()), vtpe.getSize());
    }

    public Type convert(FirrtlProtos.Firrtl.Type tpe) {
        Type type;
        int n = tpe.getTypeCase().getNumber();
        switch (n) {
            case 2: {
                type = this.convert(tpe.getUintType());
                break;
            }
            case 3: {
                type = this.convert(tpe.getSintType());
                break;
            }
            case 7: {
                type = this.convert(tpe.getFixedType());
                break;
            }
            case 4: {
                type = ClockType$.MODULE$;
                break;
            }
            case 9: {
                type = AsyncResetType$.MODULE$;
                break;
            }
            case 10: {
                type = ResetType$.MODULE$;
                break;
            }
            case 8: {
                type = this.convert(tpe.getAnalogType());
                break;
            }
            case 5: {
                type = new BundleType((Seq<Field>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tpe.getBundleType().getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.convert((FirrtlProtos.Firrtl.Type.BundleType.Field)x$8), Buffer$.MODULE$.canBuildFrom())));
                break;
            }
            case 6: {
                type = this.convert(tpe.getVectorType());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return type;
    }

    public Direction convert(FirrtlProtos.Firrtl.Port.Direction dir) {
        Direction direction;
        FirrtlProtos.Firrtl.Port.Direction direction2 = dir;
        if (((Object)((Object)FirrtlProtos.Firrtl.Port.Direction.PORT_DIRECTION_IN)).equals((Object)direction2)) {
            direction = Input$.MODULE$;
        } else if (((Object)((Object)FirrtlProtos.Firrtl.Port.Direction.PORT_DIRECTION_OUT)).equals((Object)direction2)) {
            direction = Output$.MODULE$;
        } else {
            throw new MatchError((Object)direction2);
        }
        return direction;
    }

    public Port convert(FirrtlProtos.Firrtl.Port port) {
        Direction dir = this.convert(port.getDirection());
        Type tpe = this.convert(port.getType());
        return new Port(NoInfo$.MODULE$, port.getId(), dir, tpe);
    }

    public Param convert(FirrtlProtos.Firrtl.Module.ExternalModule.Parameter param) {
        Param param2;
        String name = param.getId();
        int n = param.getValueCase().getNumber();
        switch (n) {
            case 2: {
                param2 = new IntParam(name, this.convert(param.getInteger()));
                break;
            }
            case 3: {
                param2 = new DoubleParam(name, param.getDouble());
                break;
            }
            case 4: {
                param2 = new StringParam(name, new StringLit(param.getString()));
                break;
            }
            case 5: {
                param2 = new RawStringParam(name, param.getRawString());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return param2;
    }

    public Module convert(FirrtlProtos.Firrtl.Module.UserModule module) {
        String name = module.getId();
        Buffer ports = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(module.getPortList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.convert((FirrtlProtos.Firrtl.Port)x$9), Buffer$.MODULE$.canBuildFrom());
        Buffer stmts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(module.getStatementList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.convert((FirrtlProtos.Firrtl.Statement)x$10), Buffer$.MODULE$.canBuildFrom());
        return new Module(NoInfo$.MODULE$, name, (Seq<Port>)ports, new Block((Seq<Statement>)stmts));
    }

    public ExtModule convert(FirrtlProtos.Firrtl.Module.ExternalModule module) {
        String name = module.getId();
        Buffer ports = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(module.getPortList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.convert((FirrtlProtos.Firrtl.Port)x$11), Buffer$.MODULE$.canBuildFrom());
        String defname = module.getDefinedName();
        Buffer params = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(module.getParameterList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.convert((FirrtlProtos.Firrtl.Module.ExternalModule.Parameter)x$12), Buffer$.MODULE$.canBuildFrom());
        return new ExtModule(NoInfo$.MODULE$, name, (Seq<Port>)ports, defname, (Seq<Param>)params);
    }

    public DefModule convert(FirrtlProtos.Firrtl.Module module) {
        DefModule defModule;
        if (module.hasUserModule()) {
            defModule = this.convert(module.getUserModule());
        } else {
            Predef$.MODULE$.require(module.hasExternalModule(), (Function0 & Serializable & scala.Serializable)() -> "Module must have Module or ExtModule");
            defModule = this.convert(module.getExternalModule());
        }
        return defModule;
    }

    public Circuit convert(FirrtlProtos.Firrtl proto) {
        Predef$.MODULE$.require(proto.getCircuitCount() == 1, (Function0 & Serializable & scala.Serializable)() -> "Only 1 circuit is currently supported");
        FirrtlProtos.Firrtl.Circuit c = proto.getCircuit(0);
        Predef$.MODULE$.require(c.getTopCount() == 1, (Function0 & Serializable & scala.Serializable)() -> "Only 1 top is currently supported");
        Buffer modules = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(c.getModuleList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> MODULE$.convert((FirrtlProtos.Firrtl.Module)x$13), Buffer$.MODULE$.canBuildFrom());
        String top2 = c.getTop(0).getName();
        return new Circuit(NoInfo$.MODULE$, (Seq<DefModule>)modules, top2);
    }

    private FromProto$() {
        MODULE$ = this;
        this.convert = (Map)ToProto$.MODULE$.convert().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PrimOp k = (PrimOp)tuple2._1();
            FirrtlProtos.Firrtl.Expression.PrimOp.Op v = (FirrtlProtos.Firrtl.Expression.PrimOp.Op)((Object)((Object)tuple2._2()));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v), (Object)k);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }
}

