/*
 * Decompiled with CFR 0.152.
 */
package treadle;

import firrtl.AnnotationSeq;
import firrtl.CircuitForm;
import firrtl.annotations.Annotation;
import firrtl.ir.Info;
import firrtl.options.StageOptions;
import firrtl.options.Viewer$;
import firrtl.options.package$StageOptionsView$;
import firrtl.stage.FirrtlSourceAnnotation;
import firrtl.stage.OutputFileAnnotation;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Calendar;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import treadle.CallResetAtStartupAnnotation$;
import treadle.ClockInfoAnnotation;
import treadle.HasTreadleSuite;
import treadle.RandomSeedAnnotation;
import treadle.ResetNameAnnotation;
import treadle.TreadleTester$;
import treadle.VcdShowUnderScoredAnnotation$;
import treadle.VerboseAnnotation$;
import treadle.WriteVcdAnnotation$;
import treadle.chronometry.UTC;
import treadle.chronometry.UTC$;
import treadle.executable.ClockInfo;
import treadle.executable.ClockInfo$;
import treadle.executable.ClockStepper;
import treadle.executable.ExecutionEngine;
import treadle.executable.ExecutionEngine$;
import treadle.executable.ExpressionViewRenderer;
import treadle.executable.ExpressionViewRenderer$;
import treadle.executable.MultiClockStepper;
import treadle.executable.NoClockStepper;
import treadle.executable.SimpleSingleClockStepper;
import treadle.executable.Symbol;
import treadle.executable.TreadleException;
import treadle.executable.WaveformValues;
import treadle.package$;
import treadle.stage.TreadleCompatibilityPhase$;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001\u0002*T\u0001YC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\u0006I\u0002!\t!\u001a\u0005\u0006I\u0002!\t!\u001b\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0001\u0003\u000bA\u0011\"!\u0004\u0001\u0001\u0004%\t!a\u0004\t\u0011\u0005m\u0001\u0001)Q\u0005\u0003\u000fA\u0011\"!\b\u0001\u0005\u0004%\t!a\b\t\u0011\u00055\u0002\u0001)A\u0005\u0003CA\u0011\"a\f\u0001\u0005\u0004%\t!!\r\t\u0011\u0005}\u0002\u0001)A\u0005\u0003gA\u0011\"!\u0011\u0001\u0005\u0004%\t!a\u0011\t\u000f\u0005\u0015\u0003\u0001)A\u0005Y\"I\u0011q\t\u0001C\u0002\u0013%\u0011\u0011\n\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002L!I\u0011Q\r\u0001C\u0002\u0013%\u0011q\r\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002j!I\u0011\u0011\u000f\u0001C\u0002\u0013\u0005\u0011q\r\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002j!I\u0011Q\u000f\u0001C\u0002\u0013%\u0011q\r\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002j!I\u0011\u0011\u0010\u0001C\u0002\u0013\u0005\u00111\t\u0005\b\u0003w\u0002\u0001\u0015!\u0003m\u0011%\ti\b\u0001b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0011BA5\u0011%\t\t\t\u0001b\u0001\n\u0013\t\u0019\t\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BAC\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+C\u0011\"a'\u0001#\u0003%\t!!(\t\u0013\u0005M\u0006A1A\u0005\u0002\u0005U\u0006\u0002CA_\u0001\u0001\u0006I!a.\t\u0013\u0005}\u0006A1A\u0005\u0002\u0005%\u0003\u0002CAa\u0001\u0001\u0006I!a\u0013\t\u0013\u0005\r\u0007A1A\u0005\u0002\u0005\u0015\u0007\u0002CAg\u0001\u0001\u0006I!a2\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"I\u0011q\u001b\u0001C\u0002\u0013\u0005\u0011Q\u0017\u0005\t\u00033\u0004\u0001\u0015!\u0003\u00028\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\n\u0003O\u0004\u0001\u0019!C\u0005\u0003kC\u0011\"!;\u0001\u0001\u0004%I!a;\t\u0011\u0005=\b\u0001)Q\u0005\u0003oC\u0011\"!=\u0001\u0001\u0004%I!a=\t\u0013\u0005m\b\u00011A\u0005\n\u0005u\b\u0002\u0003B\u0001\u0001\u0001\u0006K!!>\t\u000f\t\r\u0001\u0001\"\u0001\u0003\u0006!9!1\u0001\u0001\u0005\u0002\t-\u0001\"\u0003B\u0012\u0001E\u0005I\u0011\u0001B\u0013\u0011\u001d\u0011I\u0003\u0001C\u0001\u0003OBqAa\u000b\u0001\t\u0003\u0011i\u0003C\u0004\u0003<\u0001!\tA!\u0010\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003D!9!\u0011\n\u0001\u0005\u0002\t-\u0003b\u0002B(\u0001\u0011\u0005!\u0011\u000b\u0005\n\u0005;\u0002\u0011\u0013!C\u0001\u0005?BqAa\u0019\u0001\t\u0003\t)\fC\u0004\u0003f\u0001!\tAa\u001a\t\u0013\t5\u0004!%A\u0005\u0002\t=\u0004b\u0002B:\u0001\u0011\u0005!Q\u000f\u0005\b\u0005\u007f\u0002A\u0011\u0001BA\u0011\u001d\u00119\t\u0001C\u0001\u0005\u0013C\u0011Ba%\u0001#\u0003%\tAa\u0018\t\u000f\tU\u0005\u0001\"\u0001\u0003\u0018\"I!\u0011\u0017\u0001\u0012\u0002\u0013\u0005!1\u0017\u0005\n\u0005o\u0003\u0011\u0013!C\u0001\u0005_B\u0011B!/\u0001#\u0003%\tAa\u001c\t\u000f\tm\u0006\u0001\"\u0001\u0003>\"9!q\u0018\u0001\u0005\u0002\t\u0005\u0007b\u0002Bd\u0001\u0011\u0005!\u0011\u001a\u0005\b\u0005\u001b\u0004A\u0011AAz\u0011\u001d\u0011y\r\u0001C\u0001\u0003\u0007BqA!5\u0001\t\u0003\t)\u000fC\u0004\u0003T\u0002!\t!a\u001a\b\u000f\tU7\u000b#\u0001\u0003X\u001a1!k\u0015E\u0001\u00053Da\u0001Z&\u0005\u0002\tm\u0007b\u0002Bo\u0017\u0012\u0005!q\u001c\u0005\b\u0005C\\E\u0011\u0001Br\u0011%\u0011IpSI\u0001\n\u0003\u0011Y\u0010C\u0004\u0003b.#\tAa@\t\u0013\r\u00151*%A\u0005\u0002\r\u001d!!\u0004+sK\u0006$G.\u001a+fgR,'OC\u0001U\u0003\u001d!(/Z1eY\u0016\u001c\u0001a\u0005\u0002\u0001/B\u0011\u0001lW\u0007\u00023*\t!,A\u0003tG\u0006d\u0017-\u0003\u0002]3\n1\u0011I\\=SK\u001a\fQ\"\u00198o_R\fG/[8o'\u0016\f\bCA0c\u001b\u0005\u0001'\"A1\u0002\r\u0019L'O\u001d;m\u0013\t\u0019\u0007MA\u0007B]:|G/\u0019;j_:\u001cV-]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0019D\u0007CA4\u0001\u001b\u0005\u0019\u0006\"B/\u0003\u0001\u0004qF\u0003\u00024korDQa[\u0002A\u00021\fQ!\u001b8qkR\u0004\"!\u001c;\u000f\u00059\u0014\bCA8Z\u001b\u0005\u0001(BA9V\u0003\u0019a$o\\8u}%\u00111/W\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002t3\")\u0001p\u0001a\u0001s\u0006qq\u000e\u001d;j_:\u001cX*\u00198bO\u0016\u0014\bCA4{\u0013\tY8KA\bICN$&/Z1eY\u0016\u001cV/\u001b;f\u0011\u001di8\u0001%AA\u0002y\f1bY5sGVLGOR8s[B\u0011ql`\u0005\u0004\u0003\u0003\u0001'aC\"je\u000e,\u0018\u000e\u001e$pe6\fq\"\u001a=qK\u000e$\u0018\r^5p]NlU\r^\u000b\u0003\u0003\u000f\u00012\u0001WA\u0005\u0013\r\tY!\u0017\u0002\u0004\u0013:$\u0018aE3ya\u0016\u001cG/\u0019;j_:\u001cX*\u001a;`I\u0015\fH\u0003BA\t\u0003/\u00012\u0001WA\n\u0013\r\t)\"\u0017\u0002\u0005+:LG\u000fC\u0005\u0002\u001a\u0015\t\t\u00111\u0001\u0002\b\u0005\u0019\u0001\u0010J\u0019\u0002!\u0015D\b/Z2uCRLwN\\:NKR\u0004\u0013\u0001C<bY2$\u0016.\\3\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001d2+A\u0006dQJ|gn\\7fiJL\u0018\u0002BA\u0016\u0003K\u00111!\u0016+D\u0003%9\u0018\r\u001c7US6,\u0007%\u0001\u0004f]\u001eLg.Z\u000b\u0003\u0003g\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003s\u0019\u0016AC3yK\u000e,H/\u00192mK&!\u0011QHA\u001c\u0005=)\u00050Z2vi&|g.\u00128hS:,\u0017aB3oO&tW\rI\u0001\ne\u0016\u001cX\r\u001e(b[\u0016,\u0012\u0001\\\u0001\u000be\u0016\u001cX\r\u001e(b[\u0016\u0004\u0013!C2m_\u000e\\\u0017J\u001c4p+\t\tY\u0005\u0005\u0004\u0002N\u0005]\u0013Q\f\b\u0005\u0003\u001f\n\u0019FD\u0002p\u0003#J\u0011AW\u0005\u0004\u0003+J\u0016a\u00029bG.\fw-Z\u0005\u0005\u00033\nYFA\u0002TKFT1!!\u0016Z!\u0011\t)$a\u0018\n\t\u0005\u0005\u0014q\u0007\u0002\n\u00072|7m[%oM>\f!b\u00197pG.LeNZ8!\u0003!9(/\u001b;f-\u000e$WCAA5!\rA\u00161N\u0005\u0004\u0003[J&a\u0002\"p_2,\u0017M\\\u0001\noJLG/\u001a,dI\u0002\n!C^2e'\"|w/\u00168eKJ\u001c8m\u001c:fI\u0006\u0019bo\u00193TQ><XK\u001c3feN\u001cwN]3eA\u0005\u00112-\u00197m%\u0016\u001cX\r^!u'R\f'\u000f^+q\u0003M\u0019\u0017\r\u001c7SKN,G/\u0011;Ti\u0006\u0014H/\u00169!\u0003\u001d!x\u000e\u001d(b[\u0016\f\u0001\u0002^8q\u001d\u0006lW\rI\u0001\bm\u0016\u0014(m\\:f\u0003!1XM\u001d2pg\u0016\u0004\u0013\u0001D:uC\u001e,w\n\u001d;j_:\u001cXCAAC!\u0011\t9)!$\u000e\u0005\u0005%%bAAFA\u00069q\u000e\u001d;j_:\u001c\u0018\u0002BAH\u0003\u0013\u0013Ab\u0015;bO\u0016|\u0005\u000f^5p]N\fQb\u001d;bO\u0016|\u0005\u000f^5p]N\u0004\u0013AC:fiZ+'OY8tKR!\u0011\u0011CAL\u0011%\tIj\u0007I\u0001\u0002\u0004\tI'A\u0003wC2,X-\u0001\u000btKR4VM\u001d2pg\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0003?SC!!\u001b\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.f\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0005ti\u0006\u0014H\u000fV5nKV\u0011\u0011q\u0017\t\u00041\u0006e\u0016bAA^3\n!Aj\u001c8h\u0003)\u0019H/\u0019:u)&lW\rI\u0001\u000eG2|7m[%oM>d\u0015n\u001d;\u0002\u001d\rdwnY6J]\u001a|G*[:uA\u0005a1\r\\8dWN#X\r\u001d9feV\u0011\u0011q\u0019\t\u0005\u0003k\tI-\u0003\u0003\u0002L\u0006]\"\u0001D\"m_\u000e\\7\u000b^3qa\u0016\u0014\u0018!D2m_\u000e\\7\u000b^3qa\u0016\u0014\b%A\u0006bIZ\fgnY3US6,G\u0003BA\t\u0003'Dq!!6$\u0001\u0004\t9,\u0001\u0005j]R,'O^1m\u0003I\u0019w.\u001c2j]\u0006$\u0018n\u001c8bY\u0012+G.Y=\u0002'\r|WNY5oCRLwN\\1m\t\u0016d\u0017-\u001f\u0011\u0002\u000bI,7/\u001a;\u0015\t\u0005E\u0011q\u001c\u0005\b\u0003C4\u0003\u0019AA\\\u0003)!\u0018.\\3SC&\u001cX\rZ\u0001\r[\u0006\\Wm\u00158baNDw\u000e\u001e\u000b\u0003\u0003#\t1BZ1jYV\u0014X\rV5nK\u0006ya-Y5mkJ,G+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u00055\b\"CA\rS\u0005\u0005\t\u0019AA\\\u000311\u0017-\u001b7ve\u0016$\u0016.\\3!\u0003!1\u0017-\u001b7D_\u0012,WCAA{!\u0015A\u0016q_A\u0004\u0013\r\tI0\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0019\u0019\f\u0017\u000e\\\"pI\u0016|F%Z9\u0015\t\u0005E\u0011q \u0005\n\u00033a\u0013\u0011!a\u0001\u0003k\f\u0011BZ1jY\u000e{G-\u001a\u0011\u0002\t\u0019\f\u0017\u000e\u001c\u000b\u0005\u0003#\u00119\u0001C\u0004\u0003\n9\u0002\r!a\u0002\u0002\t\r|G-\u001a\u000b\u0007\u0005\u001b\u0011\u0019B!\b\u0011\u0007a\u0013y!C\u0002\u0003\u0012e\u0013qAT8uQ&tw\rC\u0004\u0003\u0016=\u0002\rAa\u0006\u0002\u0005\u0015D\b\u0003BA'\u00053IAAa\u0007\u0002\\\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\n\u0005?y\u0003\u0013!a\u0001\u0005C\t1!\\:h!\u0011A\u0016q\u001f7\u0002\u001d\u0019\f\u0017\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0005\u0016\u0005\u0005C\t\t+\u0001\u0003jg>[\u0015A\u00034pe\u000e,g+\u00197vKR1\u0011\u0011\u0003B\u0018\u0005gAaA!\r3\u0001\u0004a\u0017\u0001\u00028b[\u0016Dq!!'3\u0001\u0004\u0011)\u0004\u0005\u0003\u0002N\t]\u0012\u0002\u0002B\u001d\u00037\u0012aAQ5h\u0013:$\u0018aD2mK\u0006\u0014hi\u001c:dKZ\u000bG.^3\u0015\t\u0005E!q\b\u0005\u0007\u0005c\u0019\u0004\u0019\u00017\u0002\tA|7.\u001a\u000b\u0007\u0003#\u0011)Ea\u0012\t\r\tEB\u00071\u0001m\u0011\u001d\tI\n\u000ea\u0001\u0005k\tA\u0001]3fWR!!Q\u0007B'\u0011\u0019\u0011\t$\u000ea\u0001Y\u00061Q\r\u001f9fGR$\u0002\"!\u0005\u0003T\tU#\u0011\f\u0005\u0007\u0005c1\u0004\u0019\u00017\t\u000f\t]c\u00071\u0001\u00036\u0005iQ\r\u001f9fGR,GMV1mk\u0016D\u0001Ba\u00177!\u0003\u0005\r\u0001\\\u0001\b[\u0016\u001c8/Y4f\u0003A)\u0007\u0010]3di\u0012\"WMZ1vYR$3'\u0006\u0002\u0003b)\u001aA.!)\u0002\u0015\rL8\r\\3D_VtG/\u0001\u0003ti\u0016\u0004H\u0003BA\t\u0005SB\u0011Ba\u001b:!\u0003\u0005\r!a\u0002\u0002\u00039\fab\u001d;fa\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003r)\"\u0011qAAQ\u0003)\u0001xn[3NK6|'/\u001f\u000b\t\u0003#\u00119H!\u001f\u0003~!1!\u0011G\u001eA\u00021DqAa\u001f<\u0001\u0004\t9!A\u0003j]\u0012,\u0007\u0010C\u0004\u0002\u001an\u0002\rA!\u000e\u0002\u0015A,Wm['f[>\u0014\u0018\u0010\u0006\u0004\u00036\t\r%Q\u0011\u0005\u0007\u0005ca\u0004\u0019\u00017\t\u000f\tmD\b1\u0001\u0002\b\u0005aQ\r\u001f9fGRlU-\\8ssRQ\u0011\u0011\u0003BF\u0005\u001b\u0013yI!%\t\r\tER\b1\u0001m\u0011\u001d\u0011Y(\u0010a\u0001\u0003\u000fAqAa\u0016>\u0001\u0004\u0011)\u0004\u0003\u0005\u0003\\u\u0002\n\u00111\u0001m\u0003Y)\u0007\u0010]3di6+Wn\u001c:zI\u0011,g-Y;mi\u0012\"\u0014AD<bm\u00164wN]7WC2,Xm\u001d\u000b\t\u00053\u0013yJ!+\u0003.B!\u0011Q\u0007BN\u0013\u0011\u0011i*a\u000e\u0003\u001d]\u000bg/\u001a4pe64\u0016\r\\;fg\"I!\u0011U \u0011\u0002\u0003\u0007!1U\u0001\fgfl'm\u001c7OC6,7\u000f\u0005\u0003Y\u0005Kc\u0017b\u0001BT3\n)\u0011I\u001d:bs\"I!1V \u0011\u0002\u0003\u0007\u0011qA\u0001\u000bgR\f'\u000f^\"zG2,\u0007\"\u0003BX\u007fA\u0005\t\u0019AA\u0004\u0003!)g\u000eZ\"zG2,\u0017\u0001G<bm\u00164wN]7WC2,Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0017\u0016\u0005\u0005G\u000b\t+\u0001\rxCZ,gm\u001c:n-\u0006dW/Z:%I\u00164\u0017-\u001e7uII\n\u0001d^1wK\u001a|'/\u001c,bYV,7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003E\tG\u000e\\,bm\u00164wN]7WC2,Xm]\u000b\u0003\u00053\u000ba\u0002Z3qK:$WM\\2z\u0013:4w\u000eF\u0002m\u0005\u0007DaA!2E\u0001\u0004a\u0017AC:z[\n|GNT1nK\u0006Q\u0011n\u001d*fO&\u001cH/\u001a:\u0015\t\u0005%$1\u001a\u0005\u0007\u0005\u000b,\u0005\u0019\u00017\u0002\u001b\u001d,Go\u0015;paJ+7/\u001e7u\u00031\u0011X\r]8siN#(/\u001b8h\u0003\u0019\u0011X\r]8si\u00061a-\u001b8jg\"\fQ\u0002\u0016:fC\u0012dW\rV3ti\u0016\u0014\bCA4L'\tYu\u000b\u0006\u0002\u0003X\u0006\tr-\u001a;EK\u001a\fW\u000f\u001c;NC:\fw-\u001a:\u0016\u0003e\fQ!\u00199qYf$RA\u001aBs\u0005ODQa\u001b(A\u00021Dq\u0001\u001f(\u0011\u0002\u0003\u0007\u0011\u0010K\u0004O\u0005W\u0014\tP!>\u0011\u0007a\u0013i/C\u0002\u0003pf\u0013!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\u0011\u00190\u0001\u0015Vg\u0016\u0004CK]3bI2,G+Z:uKJD\u0013M\u001c8pi\u0006$\u0018n\u001c8TKFL\u0003%\u001b8ti\u0016\fG-\t\u0002\u0003x\u000611/\u001b8dK\u0002\nq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0003\u0005{T3!_AQ)\r17\u0011\u0001\u0005\u0007\u0007\u0007\u0001\u0006\u0019\u00010\u0002\u0017\u0005tgn\u001c;bi&|gn]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r%!f\u0001@\u0002\"\u0002")
public class TreadleTester {
    private int expectationsMet = 0;
    private final UTC wallTime;
    private final ExecutionEngine engine;
    private final String resetName;
    private final Seq<ClockInfo> clockInfo;
    private final boolean writeVcd;
    private final boolean vcdShowUnderscored;
    private final boolean callResetAtStartUp;
    private final String topName;
    private final boolean verbose;
    private final StageOptions stageOptions;
    private final long startTime;
    private final Seq<ClockInfo> clockInfoList;
    private final ClockStepper clockStepper;
    private final long combinationalDelay;
    private long failureTime;
    private Option<Object> failCode;

    public static CircuitForm $lessinit$greater$default$3() {
        return TreadleTester$.MODULE$.$lessinit$greater$default$3();
    }

    public static TreadleTester apply(AnnotationSeq annotationSeq) {
        return TreadleTester$.MODULE$.apply(annotationSeq);
    }

    public static HasTreadleSuite apply$default$2() {
        return TreadleTester$.MODULE$.apply$default$2();
    }

    public static TreadleTester apply(String string, HasTreadleSuite hasTreadleSuite) {
        return TreadleTester$.MODULE$.apply(string, hasTreadleSuite);
    }

    public static HasTreadleSuite getDefaultManager() {
        return TreadleTester$.MODULE$.getDefaultManager();
    }

    public int expectationsMet() {
        return this.expectationsMet;
    }

    public void expectationsMet_$eq(int x$1) {
        this.expectationsMet = x$1;
    }

    public UTC wallTime() {
        return this.wallTime;
    }

    public ExecutionEngine engine() {
        return this.engine;
    }

    public String resetName() {
        return this.resetName;
    }

    private Seq<ClockInfo> clockInfo() {
        return this.clockInfo;
    }

    private boolean writeVcd() {
        return this.writeVcd;
    }

    public boolean vcdShowUnderscored() {
        return this.vcdShowUnderscored;
    }

    private boolean callResetAtStartUp() {
        return this.callResetAtStartUp;
    }

    public String topName() {
        return this.topName;
    }

    private boolean verbose() {
        return this.verbose;
    }

    private StageOptions stageOptions() {
        return this.stageOptions;
    }

    public void setVerbose(boolean value) {
        this.wallTime().isVerbose_$eq(value);
        this.engine().setVerbose(value);
    }

    public boolean setVerbose$default$1() {
        return true;
    }

    public long startTime() {
        return this.startTime;
    }

    public Seq<ClockInfo> clockInfoList() {
        return this.clockInfoList;
    }

    public ClockStepper clockStepper() {
        return this.clockStepper;
    }

    public void advanceTime(long interval) {
        Predef$.MODULE$.assert(interval >= 0L, (Function0 & Serializable & scala.Serializable)() -> "TreadleTester#advanceTime called with negative value");
        this.wallTime().setTime(this.wallTime().currentTime() + interval);
        this.engine().evaluateCircuit();
    }

    public long combinationalDelay() {
        return this.combinationalDelay;
    }

    public void reset(long timeRaised) {
        this.engine().symbolTable().get(this.resetName()).foreach((Function1 & Serializable & scala.Serializable)resetSymbol -> {
            BoxedUnit boxedUnit;
            this.engine().setValue(this.resetName(), BigInt$.MODULE$.int2bigInt(1), this.engine().setValue$default$3(), this.engine().setValue$default$4(), this.engine().setValue$default$5());
            ClockStepper clockStepper = this.clockStepper();
            if (clockStepper instanceof NoClockStepper) {
                this.engine().setValue(this.resetName(), BigInt$.MODULE$.int2bigInt(1), this.engine().setValue$default$3(), this.engine().setValue$default$4(), this.engine().setValue$default$5());
                this.engine().evaluateCircuit();
                this.wallTime().incrementTime(timeRaised);
                boxedUnit = this.engine().setValue(this.resetName(), BigInt$.MODULE$.int2bigInt(0), this.engine().setValue$default$3(), this.engine().setValue$default$4(), this.engine().setValue$default$5());
            } else if (clockStepper instanceof SimpleSingleClockStepper) {
                SimpleSingleClockStepper simpleSingleClockStepper = (SimpleSingleClockStepper)clockStepper;
                this.clockStepper().addTask(this.wallTime().currentTime() + timeRaised + simpleSingleClockStepper.downPeriod(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.engine().setValue(this.resetName(), BigInt$.MODULE$.int2bigInt(0), this.engine().setValue$default$3(), this.engine().setValue$default$4(), this.engine().setValue$default$5());
                    if (this.engine().verbose()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(17).append("reset dropped at ").append(this.wallTime().currentTime()).toString());
                    }
                    this.engine().evaluateCircuit();
                });
                while (true) {
                    BigInt bigInt = this.engine().dataStore().apply((Symbol)resetSymbol);
                    BigInt bigInt2 = package$.MODULE$.Big0();
                    if (!(bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2))) break;
                    simpleSingleClockStepper.run(1);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.clockStepper().addTask(this.wallTime().currentTime() + timeRaised, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        this.engine().setValue(this.resetName(), BigInt$.MODULE$.int2bigInt(0), this.engine().setValue$default$3(), this.engine().setValue$default$4(), this.engine().setValue$default$5());
                        if (!this.engine().verbose()) break block0;
                        Predef$.MODULE$.println((Object)new StringBuilder(17).append("reset dropped at ").append(this.wallTime().currentTime()).toString());
                    }
                });
                this.wallTime().runUntil(this.wallTime().currentTime() + timeRaised);
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public void makeSnapshot() {
        String snapshotName = this.stageOptions().getBuildFileName(this.topName(), (Option<String>)new Some((Object)".datastore.snapshot.json"));
        PrintWriter writer = new PrintWriter(snapshotName);
        writer.write(this.engine().dataStore().serialize());
        writer.close();
        Predef$.MODULE$.println((Object)new StringBuilder(22).append("Writing snapshot file ").append(snapshotName).toString());
    }

    private long failureTime() {
        return this.failureTime;
    }

    private void failureTime_$eq(long x$1) {
        this.failureTime = x$1;
    }

    private Option<Object> failCode() {
        return this.failCode;
    }

    private void failCode_$eq(Option<Object> x$1) {
        this.failCode = x$1;
    }

    public void fail(int code) {
        block0: {
            if (!this.failCode().isEmpty()) break block0;
            this.failureTime_$eq(System.nanoTime());
            this.failCode_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)code)));
            this.makeSnapshot();
        }
    }

    public Nothing$ fail(Throwable ex, Option<String> msg) {
        this.engine().writeVCD();
        Option<String> option = msg;
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            Predef$.MODULE$.println((Object)s);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.fail(2);
        throw ex;
    }

    public Option<String> fail$default$2() {
        return None$.MODULE$;
    }

    public boolean isOK() {
        Some some;
        int n;
        Option<Object> option = this.failCode();
        boolean bl = None$.MODULE$.equals(option) ? true : option instanceof Some && 0 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value()));
        boolean bl2 = bl;
        return bl2;
    }

    public void forceValue(String name, BigInt value) {
        block4: {
            Option<Symbol> option = this.engine().symbolTable().get(name);
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                Symbol symbol = (Symbol)some.value();
                symbol.forcedValue_$eq((Option<BigInt>)new Some((Object)value));
                if (this.engine().symbolTable().isRegister(name)) {
                    String x$1 = name;
                    BigInt x$2 = value;
                    boolean x$3 = true;
                    boolean x$4 = this.engine().setValue$default$3();
                    int x$5 = this.engine().setValue$default$5();
                    boxedUnit = this.engine().setValue(x$1, x$2, x$4, x$3, x$5);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.engine().inputsChanged_$eq(true);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder(48).append("Error: forceValue(").append(name).append(", ").append(value).append(") ").append(name).append(" not found in symbol table").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (!this.engine().dataStore().leanMode()) break block4;
            this.engine().scheduler().setLeanMode(false);
        }
    }

    public void clearForceValue(String name) {
        Option<Symbol> option = this.engine().symbolTable().get(name);
        if (option instanceof Some) {
            Some some = (Some)option;
            Symbol symbol = (Symbol)some.value();
            symbol.forcedValue_$eq((Option<BigInt>)None$.MODULE$);
            this.engine().inputsChanged_$eq(true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(51).append("Error: clearForceValue(").append(name).append(") ").append(name).append(" not found in symbol table").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void poke(String name, BigInt value) {
        try {
            boolean isRegister = this.engine().symbolTable().isRegister(name);
            String x$1 = name;
            BigInt x$2 = value;
            boolean x$3 = isRegister;
            boolean x$4 = this.engine().setValue$default$3();
            int x$5 = this.engine().setValue$default$5();
            this.engine().setValue(x$1, x$2, x$4, x$3, x$5);
        }
        catch (TreadleException ie) {
            throw this.fail(ie, (Option<String>)new Some((Object)new StringBuilder(15).append("Error: poke(").append(name).append(", ").append(value).append(")").toString()));
        }
    }

    public BigInt peek(String name) {
        block2: {
            if (!this.engine().inputsChanged()) break block2;
            if (this.engine().verbose()) {
                Predef$.MODULE$.println((Object)new StringBuilder(43).append("peeking ").append(name).append(" on stale circuit, refreshing START").toString());
            }
            this.engine().evaluateCircuit();
            this.clockStepper().combinationalBump(this.combinationalDelay());
            if (this.engine().verbose()) {
                Predef$.MODULE$.println((Object)new StringBuilder(42).append("peeking ").append(name).append(" on stale circuit, refreshing DONE").toString());
            }
        }
        return this.engine().getValue(name, this.engine().getValue$default$2());
    }

    public void expect(String name, BigInt expectedValue, String message) {
        BigInt value;
        BigInt bigInt = value = this.peek(name);
        BigInt bigInt2 = expectedValue;
        if (bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2)) {
            Info info = this.engine().scheduler().getAssignerInfo(name);
            ExpressionViewRenderer renderer = new ExpressionViewRenderer(this.engine().dataStore(), this.engine().symbolTable(), this.engine().expressionViews(), ExpressionViewRenderer$.MODULE$.$lessinit$greater$default$4());
            String calculation = renderer.render(this.engine().symbolTable().apply(name), this.wallTime().currentTime(), renderer.render$default$3(), renderer.render$default$4());
            throw this.fail(new TreadleException(new StringBuilder(37).append("Error:expect(").append(name).append(", ").append(expectedValue).append(") got ").append(value).append(" ").append(message).append("\n").append(calculation).append("\nAssigned at: ").append(info).toString()), this.fail$default$2());
        }
        this.expectationsMet_$eq(this.expectationsMet() + 1);
    }

    public String expect$default$3() {
        return "";
    }

    public long cycleCount() {
        return this.clockStepper().cycleCount();
    }

    public void step(int n) {
        if (this.engine().verbose()) {
            Predef$.MODULE$.println((Object)new StringBuilder(11).append("In step at ").append(this.wallTime().currentTime()).toString());
        }
        this.clockStepper().run(n);
    }

    public int step$default$1() {
        return 1;
    }

    public void pokeMemory(String name, int index, BigInt value) {
        Option<Symbol> option = this.engine().symbolTable().get(name);
        if (!(option instanceof Some)) {
            throw new TreadleException(new StringBuilder(47).append("Error: memory ").append(name).append(".forceWrite(").append(index).append(", ").append(value).append("). memory not found").toString());
        }
        String x$1 = name;
        BigInt x$2 = value;
        int x$3 = index;
        boolean x$4 = this.engine().setValue$default$3();
        boolean x$5 = this.engine().setValue$default$4();
        this.engine().setValue(x$1, x$2, x$4, x$5, x$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BigInt peekMemory(String name, int index) {
        Option<Symbol> option = this.engine().symbolTable().get(name);
        if (!(option instanceof Some)) {
            throw new TreadleException(new StringBuilder(49).append("Error: get memory ").append(name).append(".forceWrite(").append(index).append("). memory not found").toString());
        }
        BigInt bigInt = this.engine().getValue(name, index);
        return bigInt;
    }

    public void expectMemory(String name, int index, BigInt expectedValue, String message) {
        BigInt value;
        BigInt bigInt = value = this.peekMemory(name, index);
        BigInt bigInt2 = expectedValue;
        if (bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2)) {
            ExpressionViewRenderer renderer = new ExpressionViewRenderer(this.engine().dataStore(), this.engine().symbolTable(), this.engine().expressionViews(), ExpressionViewRenderer$.MODULE$.$lessinit$greater$default$4());
            String calculation = renderer.render(this.engine().symbolTable().apply(name), this.wallTime().currentTime(), renderer.render$default$3(), renderer.render$default$4());
            throw this.fail(new TreadleException(new StringBuilder(23).append("Error:expect(").append(name).append(", ").append(expectedValue).append(") got ").append(value).append(" ").append(message).append("\n").append(calculation).toString()), this.fail$default$2());
        }
        this.expectationsMet_$eq(this.expectationsMet() + 1);
    }

    public String expectMemory$default$4() {
        return "";
    }

    public WaveformValues waveformValues(String[] symbolNames, int startCycle, int endCycle) {
        Symbol[] symbols;
        block2: {
            Symbol[] symbolArray;
            if (symbolNames.length == 0) {
                symbolArray = (Symbol[])this.engine().symbolTable().nameToSymbol().values().toArray(ClassTag$.MODULE$.apply(Symbol.class));
            } else {
                int numSymbols = symbolNames.length;
                symbolArray = symbols = new Symbol[numSymbols];
            }
            if (symbolNames.length != 0) break block2;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])symbolNames)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TreadleTester.$anonfun$waveformValues$1(this, symbols, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return this.engine().dataStore().getWaveformValues(symbols, startCycle, endCycle);
    }

    public String[] waveformValues$default$1() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    public int waveformValues$default$2() {
        return 0;
    }

    public int waveformValues$default$3() {
        return -1;
    }

    public WaveformValues allWaveformValues() {
        return this.engine().dataStore().getWaveformValues((Symbol[])this.engine().symbolTable().nameToSymbol().values().toArray(ClassTag$.MODULE$.apply(Symbol.class)), this.engine().dataStore().getWaveformValues$default$2(), this.engine().dataStore().getWaveformValues$default$3());
    }

    public String dependencyInfo(String symbolName) {
        String x$1 = symbolName;
        boolean x$2 = false;
        String x$3 = this.engine().renderComputation$default$2();
        return this.engine().renderComputation(x$1, x$3, x$2);
    }

    public boolean isRegister(String symbolName) {
        return this.engine().symbolTable().isRegister(symbolName);
    }

    public Option<Object> getStopResult() {
        return this.engine().lastStopResult();
    }

    public String reportString() {
        long endTime = System.nanoTime();
        double elapsedSeconds = (double)(endTime - this.startTime()) / 1.0E9;
        Long arg$macro$1 = BoxesRunTime.boxToLong((long)this.cycleCount());
        double arg$macro$2 = elapsedSeconds;
        double arg$macro$3 = (double)this.cycleCount() / elapsedSeconds;
        return new StringBuilder(21).append("test ").append(this.engine().ast().main()).append(" ").append(this.status$1()).append(" ").append(this.expectationsMet()).append(" tests passed ").append(new StringOps("in %s cycles in %.6f seconds %.2f Hz").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2), BoxesRunTime.boxToDouble((double)arg$macro$3)}))).toString();
    }

    public void report() {
        this.engine().writeVCD();
        Predef$.MODULE$.println((Object)this.reportString());
    }

    public boolean finish() {
        this.engine().writeVCD();
        return this.isOK();
    }

    public static final /* synthetic */ boolean $anonfun$writeVcd$1(Annotation x0$1) {
        Annotation annotation = x0$1;
        boolean bl = WriteVcdAnnotation$.MODULE$.equals(annotation);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$vcdShowUnderscored$1(Annotation x0$2) {
        Annotation annotation = x0$2;
        boolean bl = VcdShowUnderScoredAnnotation$.MODULE$.equals(annotation);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$callResetAtStartUp$1(Annotation x0$3) {
        Annotation annotation = x0$3;
        boolean bl = CallResetAtStartupAnnotation$.MODULE$.equals(annotation);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verbose$1(Annotation x0$4) {
        Annotation annotation = x0$4;
        boolean bl = VerboseAnnotation$.MODULE$.equals(annotation);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$waveformValues$1(TreadleTester $this, Symbol[] symbols$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String symbolName = (String)tuple2._1();
        int counter = tuple2._2$mcI$sp();
        Predef$.MODULE$.assert($this.engine().symbolTable().contains(symbolName), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("\"").append(symbolName).append("\" : argument is not an element of this circuit").toString());
        symbols$1[counter] = $this.engine().symbolTable().apply(symbolName);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String status$1() {
        boolean bl = false;
        Some some = null;
        Option<Object> option = this.engine().lastStopResult();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int n = BoxesRunTime.unboxToInt((Object)some.value());
            if (0 == n) {
                return "Stopped: Stop result 0:";
            }
        }
        if (bl) {
            int stopResult = BoxesRunTime.unboxToInt((Object)some.value());
            return new StringBuilder(21).append("Failed: Stop result ").append(stopResult).append(":").toString();
        }
        if (this.isOK()) {
            return "Success:";
        }
        String string = new StringBuilder(13).append("Failed: Code ").append(this.failCode().get()).toString();
        return string;
    }

    public TreadleTester(AnnotationSeq annotationSeq) {
        long l;
        ClockStepper clockStepper;
        package$.MODULE$.random().setSeed(BoxesRunTime.unboxToLong((Object)firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof RandomSeedAnnotation) {
                    RandomSeedAnnotation randomSeedAnnotation = (RandomSeedAnnotation)A1;
                    long seed = randomSeedAnnotation.seed();
                    object = BoxesRunTime.boxToLong((long)seed);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x1) {
                Annotation annotation = x1;
                boolean bl = annotation instanceof RandomSeedAnnotation;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.wallTime = UTC$.MODULE$.apply(UTC$.MODULE$.apply$default$1());
        this.engine = ExecutionEngine$.MODULE$.apply(annotationSeq, this.wallTime());
        this.wallTime().onTimeChange_$eq((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.engine().vcdOption().foreach((Function1 & Serializable & scala.Serializable)vcd -> {
            vcd.setTime(this.wallTime().currentTime());
            return BoxedUnit.UNIT;
        }));
        this.resetName = (String)firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof ResetNameAnnotation) {
                    ResetNameAnnotation resetNameAnnotation = (ResetNameAnnotation)A1;
                    String rn = resetNameAnnotation.symbolNames();
                    object = rn;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x2) {
                Annotation annotation = x2;
                boolean bl = annotation instanceof ResetNameAnnotation;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "reset");
        this.clockInfo = (Seq)firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Seq<ClockInfo> seq;
                A1 A1 = x3;
                if (A1 instanceof ClockInfoAnnotation) {
                    Seq<ClockInfo> cia;
                    ClockInfoAnnotation clockInfoAnnotation = (ClockInfoAnnotation)A1;
                    seq = cia = clockInfoAnnotation.clockInfoSeq();
                } else {
                    seq = function1.apply(x3);
                }
                return (B1)seq;
            }

            public final boolean isDefinedAt(Annotation x3) {
                Annotation annotation = x3;
                boolean bl = annotation instanceof ClockInfoAnnotation;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        this.writeVcd = firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TreadleTester.$anonfun$writeVcd$1(x0$1)));
        this.vcdShowUnderscored = firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TreadleTester.$anonfun$vcdShowUnderscored$1(x0$2)));
        this.callResetAtStartUp = firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).exists((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TreadleTester.$anonfun$callResetAtStartUp$1(x0$3)));
        this.topName = (String)firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof OutputFileAnnotation) {
                    OutputFileAnnotation outputFileAnnotation = (OutputFileAnnotation)A1;
                    String ofn = outputFileAnnotation.file();
                    object = ofn;
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x4) {
                Annotation annotation = x4;
                boolean bl = annotation instanceof OutputFileAnnotation;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.engine().ast().main());
        this.verbose = firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).exists((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)TreadleTester.$anonfun$verbose$1(x0$4)));
        this.stageOptions = Viewer$.MODULE$.view(annotationSeq, package$StageOptionsView$.MODULE$);
        this.startTime = System.nanoTime();
        this.clockInfoList = this.clockInfo().isEmpty() ? (this.engine().symbolTable().contains("clock") ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClockInfo[]{new ClockInfo(ClockInfo$.MODULE$.apply$default$1(), ClockInfo$.MODULE$.apply$default$2(), ClockInfo$.MODULE$.apply$default$3())})) : (this.engine().symbolTable().contains("clk") ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClockInfo[]{new ClockInfo("clk", ClockInfo$.MODULE$.apply$default$2(), ClockInfo$.MODULE$.apply$default$3())})) : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))) : this.clockInfo();
        int n = this.clockInfoList().length();
        switch (n) {
            case 0: {
                clockStepper = new NoClockStepper();
                break;
            }
            case 1: {
                ClockInfo clockInfo2 = (ClockInfo)this.clockInfoList().head();
                this.wallTime().setTime(clockInfo2.initialOffset());
                clockStepper = new SimpleSingleClockStepper(this.engine(), this.engine().dataStore(), this.engine().symbolTable().apply(clockInfo2.name()), this.engine().symbolTable().get(this.resetName()), clockInfo2.period(), clockInfo2.initialOffset(), this.wallTime());
                break;
            }
            default: {
                clockStepper = new MultiClockStepper(this.engine(), this.clockInfoList(), this.wallTime());
                break;
            }
        }
        this.clockStepper = clockStepper;
        ClockStepper clockStepper2 = this.clockStepper();
        if (clockStepper2 instanceof SimpleSingleClockStepper) {
            SimpleSingleClockStepper simpleSingleClockStepper = (SimpleSingleClockStepper)clockStepper2;
            l = simpleSingleClockStepper.clockPeriod() / 100L;
        } else if (clockStepper2 instanceof MultiClockStepper) {
            MultiClockStepper multiClockStepper = (MultiClockStepper)clockStepper2;
            l = multiClockStepper.shortestPeriod() / 100L;
        } else {
            l = 0L;
        }
        this.combinationalDelay = l;
        this.setVerbose(this.verbose());
        this.wallTime().setTime(0L);
        if (this.engine().verbose()) {
            Predef$.MODULE$.println((Object)new StringBuilder(32).append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(60)).append("\nStarting Treadle at ").append(Calendar.getInstance().getTime()).append(" WallTime: ").append(this.wallTime().currentTime()).toString());
        }
        if (this.writeVcd()) {
            this.engine().makeVCDLogger(this.stageOptions().getBuildFileName(this.topName(), (Option<String>)new Some((Object)".vcd")), this.vcdShowUnderscored());
        }
        if (this.callResetAtStartUp() && this.engine().symbolTable().contains(this.resetName())) {
            this.clockInfoList().headOption().foreach((Function1 & Serializable & scala.Serializable)clockInfo -> {
                this.reset(clockInfo.period() + clockInfo.initialOffset());
                return BoxedUnit.UNIT;
            });
        }
        this.failureTime = -1L;
        this.failCode = None$.MODULE$;
    }

    public TreadleTester(String input, HasTreadleSuite optionsManager, CircuitForm circuitForm) {
        this(TreadleCompatibilityPhase$.MODULE$.checkFormTransform(circuitForm, firrtl.package$.MODULE$.seqToAnnoSeq((Seq<Annotation>)((Seq)firrtl.package$.MODULE$.annoSeqToSeq(optionsManager.toAnnotationSeq()).$colon$plus((Object)new FirrtlSourceAnnotation(input), Seq$.MODULE$.canBuildFrom())))));
    }
}

