/*
 * Decompiled with CFR 0.152.
 */
package treadle;

import firrtl.AnnotationSeq;
import firrtl.annotations.Annotation;
import firrtl.options.Stage;
import firrtl.package$;
import java.io.File;
import java.io.Serializable;
import logger.LazyLogging;
import logger.Logger;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import treadle.TreadleTester;
import treadle.TreadleTester$;
import treadle.VcdReplaySkipEvents;
import treadle.VcdReplayTester$;
import treadle.VcdReplayVcdFile;
import treadle.executable.TreadleException;
import treadle.utils.VcdRunner;
import treadle.vcd.VCD;
import treadle.vcd.VCD$;

@ScalaSignature(bytes="\u0006\u000154AAE\n\u0001-!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003+\u0001\u0011\u00051\u0006C\u00030\u0001\u0011%\u0001\u0007C\u0004?\u0001\t\u0007I\u0011A \t\r\u0001\u0003\u0001\u0015!\u00032\u0011\u001d\t\u0005A1A\u0005\u0002\tCaA\u0012\u0001!\u0002\u0013\u0019\u0005bB$\u0001\u0005\u0004%\t\u0001\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B%\t\u000f=\u0003!\u0019!C\u0001!\"1q\u000b\u0001Q\u0001\nECQ\u0001\u0017\u0001\u0005\u0002eCQ!\u0018\u0001\u0005\u0002eCQA\u0018\u0001\u0005\u0002};QaY\n\t\u0002\u00114QAE\n\t\u0002\u0015DQA\u000b\t\u0005\u00021\u0014qBV2e%\u0016\u0004H.Y=UKN$XM\u001d\u0006\u0002)\u00059AO]3bI2,7\u0001A\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0019awnZ4fe&\u0011!e\b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0007b]:|G/\u0019;j_:\u001cV-\u001d\t\u0003K!j\u0011A\n\u0006\u0002O\u00051a-\u001b:si2L!!\u000b\u0014\u0003\u001b\u0005sgn\u001c;bi&|gnU3r\u0003\u0019a\u0014N\\5u}Q\u0011AF\f\t\u0003[\u0001i\u0011a\u0005\u0005\u0006G\t\u0001\r\u0001J\u0001\tO\u0016$\u0018J\u001c9viR\u0011\u0011\u0007\u0010\t\u0003eer!aM\u001c\u0011\u0005QJR\"A\u001b\u000b\u0005Y*\u0012A\u0002\u001fs_>$h(\u0003\u000293\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tA\u0014\u0004C\u0003>\u0007\u0001\u0007\u0011'\u0001\u0005gS2,g*Y7f\u0003-18\r\u001a$jY\u0016t\u0015-\\3\u0016\u0003E\nAB^2e\r&dWMT1nK\u0002\na\u0001^3ti\u0016\u0014X#A\"\u0011\u00055\"\u0015BA#\u0014\u00055!&/Z1eY\u0016$Vm\u001d;fe\u00069A/Z:uKJ\u0004\u0013a\u0001<dIV\t\u0011\n\u0005\u0002K\u00196\t1J\u0003\u0002H'%\u0011Qj\u0013\u0002\u0004-\u000e#\u0015\u0001\u0002<dI\u0002\n\u0011B^2e%Vtg.\u001a:\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001V\n\u0002\u000bU$\u0018\u000e\\:\n\u0005Y\u001b&!\u0003,dIJ+hN\\3s\u0003)18\r\u001a*v]:,'\u000fI\u0001\u000ei\u0016\u001cHoU;dG\u0016\u001c8/Z:\u0016\u0003i\u0003\"\u0001G.\n\u0005qK\"\u0001\u0002'p]\u001e\fA\u0002^3ti\u001a\u000b\u0017\u000e\\;sKN\f1A];o)\u0005\u0001\u0007C\u0001\rb\u0013\t\u0011\u0017D\u0001\u0003V]&$\u0018a\u0004,dIJ+\u0007\u000f\\1z)\u0016\u001cH/\u001a:\u0011\u00055\u00022C\u0001\tg!\t9'.D\u0001i\u0015\tIg%A\u0004paRLwN\\:\n\u0005-D'!C*uC\u001e,W*Y5o)\u0005!\u0007")
public class VcdReplayTester
implements LazyLogging {
    private final AnnotationSeq annotationSeq;
    private final String vcdFileName;
    private final TreadleTester tester;
    private final VCD vcd;
    private final VcdRunner vcdRunner;
    private final Logger logger;

    public static void main(String[] stringArray) {
        VcdReplayTester$.MODULE$.main(stringArray);
    }

    public static Stage stage() {
        return VcdReplayTester$.MODULE$.stage();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private String getInput(String fileName) {
        File file = new File(fileName);
        if (!file.exists() && !(file = new File(new StringBuilder(4).append(fileName).append(".fir").toString())).exists()) {
            throw new Exception(new StringBuilder(20).append("file ").append(fileName).append(" does not exist").toString());
        }
        BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
        String text = source.mkString();
        source.close();
        return text;
    }

    public String vcdFileName() {
        return this.vcdFileName;
    }

    public TreadleTester tester() {
        return this.tester;
    }

    public VCD vcd() {
        return this.vcd;
    }

    public VcdRunner vcdRunner() {
        return this.vcdRunner;
    }

    public long testSuccesses() {
        return this.vcdRunner().testSuccesses();
    }

    public long testFailures() {
        return this.vcdRunner().testFailures();
    }

    public void run() {
        this.vcdRunner().setInitialValues();
        int start = BoxesRunTime.unboxToInt((Object)package$.MODULE$.annoSeqToSeq(this.annotationSeq).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof VcdReplaySkipEvents) {
                    VcdReplaySkipEvents vcdReplaySkipEvents = (VcdReplaySkipEvents)A1;
                    int n = vcdReplaySkipEvents.count();
                    object = BoxesRunTime.boxToInteger((int)n);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x1) {
                Annotation annotation = x1;
                boolean bl = annotation instanceof VcdReplaySkipEvents;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int end = BoxesRunTime.unboxToInt((Object)package$.MODULE$.annoSeqToSeq(this.annotationSeq).collectFirst((PartialFunction)new scala.Serializable(null, start){
            public static final long serialVersionUID = 0L;
            private final int start$1;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof VcdReplaySkipEvents) {
                    VcdReplaySkipEvents vcdReplaySkipEvents = (VcdReplaySkipEvents)A1;
                    int n = vcdReplaySkipEvents.count();
                    object = BoxesRunTime.boxToInteger((int)(this.start$1 + n));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x2) {
                Annotation annotation = x2;
                boolean bl = annotation instanceof VcdReplaySkipEvents;
                return bl;
            }
            {
                this.start$1 = start$1;
            }
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.vcdRunner().events().length));
        this.vcdRunner().setNextEvent(start);
        long startTime = System.currentTimeMillis();
        while (this.vcdRunner().nextEvent() < end) {
            Predef$.MODULE$.println((Object)this.vcdRunner().eventSummary(this.vcdRunner().nextEvent()));
            this.vcdRunner().executeNextEvent();
            this.vcdRunner().testWires(this.vcdRunner().previousEvent(), false, false);
        }
        long endTime = System.currentTimeMillis();
        this.tester().finish();
        long arg$macro$1 = this.vcdRunner().eventsRun();
        Predef$.MODULE$.println((Object)new StringOps("events run:       %10d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
        long arg$macro$2 = this.vcdRunner().inputValuesSet();
        Predef$.MODULE$.println((Object)new StringOps("input values set: %10d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$2)})));
        long arg$macro$3 = this.vcdRunner().valuesTested();
        Predef$.MODULE$.println((Object)new StringOps("values tested:    %10d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$3)})));
        long arg$macro$4 = this.vcdRunner().testSuccesses();
        Predef$.MODULE$.println((Object)new StringOps("test successes:   %10d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$4)})));
        long arg$macro$5 = this.vcdRunner().testFailures();
        Predef$.MODULE$.println((Object)new StringOps("test failures:    %10d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$5)})));
        long arg$macro$6 = this.tester().cycleCount();
        Predef$.MODULE$.println((Object)new StringOps("clock cycles:     %10d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$6)})));
        double arg$macro$7 = (double)this.tester().cycleCount() / ((double)(endTime - startTime) / 1000.0);
        Predef$.MODULE$.println((Object)new StringOps("                  %10.2f Hz").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$7)})));
        double arg$macro$8 = (double)(endTime - startTime) / 1000.0;
        Predef$.MODULE$.println((Object)new StringOps("run time:         %10.2f seconds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$8)})));
    }

    public VcdReplayTester(AnnotationSeq annotationSeq) {
        this.annotationSeq = annotationSeq;
        LazyLogging.$init$(this);
        this.vcdFileName = (String)package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof VcdReplayVcdFile) {
                    VcdReplayVcdFile vcdReplayVcdFile = (VcdReplayVcdFile)A1;
                    String fileName = vcdReplayVcdFile.fileName();
                    object = fileName;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x1) {
                Annotation annotation = x1;
                boolean bl = annotation instanceof VcdReplayVcdFile;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new TreadleException("You must specify VcdFile to compare to treadle execution");
        });
        this.tester = TreadleTester$.MODULE$.apply(annotationSeq);
        this.vcd = VCD$.MODULE$.read(this.vcdFileName(), this.tester().engine().ast().main(), VCD$.MODULE$.read$default$3(), VCD$.MODULE$.read$default$4(), VCD$.MODULE$.read$default$5());
        this.vcdRunner = new VcdRunner(this.tester(), this.vcd());
    }
}

