/*
 * Decompiled with CFR 0.152.
 */
package treadle.chronometry;

import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import treadle.chronometry.Timer$;
import treadle.chronometry.TimerEvent;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005q!B\u000b\u0017\u0011\u0003Yb!B\u000f\u0017\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031\u0003bB\u0014\u0002\u0005\u0004%\t\u0001\u000b\u0005\u0007Y\u0005\u0001\u000b\u0011B\u0015\u0007\tu1\u0002!\f\u0005\u0006K\u0015!\tA\f\u0005\ba\u0015\u0001\r\u0011\"\u00012\u0011\u001d)T\u00011A\u0005\u0002YBa\u0001P\u0003!B\u0013\u0011\u0004bB\u001f\u0006\u0005\u0004%\tA\u0010\u0005\u0007+\u0016\u0001\u000b\u0011B \t\u000fY+!\u0019!C\u0001/\"1\u0001,\u0002Q\u0001\nICQ!W\u0003\u0005\u0002iCQa\\\u0003\u0005\u0002ADQA]\u0003\u0005\u0002MDQA^\u0003\u0005\u0002]DQ!_\u0003\u0005\u0002iDQ\u0001`\u0003\u0005\u0002uDQA`\u0003\u0005\u0002}\fQ\u0001V5nKJT!a\u0006\r\u0002\u0017\rD'o\u001c8p[\u0016$(/\u001f\u0006\u00023\u00059AO]3bI2,7\u0001\u0001\t\u00039\u0005i\u0011A\u0006\u0002\u0006)&lWM]\n\u0003\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001c\u0003!!VM\u001c+psQDW#A\u0015\u0011\u0005\u0001R\u0013BA\u0016\"\u0005\u0019!u.\u001e2mK\u0006IA+\u001a8U_f\"\b\u000eI\n\u0003\u000b}!\u0012a\f\t\u00039\u0015\tq!\u001a8bE2,G-F\u00013!\t\u00013'\u0003\u00025C\t9!i\\8mK\u0006t\u0017aC3oC\ndW\rZ0%KF$\"a\u000e\u001e\u0011\u0005\u0001B\u0014BA\u001d\"\u0005\u0011)f.\u001b;\t\u000fmB\u0011\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\u0002\u0011\u0015t\u0017M\u00197fI\u0002\n\u0011\u0002^5nS:<Gj\\4\u0016\u0003}\u0002B\u0001Q#H%6\t\u0011I\u0003\u0002C\u0007\u00069Q.\u001e;bE2,'B\u0001#\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\r\u0006\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002I\u001f:\u0011\u0011*\u0014\t\u0003\u0015\u0006j\u0011a\u0013\u0006\u0003\u0019j\ta\u0001\u0010:p_Rt\u0014B\u0001(\"\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\u000b\u0003C\u0001\u000fT\u0013\t!fC\u0001\u0006US6,'/\u0012<f]R\f!\u0002^5nS:<Gj\\4!\u0003)!x\u000e^1m\u000bZ,g\u000e^\u000b\u0002%\u0006YAo\u001c;bY\u00163XM\u001c;!\u0003\u0015\t\u0007\u000f\u001d7z+\tYv\f\u0006\u0002][R\u0011Q\f\u001b\t\u0003=~c\u0001\u0001B\u0003a\u001d\t\u0007\u0011MA\u0001S#\t\u0011W\r\u0005\u0002!G&\u0011A-\t\u0002\b\u001d>$\b.\u001b8h!\t\u0001c-\u0003\u0002hC\t\u0019\u0011I\\=\t\r%tA\u00111\u0001k\u0003\u0015\u0011Gn\\2l!\r\u00013.X\u0005\u0003Y\u0006\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\u0006]:\u0001\raR\u0001\u0004i\u0006<\u0017\u0001C3oiJLhi\u001c:\u0015\u0005\u001d\u000b\b\"\u00028\u0010\u0001\u00049\u0015a\u00039sKR$\u00180\u00128uef$\"a\u0012;\t\u000bU\u0004\u0002\u0019\u0001*\u0002\u000b\u0015tGO]=\u0002#A\u0014X\r\u001e;z\u000b:$(/\u001f$peR\u000bw\r\u0006\u0002Hq\")a.\u0005a\u0001\u000f\u0006q\u0001O]3uifd\u0015m\u001d;US6,GCA$|\u0011\u0015q'\u00031\u0001H\u0003\u0015\u0019G.Z1s)\u00059\u0014A\u0002:fa>\u0014H\u000fF\u0001H\u0001")
public class Timer {
    private boolean enabled = true;
    private final HashMap<String, TimerEvent> timingLog = new HashMap();
    private final TimerEvent totalEvent = new TimerEvent("Total");

    public static double TenTo9th() {
        return Timer$.MODULE$.TenTo9th();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    public HashMap<String, TimerEvent> timingLog() {
        return this.timingLog;
    }

    public TimerEvent totalEvent() {
        return this.totalEvent;
    }

    public <R> R apply(String tag, Function0<R> block) {
        Object object;
        if (this.enabled()) {
            long t0 = System.nanoTime();
            Object result = block.apply();
            long t1 = System.nanoTime();
            TimerEvent timerEvent = (TimerEvent)this.timingLog().getOrElseUpdate((Object)tag, (Function0 & java.io.Serializable & Serializable)() -> new TimerEvent(tag));
            timerEvent.events_$eq(timerEvent.events() + 1L);
            this.totalEvent().events_$eq(this.totalEvent().events() + 1L);
            long delta = t1 - t0;
            timerEvent.nanoseconds_$eq(timerEvent.nanoseconds() + delta);
            timerEvent.lastEventNanoseconds_$eq(delta);
            this.totalEvent().nanoseconds_$eq(this.totalEvent().nanoseconds() + delta);
            this.totalEvent().lastEventNanoseconds_$eq(delta);
            object = result;
        } else {
            object = block.apply();
        }
        return (R)object;
    }

    public String entryFor(String tag) {
        String string;
        Option option = this.timingLog().get((Object)tag);
        if (option instanceof Some) {
            Some some = (Some)option;
            TimerEvent entry = (TimerEvent)some.value();
            string = new StringBuilder(2).append(entry.events()).append(":").append(entry.nanoseconds()).append(":").append(entry.nanoseconds() / entry.events()).toString();
        } else {
            string = "";
        }
        return string;
    }

    public String prettyEntry(TimerEvent entry) {
        double total_seconds = (double)entry.nanoseconds() / Timer$.MODULE$.TenTo9th();
        double averageSeconds = (double)entry.nanoseconds() / (double)entry.events() / Timer$.MODULE$.TenTo9th() * 1000000.0;
        long arg$macro$1 = entry.events();
        double arg$macro$2 = total_seconds;
        double arg$macro$3 = averageSeconds;
        return new StringOps("%10d events %12.6f total seconds %12.6f average usec").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToDouble((double)arg$macro$2), BoxesRunTime.boxToDouble((double)arg$macro$3)}));
    }

    public String prettyEntryForTag(String tag) {
        String string;
        Option option = this.timingLog().get((Object)tag);
        if (option instanceof Some) {
            Some some = (Some)option;
            TimerEvent entry = (TimerEvent)some.value();
            string = this.prettyEntry(entry);
        } else {
            string = "";
        }
        return string;
    }

    public String prettyLastTime(String tag) {
        String string;
        Option option = this.timingLog().get((Object)tag);
        if (option instanceof Some) {
            Some some = (Some)option;
            TimerEvent entry = (TimerEvent)some.value();
            double lastEventSeconds = (double)entry.lastEventNanoseconds() / Timer$.MODULE$.TenTo9th();
            string = String.valueOf(BoxesRunTime.boxToDouble((double)lastEventSeconds));
        } else {
            string = "";
        }
        return string;
    }

    public void clear() {
        this.timingLog().clear();
    }

    public String report() {
        Seq sortedTags = (Seq)this.timingLog().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        String arg$macro$3 = "Total";
        String arg$macro$4 = this.prettyEntry(this.totalEvent());
        return new StringBuilder(1).append(((TraversableOnce)sortedTags.map((Function1 & java.io.Serializable & Serializable)tag -> {
            String arg$macro$1 = tag;
            String arg$macro$2 = this.prettyEntryForTag((String)tag);
            return new StringOps("%-20s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2}));
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n").append(new StringOps("%-20s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3, arg$macro$4}))).toString();
    }
}

