/*
 * Decompiled with CFR 0.152.
 */
package treadle.executable;

import firrtl.AnnotationSeq;
import firrtl.CircuitState;
import firrtl.annotations.Annotation;
import firrtl.ir.Circuit;
import firrtl.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import treadle.AllowCyclesAnnotation$;
import treadle.BlackBoxFactoriesAnnotation;
import treadle.PrefixPrintfWithWallTime$;
import treadle.RollBackBuffersAnnotation;
import treadle.ScalaBlackBoxFactory;
import treadle.TreadleCircuitStateAnnotation;
import treadle.TreadleDefaults$;
import treadle.ValidIfIsRandomAnnotation$;
import treadle.VerboseAnnotation$;
import treadle.chronometry.Timer;
import treadle.chronometry.Timer$;
import treadle.chronometry.UTC;
import treadle.executable.DataStore;
import treadle.executable.DataStore$;
import treadle.executable.DataStoreAllocator;
import treadle.executable.ExecutionEngine;
import treadle.executable.ExpressionCompiler;
import treadle.executable.ExpressionView;
import treadle.executable.ExpressionViewBuilder$;
import treadle.executable.Scheduler;
import treadle.executable.Symbol;
import treadle.executable.SymbolTable;
import treadle.executable.SymbolTable$;

public final class ExecutionEngine$ {
    public static ExecutionEngine$ MODULE$;
    private final String VCDHookName;

    static {
        new ExecutionEngine$();
    }

    public String VCDHookName() {
        return this.VCDHookName;
    }

    public ExecutionEngine apply(AnnotationSeq annotationSeq, UTC wallTime) {
        Timer timer = new Timer();
        long t0 = System.nanoTime();
        Circuit circuit = ((CircuitState)package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TreadleCircuitStateAnnotation) {
                    TreadleCircuitStateAnnotation treadleCircuitStateAnnotation = (TreadleCircuitStateAnnotation)A1;
                    CircuitState c = treadleCircuitStateAnnotation.state();
                    object = c;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x1) {
                Annotation annotation = x1;
                boolean bl = annotation instanceof TreadleCircuitStateAnnotation;
                return bl;
            }
        }).get()).circuit();
        Seq blackBoxFactories = (Seq)package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Seq<ScalaBlackBoxFactory> seq;
                A1 A1 = x2;
                if (A1 instanceof BlackBoxFactoriesAnnotation) {
                    Seq<ScalaBlackBoxFactory> bbf;
                    BlackBoxFactoriesAnnotation blackBoxFactoriesAnnotation = (BlackBoxFactoriesAnnotation)A1;
                    seq = bbf = blackBoxFactoriesAnnotation.blackBoxFactories();
                } else {
                    seq = function1.apply(x2);
                }
                return (B1)seq;
            }

            public final boolean isDefinedAt(Annotation x2) {
                Annotation annotation = x2;
                boolean bl = annotation instanceof BlackBoxFactoriesAnnotation;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        boolean allowCycles = package$.MODULE$.annoSeqToSeq(annotationSeq).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine$.$anonfun$apply$2(x0$1)));
        boolean prefixPrintfWithTime = package$.MODULE$.annoSeqToSeq(annotationSeq).exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine$.$anonfun$apply$3(x0$2)));
        int rollbackBuffers = BoxesRunTime.unboxToInt((Object)package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof RollBackBuffersAnnotation) {
                    RollBackBuffersAnnotation rollBackBuffersAnnotation = (RollBackBuffersAnnotation)A1;
                    int rbb = rollBackBuffersAnnotation.rollbackBufferDepth();
                    object = BoxesRunTime.boxToInteger((int)rbb);
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x3) {
                Annotation annotation = x3;
                boolean bl = annotation instanceof RollBackBuffersAnnotation;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> TreadleDefaults$.MODULE$.RollbackBuffers()));
        boolean validIfIsRandom = package$.MODULE$.annoSeqToSeq(annotationSeq).exists((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine$.$anonfun$apply$5(x0$3)));
        boolean verbose = package$.MODULE$.annoSeqToSeq(annotationSeq).exists((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine$.$anonfun$apply$6(x0$4)));
        SymbolTable symbolTable = (SymbolTable)timer.apply("Build Symbol Table", (Function0 & Serializable & scala.Serializable)() -> SymbolTable$.MODULE$.apply(circuit, (Seq<ScalaBlackBoxFactory>)blackBoxFactories, allowCycles));
        DataStoreAllocator dataStoreAllocator = new DataStoreAllocator();
        symbolTable.allocateData(dataStoreAllocator);
        DataStore dataStore = DataStore$.MODULE$.apply(rollbackBuffers, dataStoreAllocator);
        if (verbose) {
            Predef$.MODULE$.println((Object)new StringBuilder(14).append("Symbol table:\n").append(symbolTable.render()).toString());
        }
        Scheduler scheduler = new Scheduler(symbolTable);
        ExpressionCompiler compiler = new ExpressionCompiler(symbolTable, dataStore, scheduler, validIfIsRandom, prefixPrintfWithTime, (Seq<ScalaBlackBoxFactory>)blackBoxFactories);
        timer.apply("Build Compiled Expressions", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> compiler.compile(circuit, (Seq<ScalaBlackBoxFactory>)blackBoxFactories));
        Map<Symbol, ExpressionView> expressionViews = ExpressionViewBuilder$.MODULE$.getExpressionViews(symbolTable, dataStore, scheduler, validIfIsRandom, circuit, (Seq<ScalaBlackBoxFactory>)blackBoxFactories);
        scheduler.organizeAssigners();
        ExecutionEngine executionEngine = new ExecutionEngine(circuit, annotationSeq, symbolTable, dataStore, scheduler, expressionViews, wallTime);
        executionEngine.dataStore().setExecutionEngine(executionEngine);
        if (verbose) {
            Predef$.MODULE$.println((Object)new StringBuilder(1).append("\n").append(scheduler.render(executionEngine)).toString());
            scheduler.setVerboseAssign(verbose);
        }
        executionEngine.inputsChanged_$eq(true);
        long t1 = System.nanoTime();
        double total_seconds = (double)(t1 - t0) / Timer$.MODULE$.TenTo9th();
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("file loaded in ").append(total_seconds).append(" seconds, ").append(symbolTable.size()).append(" symbols, ").append(scheduler.combinationalAssigns().size()).append(" statements").toString());
        executionEngine.memoryInitializer().initializeMemoriesFromFiles();
        return executionEngine;
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Annotation x0$1) {
        Annotation annotation = x0$1;
        boolean bl = AllowCyclesAnnotation$.MODULE$.equals(annotation);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Annotation x0$2) {
        Annotation annotation = x0$2;
        boolean bl = PrefixPrintfWithWallTime$.MODULE$.equals(annotation);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(Annotation x0$3) {
        Annotation annotation = x0$3;
        boolean bl = ValidIfIsRandomAnnotation$.MODULE$.equals(annotation);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(Annotation x0$4) {
        Annotation annotation = x0$4;
        boolean bl = VerboseAnnotation$.MODULE$.equals(annotation);
        return bl;
    }

    private ExecutionEngine$() {
        MODULE$ = this;
        this.VCDHookName = "log-vcd";
    }
}

