/*
 * Decompiled with CFR 0.152.
 */
package treadle.executable;

import firrtl.AnnotationSeq;
import firrtl.Kind;
import firrtl.PortKind$;
import firrtl.annotations.Annotation;
import firrtl.ir.Circuit;
import firrtl.ir.NoInfo$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import treadle.DataStorePlugInAnnotation;
import treadle.ShowFirrtlAtLoadAnnotation$;
import treadle.SymbolsToWatchAnnotation;
import treadle.VerboseAnnotation$;
import treadle.chronometry.Timer;
import treadle.chronometry.UTC;
import treadle.executable.DataStore;
import treadle.executable.DataStorePlugin;
import treadle.executable.ExecutionEngine$;
import treadle.executable.ExpressionView;
import treadle.executable.ExpressionViewRenderer;
import treadle.executable.ExpressionViewRenderer$;
import treadle.executable.GetIntConstant;
import treadle.executable.MemoryInitializer;
import treadle.executable.RenderComputations;
import treadle.executable.ReportAssignments;
import treadle.executable.Scheduler;
import treadle.executable.StopException;
import treadle.executable.StopOp$;
import treadle.executable.Symbol;
import treadle.executable.SymbolTable;
import treadle.executable.TreadleException;
import treadle.executable.VcdHook;
import treadle.executable.package;
import treadle.package$;
import treadle.utils.Render$;
import treadle.vcd.VCD;
import treadle.vcd.VCD$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc\u0001\u0002.\\\u0001\u0001D\u0001b\u001a\u0001\u0003\u0006\u0004%\t\u0001\u001b\u0005\tc\u0002\u0011\t\u0011)A\u0005S\"A!\u000f\u0001BC\u0002\u0013\u00051\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003u\u0011!I\bA!b\u0001\n\u0003Q\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u0015\u0005\u0005\u0001A!b\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"!\u0004\u0001\u0005\u000b\u0007I\u0011AA\b\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0003\u0005\u000b\u00033\u0001!Q1A\u0005\u0002\u0005m\u0001BCA \u0001\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u0011\u0011\t\u0001\u0003\u0006\u0004%\t!a\u0011\t\u0015\u0005E\u0003A!A!\u0002\u0013\t)\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u0013\u0005\u001d\u0004A1A\u0005\u0002\u0005%\u0004\u0002CA9\u0001\u0001\u0006I!a\u001b\t\u0013\u0005M\u0004\u00011A\u0005\u0002\u0005U\u0004\"CAE\u0001\u0001\u0007I\u0011AAF\u0011!\t9\n\u0001Q!\n\u0005]\u0004\"CAM\u0001\u0001\u0007I\u0011AAN\u0011%\t\u0019\u000b\u0001a\u0001\n\u0003\t)\u000b\u0003\u0005\u0002*\u0002\u0001\u000b\u0015BAO\u0011%\tY\u000b\u0001b\u0001\n\u0003\ti\u000b\u0003\u0005\u00026\u0002\u0001\u000b\u0011BAX\u0011%\t9\f\u0001b\u0001\n\u0003\tI\f\u0003\u0005\u0002L\u0002\u0001\u000b\u0011BA^\u0011%\ti\r\u0001a\u0001\n\u0003\ty\rC\u0005\u0002X\u0002\u0001\r\u0011\"\u0001\u0002Z\"A\u0011Q\u001c\u0001!B\u0013\t\t\u000eC\u0005\u0002`\u0002\u0001\r\u0011\"\u0001\u0002P\"I\u0011\u0011\u001d\u0001A\u0002\u0013\u0005\u00111\u001d\u0005\t\u0003O\u0004\u0001\u0015)\u0003\u0002R\"I\u0011\u0011\u001e\u0001C\u0002\u0013\u0005\u00111\u001e\u0005\t\u0003\u007f\u0004\u0001\u0015!\u0003\u0002n\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u0003\u0001\u0011\u0005!q\u0001\u0005\n\u0005\u001b\u0001\u0011\u0013!C\u0001\u0005\u001fA\u0011B!\n\u0001\u0005\u0004%\tAa\n\t\u0011\t=\u0002\u0001)A\u0005\u0005SA\u0011B!\r\u0001\u0005\u0004%\tAa\r\t\u0011\tm\u0002\u0001)A\u0005\u0005kAqA!\u0010\u0001\t\u0003\u0011y\u0004C\u0004\u0003J\u0001!\tAa\u0001\t\u000f\t-\u0003\u0001\"\u0001\u0003\u0004!9!Q\n\u0001\u0005\u0002\t=\u0003\"\u0003B/\u0001E\u0005I\u0011\u0001B0\u0011%\u0011\u0019\u0007AI\u0001\n\u0003\u0011y\u0001C\u0004\u0003f\u0001!IAa\u0001\t\u000f\t\u001d\u0004\u0001\"\u0001\u0003j!I!\u0011\u0010\u0001\u0012\u0002\u0013\u0005!1\u0010\u0005\b\u0005\u007f\u0002A\u0011\u0001BA\u0011%\u0011\u0019\nAI\u0001\n\u0003\u0011y\u0001C\u0005\u0003\u0016\u0002\t\n\u0011\"\u0001\u0003\u0010!I!q\u0013\u0001\u0012\u0002\u0013\u0005!1\u0010\u0005\b\u00053\u0003A\u0011\u0001BN\u0011\u001d\u0011\u0019\u000b\u0001C\u0001\u0005KCqA!+\u0001\t\u0003\tY\u000fC\u0004\u0003,\u0002!\t!a;\t\u000f\t5\u0006\u0001\"\u0001\u0002l\"9!q\u0016\u0001\u0005\u0002\tE\u0006b\u0002B[\u0001\u0011\u0005!q\u0017\u0005\b\u0005w\u0003A\u0011\u0001B_\u0011\u001d\u0011)\r\u0001C\u0001\u0005\u000fDqAa3\u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003N\u0002!\tAa4\t\u0013\tm\u0007A1A\u0005\n\tu\u0007\u0002\u0003Bq\u0001\u0001\u0006IAa8\t\u000f\t\r\b\u0001\"\u0001\u0003f\"9!\u0011\u001e\u0001\u0005\u0002\u0005=\u0007b\u0002Bv\u0001\u0011\u0005\u00111\u0014\u0005\b\u0005[\u0004A\u0011AAN\u0011\u001d\u0011y\u000f\u0001C\u0001\u00037CqA!=\u0001\t\u0003\tY\nC\u0004\u0003t\u0002!\t!a'\u0007\u0013\tU\b\u0001%A\u0002\u0002\t]\bb\u0002B}\u0019\u0012\u0005!1\u0001\u0005\b\u0005wdE\u0011\u0001B\u0002\u0011\u001d\u0011i\u0010\u0014C\u0001\u0005\u00071aAa@\u0001\u0001\r\u0005\u0001bBA*!\u0012\u00051q\u0001\u0005\b\u0007\u0017\u0001A\u0011AB\u0007\u0011\u001d\u0019i\u0002\u0001C\u0001\u0007?9qaa\t\\\u0011\u0003\u0019)C\u0002\u0004[7\"\u00051q\u0005\u0005\b\u0003'*F\u0011AB\u0015\u0011%\u0019Y#\u0016b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u0004>U\u0003\u000b\u0011BB\u0018\u0011\u001d\u0019y$\u0016C\u0001\u0007\u0003\u0012q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u00039v\u000b!\"\u001a=fGV$\u0018M\u00197f\u0015\u0005q\u0016a\u0002;sK\u0006$G.Z\u0002\u0001'\t\u0001\u0011\r\u0005\u0002cK6\t1MC\u0001e\u0003\u0015\u00198-\u00197b\u0013\t17M\u0001\u0004B]f\u0014VMZ\u0001\u0004CN$X#A5\u0011\u0005)|W\"A6\u000b\u00051l\u0017AA5s\u0015\u0005q\u0017A\u00024jeJ$H.\u0003\u0002qW\n91)\u001b:dk&$\u0018\u0001B1ti\u0002\nQ\"\u00198o_R\fG/[8o'\u0016\fX#\u0001;\u0011\u0005U4X\"A7\n\u0005]l'!D!o]>$\u0018\r^5p]N+\u0017/\u0001\bb]:|G/\u0019;j_:\u001cV-\u001d\u0011\u0002\u0017MLXNY8m)\u0006\u0014G.Z\u000b\u0002wB\u0011A0`\u0007\u00027&\u0011ap\u0017\u0002\f'fl'm\u001c7UC\ndW-\u0001\u0007ts6\u0014w\u000e\u001c+bE2,\u0007%A\u0005eCR\f7\u000b^8sKV\u0011\u0011Q\u0001\t\u0004y\u0006\u001d\u0011bAA\u00057\nIA)\u0019;b'R|'/Z\u0001\u000bI\u0006$\u0018m\u0015;pe\u0016\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\t\t\u0002E\u0002}\u0003'I1!!\u0006\\\u0005%\u00196\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\nq\"\u001a=qe\u0016\u001c8/[8o-&,wo]\u000b\u0003\u0003;\u0001\u0002\"a\b\u0002.\u0005M\u0012\u0011\b\b\u0005\u0003C\tI\u0003E\u0002\u0002$\rl!!!\n\u000b\u0007\u0005\u001dr,\u0001\u0004=e>|GOP\u0005\u0004\u0003W\u0019\u0017A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"aA'ba*\u0019\u00111F2\u0011\u0007q\f)$C\u0002\u00028m\u0013aaU=nE>d\u0007c\u0001?\u0002<%\u0019\u0011QH.\u0003\u001d\u0015C\bO]3tg&|gNV5fo\u0006\u0001R\r\u001f9sKN\u001c\u0018n\u001c8WS\u0016<8\u000fI\u0001\to\u0006dG\u000eV5nKV\u0011\u0011Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J/\u0002\u0017\rD'o\u001c8p[\u0016$(/_\u0005\u0005\u0003\u001f\nIEA\u0002V)\u000e\u000b\u0011b^1mYRKW.\u001a\u0011\u0002\rqJg.\u001b;?)A\t9&!\u0017\u0002\\\u0005u\u0013qLA1\u0003G\n)\u0007\u0005\u0002}\u0001!)qm\u0004a\u0001S\")!o\u0004a\u0001i\")\u0011p\u0004a\u0001w\"9\u0011\u0011A\bA\u0002\u0005\u0015\u0001bBA\u0007\u001f\u0001\u0007\u0011\u0011\u0003\u0005\b\u00033y\u0001\u0019AA\u000f\u0011\u001d\t\te\u0004a\u0001\u0003\u000b\n!cY=dY\u0016$\u0016.\\3J]\u000e\u0014X-\\3oiV\u0011\u00111\u000e\t\u0004E\u00065\u0014bAA8G\n\u0019\u0011J\u001c;\u0002'\rL8\r\\3US6,\u0017J\\2sK6,g\u000e\u001e\u0011\u0002\u0013Y\u001cGm\u00149uS>tWCAA<!\u0015\u0011\u0017\u0011PA?\u0013\r\tYh\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!^\u0003\r18\rZ\u0005\u0005\u0003\u000f\u000b\tIA\u0002W\u0007\u0012\u000bQB^2e\u001fB$\u0018n\u001c8`I\u0015\fH\u0003BAG\u0003'\u00032AYAH\u0013\r\t\tj\u0019\u0002\u0005+:LG\u000fC\u0005\u0002\u0016N\t\t\u00111\u0001\u0002x\u0005\u0019\u0001\u0010J\u0019\u0002\u0015Y\u001cGm\u00149uS>t\u0007%A\u0006wG\u00124\u0015\u000e\\3OC6,WCAAO!\u0011\ty\"a(\n\t\u0005\u0005\u0016\u0011\u0007\u0002\u0007'R\u0014\u0018N\\4\u0002\u001fY\u001cGMR5mK:\u000bW.Z0%KF$B!!$\u0002(\"I\u0011Q\u0013\f\u0002\u0002\u0003\u0007\u0011QT\u0001\rm\u000e$g)\u001b7f\u001d\u0006lW\rI\u0001\u0017Kb\u0004(/Z:tS>tg+[3x%\u0016tG-\u001a:feV\u0011\u0011q\u0016\t\u0004y\u0006E\u0016bAAZ7\n1R\t\u001f9sKN\u001c\u0018n\u001c8WS\u0016<(+\u001a8eKJ,'/A\ffqB\u0014Xm]:j_:4\u0016.Z<SK:$WM]3sA\u0005Y2/_7c_2\u001c\bk\\6fINKgnY3Fm\u0006dW/\u0019;j_:,\"!a/\u0011\r\u0005u\u0016qYA\u001a\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000b\u001c\u0017AC2pY2,7\r^5p]&!\u0011\u0011ZA`\u0005\u001dA\u0015m\u001d5TKR\fAd]=nE>d7\u000fU8lK\u0012\u001c\u0016N\\2f\u000bZ\fG.^1uS>t\u0007%A\u0004wKJ\u0014wn]3\u0016\u0005\u0005E\u0007c\u00012\u0002T&\u0019\u0011Q[2\u0003\u000f\t{w\u000e\\3b]\u0006Ya/\u001a:c_N,w\fJ3r)\u0011\ti)a7\t\u0013\u0005UU$!AA\u0002\u0005E\u0017\u0001\u0003<fe\n|7/\u001a\u0011\u0002\u001b%t\u0007/\u001e;t\u0007\"\fgnZ3e\u0003EIg\u000e];ug\u000eC\u0017M\\4fI~#S-\u001d\u000b\u0005\u0003\u001b\u000b)\u000fC\u0005\u0002\u0016\u0002\n\t\u00111\u0001\u0002R\u0006q\u0011N\u001c9viN\u001c\u0005.\u00198hK\u0012\u0004\u0013AD:z[\n|Gn\u001d+p/\u0006$8\r[\u000b\u0003\u0003[\u0004b!a<\u0002z\u0006ue\u0002BAy\u0003ktA!a\t\u0002t&\tA-C\u0002\u0002x\u000e\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002|\u0006u(aA*fc*\u0019\u0011q_2\u0002\u001fMLXNY8mgR{w+\u0019;dQ\u0002\n1b]3u\u0019\u0016\fg.T8eKR\u0011\u0011QR\u0001\u000bg\u0016$h+\u001a:c_N,G\u0003BAG\u0005\u0013A\u0011Ba\u0003&!\u0003\u0005\r!!5\u0002\u0013%\u001ch+\u001a:c_N,\u0017\u0001F:fiZ+'OY8tK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0012)\"\u0011\u0011\u001bB\nW\t\u0011)\u0002\u0005\u0003\u0003\u0018\t\u0005RB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0010G\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\"\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u0002;j[\u0016\u0014XC\u0001B\u0015!\u0011\t9Ea\u000b\n\t\t5\u0012\u0011\n\u0002\u0006)&lWM]\u0001\u0007i&lWM\u001d\u0011\u0002#5,Wn\u001c:z\u0013:LG/[1mSj,'/\u0006\u0002\u00036A\u0019APa\u000e\n\u0007\te2LA\tNK6|'/_%oSRL\u0017\r\\5{KJ\f!#\\3n_JL\u0018J\\5uS\u0006d\u0017N_3sA\u0005iQ.Y6f-\u000e#Ej\\4hKJ$b!!$\u0003B\t\u0015\u0003b\u0002B\"W\u0001\u0007\u0011QT\u0001\tM&dWMT1nK\"9!qI\u0016A\u0002\u0005E\u0017aD:i_^,f\u000eZ3sg\u000e|'/\u001a3\u0002\u0015\u0011L7/\u00192mKZ\u001bE)\u0001\u0005xe&$XMV\"E\u0003E\u0011XM\u001c3fe\u000e{W\u000e];uCRLwN\u001c\u000b\t\u0003;\u0013\tF!\u0016\u0003Z!9!1\u000b\u0018A\u0002\u0005u\u0015aC:z[\n|GNT1nKND\u0011Ba\u0016/!\u0003\u0005\r!!(\u0002\u0019=,H\u000f];u\r>\u0014X.\u0019;\t\u0013\tmc\u0006%AA\u0002\u0005E\u0017AC:i_^4\u0016\r\\;fg\u0006Y\"/\u001a8eKJ\u001cu.\u001c9vi\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uII*\"A!\u0019+\t\u0005u%1C\u0001\u001ce\u0016tG-\u001a:D_6\u0004X\u000f^1uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0002\u0015I,h.Q:tS\u001et7/\u0001\u0005hKR4\u0016\r\\;f)\u0019\u0011YG!\u001d\u0003vA!\u0011q\u001eB7\u0013\u0011\u0011y'!@\u0003\r\tKw-\u00138u\u0011\u001d\u0011\u0019H\ra\u0001\u0003;\u000bAA\\1nK\"I!q\u000f\u001a\u0011\u0002\u0003\u0007\u00111N\u0001\u0007_\u001a47/\u001a;\u0002%\u001d,GOV1mk\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005{RC!a\u001b\u0003\u0014\u0005A1/\u001a;WC2,X\r\u0006\u0007\u0003l\t\r%Q\u0011BE\u0005\u001b\u0013\t\nC\u0004\u0003tQ\u0002\r!!(\t\u000f\t\u001dE\u00071\u0001\u0003l\u0005)a/\u00197vK\"I!1\u0012\u001b\u0011\u0002\u0003\u0007\u0011\u0011[\u0001\u0006M>\u00148-\u001a\u0005\n\u0005\u001f#\u0004\u0013!a\u0001\u0003#\fAB]3hSN$XM\u001d)pW\u0016D\u0011Ba\u001e5!\u0003\u0005\r!a\u001b\u0002%M,GOV1mk\u0016$C-\u001a4bk2$HeM\u0001\u0013g\u0016$h+\u00197vK\u0012\"WMZ1vYR$C'\u0001\ntKR4\u0016\r\\;fI\u0011,g-Y;mi\u0012*\u0014aC:fi&sGOV1mk\u0016$b!a\u001b\u0003\u001e\n\u0005\u0006b\u0002BPq\u0001\u0007\u00111G\u0001\u0007gfl'm\u001c7\t\u000f\t\u001d\u0005\b1\u0001\u0002l\u0005Q\u0011n\u001d*fO&\u001cH/\u001a:\u0015\t\u0005E'q\u0015\u0005\b\u0005gJ\u0004\u0019AAO\u0003A9W\r\u001e*fO&\u001cH/\u001a:OC6,7/A\u0007hKRLe\u000e];u!>\u0014Ho]\u0001\u000fO\u0016$x*\u001e;qkR\u0004vN\u001d;t\u0003-I7/\u00138qkR\u0004vN\u001d;\u0015\t\u0005E'1\u0017\u0005\b\u0005gj\u0004\u0019AAO\u00031I7oT;uaV$\bk\u001c:u)\u0011\t\tN!/\t\u000f\tMd\b1\u0001\u0002\u001e\u0006Qa/\u00197jI:\u000bW.Z:\u0016\u0005\t}\u0006CBAx\u0005\u0003\fi*\u0003\u0003\u0003D\u0006u(\u0001C%uKJ\f'\r\\3\u0002\u000fMLXNY8mgV\u0011!\u0011\u001a\t\u0007\u0003_\u0014\t-a\r\u0002\u001f\u00154\u0018\r\\;bi\u0016\u001c\u0015N]2vSR\f1\"\u00193wC:\u001cW\rV5nKR!\u0011Q\u0012Bi\u0011\u001d\u0011\u0019N\u0011a\u0001\u0005+\f\u0011\"\u001b8de\u0016lWM\u001c;\u0011\u0007\t\u00149.C\u0002\u0003Z\u000e\u0014A\u0001T8oO\u0006)2\u000f^8q\u0011\u0006\u0004\b/\u001a8fINKXNY8m\u001fB$XC\u0001Bp!\u0015\u0011\u0017\u0011PA\u001a\u0003Y\u0019Ho\u001c9ICB\u0004XM\\3e'fl'm\u001c7PaR\u0004\u0013A\u00047bgR\u001cFo\u001c9SKN,H\u000e^\u000b\u0003\u0005O\u0004RAYA=\u0003W\nqa\u001d;paB,G-\u0001\u0007gS\u0016dGm\u001d%fC\u0012,'/\u0001\u0004iK\u0006$WM]\u0001\u000eI\u0006$\u0018-\u00138D_2,XN\\:\u0002\u001b\u001d,G/\u00138g_N#(/\u001b8h\u0003=9W\r\u001e)sKR$\u0018p\u0015;sS:<'aC\"m_\u000e\\Gk\\4hY\u0016\u001c\"\u0001T1\u0002\r\u0011Jg.\u001b;%\u0003)\u0011\u0018-[:f\u00072|7m[\u0001\u000bY><XM]\"m_\u000e\\'a\u0003(vY2$vnZ4mKJ\u001cB\u0001U1\u0004\u0004A\u00191Q\u0001'\u000e\u0003\u0001!\"a!\u0003\u0011\u0007\r\u0015\u0001+A\u0007nC.,W\u000b\u001d+pO\u001edWM\u001d\u000b\u0005\u0007\u001f\u0019Y\u0002\u0005\u0003\u0004\u0012\rUab\u0001?\u0004\u0014%\u0019\u0011q_.\n\t\r]1\u0011\u0004\u0002\t\u0003N\u001c\u0018n\u001a8fe*\u0019\u0011q_.\t\u000f\t}%\u000b1\u0001\u00024\u0005yQ.Y6f\t><h\u000eV8hO2,'\u000f\u0006\u0003\u0004\u0010\r\u0005\u0002b\u0002BP'\u0002\u0007\u00111G\u0001\u0010\u000bb,7-\u001e;j_:,enZ5oKB\u0011A0V\n\u0003+\u0006$\"a!\n\u0002\u0017Y\u001bE\tS8pW:\u000bW.Z\u000b\u0003\u0007_\u0001Ba!\r\u0004<5\u001111\u0007\u0006\u0005\u0007k\u00199$\u0001\u0003mC:<'BAB\u001d\u0003\u0011Q\u0017M^1\n\t\u0005\u000561G\u0001\r-\u000e#\u0005j\\8l\u001d\u0006lW\rI\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003/\u001a\u0019e!\u0012\t\u000bIL\u0006\u0019\u0001;\t\u000f\u0005\u0005\u0013\f1\u0001\u0002F\u0001")
public class ExecutionEngine {
    private final Circuit ast;
    private final AnnotationSeq annotationSeq;
    private final SymbolTable symbolTable;
    private final DataStore dataStore;
    private final Scheduler scheduler;
    private final Map<Symbol, ExpressionView> expressionViews;
    private final UTC wallTime;
    private final int cycleTimeIncrement;
    private Option<VCD> vcdOption;
    private String vcdFileName;
    private final ExpressionViewRenderer expressionViewRenderer;
    private final HashSet<Symbol> symbolsPokedSinceEvaluation;
    private boolean verbose;
    private boolean inputsChanged;
    private final Seq<String> symbolsToWatch;
    private final Timer timer;
    private final MemoryInitializer memoryInitializer;
    private final Option<Symbol> stopHappenedSymbolOpt;

    public static ExecutionEngine apply(AnnotationSeq annotationSeq, UTC uTC) {
        return ExecutionEngine$.MODULE$.apply(annotationSeq, uTC);
    }

    public static String VCDHookName() {
        return ExecutionEngine$.MODULE$.VCDHookName();
    }

    public Circuit ast() {
        return this.ast;
    }

    public AnnotationSeq annotationSeq() {
        return this.annotationSeq;
    }

    public SymbolTable symbolTable() {
        return this.symbolTable;
    }

    public DataStore dataStore() {
        return this.dataStore;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Map<Symbol, ExpressionView> expressionViews() {
        return this.expressionViews;
    }

    public UTC wallTime() {
        return this.wallTime;
    }

    public int cycleTimeIncrement() {
        return this.cycleTimeIncrement;
    }

    public Option<VCD> vcdOption() {
        return this.vcdOption;
    }

    public void vcdOption_$eq(Option<VCD> x$1) {
        this.vcdOption = x$1;
    }

    public String vcdFileName() {
        return this.vcdFileName;
    }

    public void vcdFileName_$eq(String x$1) {
        this.vcdFileName = x$1;
    }

    public ExpressionViewRenderer expressionViewRenderer() {
        return this.expressionViewRenderer;
    }

    public HashSet<Symbol> symbolsPokedSinceEvaluation() {
        return this.symbolsPokedSinceEvaluation;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    public boolean inputsChanged() {
        return this.inputsChanged;
    }

    public void inputsChanged_$eq(boolean x$1) {
        this.inputsChanged = x$1;
    }

    public Seq<String> symbolsToWatch() {
        return this.symbolsToWatch;
    }

    public void setLeanMode() {
        boolean canBeLean = !this.verbose() && !this.dataStore().hasEnabledPlugins();
        this.scheduler().setLeanMode(canBeLean);
        this.scheduler().setVerboseAssign(this.verbose());
    }

    public void setVerbose(boolean isVerbose) {
        None$ none$;
        this.verbose_$eq(isVerbose);
        this.setLeanMode();
        Option option = this.dataStore().plugins().get((Object)"show-assigns");
        if (option instanceof Some) {
            Some some = (Some)option;
            DataStorePlugin plugin = (DataStorePlugin)some.value();
            plugin.setEnabled(this.verbose());
            none$ = BoxedUnit.UNIT;
        } else {
            none$ = None$.MODULE$;
        }
        this.scheduler().setVerboseAssign(isVerbose);
    }

    public boolean setVerbose$default$1() {
        return true;
    }

    public Timer timer() {
        return this.timer;
    }

    public MemoryInitializer memoryInitializer() {
        return this.memoryInitializer;
    }

    public void makeVCDLogger(String fileName, boolean showUnderscored) {
        String x$1 = this.ast().main();
        boolean x$2 = showUnderscored;
        String x$3 = VCD$.MODULE$.apply$default$2();
        String x$4 = VCD$.MODULE$.apply$default$3();
        VCD vcd = VCD$.MODULE$.apply(x$1, x$3, x$4, x$2);
        this.symbolTable().instanceNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            ExecutionEngine.$anonfun$makeVCDLogger$1(vcd, name);
            return BoxedUnit.UNIT;
        });
        vcd.timeStamp_$eq(-1L);
        this.symbolTable().symbols().foreach((Function1 & Serializable & scala.Serializable)symbol -> BoxesRunTime.boxToBoolean((boolean)vcd.wireChanged(symbol.name(), this.dataStore().apply(symbol), symbol.bitWidth())));
        vcd.timeStamp_$eq(0L);
        this.vcdOption_$eq((Option<VCD>)new Some((Object)vcd));
        this.vcdFileName_$eq(fileName);
        VcdHook vcdPlugIn = new VcdHook(this);
        this.dataStore().addPlugin(ExecutionEngine$.MODULE$.VCDHookName(), vcdPlugIn, true);
    }

    public void disableVCD() {
        this.writeVCD();
        this.vcdOption_$eq((Option<VCD>)None$.MODULE$);
        this.vcdFileName_$eq("");
        this.dataStore().removePlugin(ExecutionEngine$.MODULE$.VCDHookName());
    }

    public void writeVCD() {
        this.vcdOption().foreach((Function1 & Serializable & scala.Serializable)vcd -> {
            vcd.write(this.vcdFileName());
            return BoxedUnit.UNIT;
        });
    }

    public String renderComputation(String symbolNames, String outputFormat, boolean showValues) {
        ExpressionViewRenderer renderer = new ExpressionViewRenderer(this.dataStore(), this.symbolTable(), this.expressionViews(), ExpressionViewRenderer$.MODULE$.$lessinit$greater$default$4());
        Symbol[] symbols = (Symbol[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])symbolNames.split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).flatMap((Function1 & Serializable & scala.Serializable)s -> Option$.MODULE$.option2Iterable(this.symbolTable().get((String)s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Symbol.class))))).distinct();
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])symbols)).flatMap((Function1 & Serializable & scala.Serializable)symbol -> {
            Option option = this.expressionViews().get(symbol);
            Iterable iterable = option instanceof Some ? Option$.MODULE$.option2Iterable((Option)new Some((Object)String.valueOf(renderer.render((Symbol)symbol, this.wallTime().currentTime(), outputFormat, showValues)))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    public String renderComputation$default$2() {
        return "d";
    }

    public boolean renderComputation$default$3() {
        return true;
    }

    private void runAssigns() {
        try {
            this.scheduler().executeCombinationalAssigns();
            this.dataStore().saveData(this.wallTime().currentTime());
            if (this.lastStopResult().isDefined()) {
                this.writeVCD();
                String stopKind = BoxesRunTime.unboxToInt((Object)this.lastStopResult().get()) > 0 ? "Failure Stop" : "Stopped";
                throw new StopException(new StringBuilder(9).append(stopKind).append(": result ").append(this.lastStopResult().get()).toString());
            }
        }
        catch (Throwable throwable) {
            this.writeVCD();
            throw throwable;
        }
    }

    public BigInt getValue(String name, int offset) {
        BigInt bigInt;
        Predef$.MODULE$.assert(this.symbolTable().contains(name), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Error: getValue(\"").append(name).append("\") : argument is not an element of this circuit").toString());
        if (this.inputsChanged()) {
            if (this.verbose()) {
                Render$.MODULE$.headerBar("peeking", 8, Render$.MODULE$.headerBar$default$3());
            }
            this.inputsChanged_$eq(false);
            this.runAssigns();
        }
        Symbol symbol = this.symbolTable().apply(name);
        if (offset == 0) {
            bigInt = symbol.normalize(this.dataStore().apply(symbol));
        } else {
            if (offset - 1 > symbol.slots()) {
                throw new TreadleException(new StringBuilder(36).append("get value from ").append(symbol.name()).append(" offset ").append(offset).append(" > than size ").append(symbol.slots()).toString());
            }
            bigInt = symbol.normalize(this.dataStore().getValueAtIndex(symbol.dataSize(), symbol.index() + offset));
        }
        return bigInt;
    }

    public int getValue$default$2() {
        return 0;
    }

    public BigInt setValue(String name, BigInt value, boolean force, boolean registerPoke, int offset) {
        HashSet hashSet;
        Symbol symbol = this.symbolTable().getOrElse(name, (Function0<Symbol>)(Function0 & Serializable & scala.Serializable)() -> {
            throw new TreadleException(new StringBuilder(38).append("setValue: Cannot find ").append(name).append(" in symbol table").toString());
        });
        this.inputsChanged_$eq(true);
        if (this.symbolsPokedSinceEvaluation().contains((Object)symbol)) {
            if (this.verbose()) {
                Predef$.MODULE$.println((Object)"updating circuit on second update of same input without clock advance");
            }
            this.symbolsPokedSinceEvaluation().clear();
            this.scheduler().executeCombinationalAssigns();
            hashSet = BoxedUnit.UNIT;
        } else {
            hashSet = this.symbolsPokedSinceEvaluation().$plus$eq((Object)symbol);
        }
        if (!force) {
            Kind kind = symbol.dataKind();
            PortKind$ portKind$ = PortKind$.MODULE$;
            Predef$.MODULE$.assert(!(kind != null ? !kind.equals(portKind$) : portKind$ != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Error: setValue(").append(name).append(") not on input, use setValue(").append(name).append(", force=true) to override").toString());
            return package$.MODULE$.Big0();
        }
        BigInt adjustedValue = symbol.valueFrom(value);
        if (offset == 0) {
            if (this.verbose()) {
                if (!this.inputsChanged()) {
                    Render$.MODULE$.headerBar("Poking", Render$.MODULE$.headerBar$default$2(), Render$.MODULE$.headerBar$default$3());
                }
                Predef$.MODULE$.println((Object)new StringBuilder(4).append(symbol.name()).append(" <= ").append(value).toString());
            }
            this.dataStore().update(symbol, adjustedValue);
            this.vcdOption().foreach((Function1 & Serializable & scala.Serializable)vcd -> BoxesRunTime.boxToBoolean((boolean)vcd.wireChanged(symbol.name(), adjustedValue, symbol.bitWidth())));
        } else {
            if (offset - 1 > symbol.slots()) {
                throw new TreadleException(new StringBuilder(36).append("get value from ").append(symbol.name()).append(" offset ").append(offset).append(" > than size ").append(symbol.slots()).toString());
            }
            if (this.verbose()) {
                if (!this.inputsChanged()) {
                    Render$.MODULE$.headerBar("Poking", Render$.MODULE$.headerBar$default$2(), Render$.MODULE$.headerBar$default$3());
                }
                Predef$.MODULE$.println((Object)new StringBuilder(18).append(symbol.name()).append("(").append(offset).append(") <= ").append(value).append(" from tester").toString());
            }
            this.dataStore().setValueAtIndex(symbol.dataSize(), symbol.index() + offset, value);
        }
        return value;
    }

    public boolean setValue$default$3() {
        return true;
    }

    public boolean setValue$default$4() {
        return false;
    }

    public int setValue$default$5() {
        return 0;
    }

    public int setIntValue(Symbol symbol, int value) {
        HashSet hashSet;
        this.inputsChanged_$eq(true);
        if (this.symbolsPokedSinceEvaluation().contains((Object)symbol)) {
            if (this.verbose()) {
                Predef$.MODULE$.println((Object)"updating circuit on second update of same input without clock advance");
            }
            this.symbolsPokedSinceEvaluation().clear();
            this.scheduler().executeCombinationalAssigns();
            hashSet = BoxedUnit.UNIT;
        } else {
            hashSet = this.symbolsPokedSinceEvaluation().$plus$eq((Object)symbol);
        }
        BigInt adjustedValue = symbol.valueFrom(BigInt$.MODULE$.int2bigInt(value));
        if (this.verbose()) {
            if (!this.inputsChanged()) {
                Render$.MODULE$.headerBar("Poking", Render$.MODULE$.headerBar$default$2(), Render$.MODULE$.headerBar$default$3());
            }
            Predef$.MODULE$.println((Object)new StringBuilder(4).append(symbol.name()).append(" <= ").append(value).toString());
        }
        this.dataStore().intData()[symbol.index()] = value;
        this.vcdOption().foreach((Function1 & Serializable & scala.Serializable)vcd -> BoxesRunTime.boxToBoolean((boolean)vcd.wireChanged(symbol.name(), adjustedValue, symbol.bitWidth())));
        return value;
    }

    public boolean isRegister(String name) {
        return this.symbolTable().registerNames().contains((Object)name);
    }

    public Seq<String> getRegisterNames() {
        return this.symbolTable().registerNames().toSeq();
    }

    public Seq<String> getInputPorts() {
        return this.symbolTable().inputPortsNames().toSeq();
    }

    public Seq<String> getOutputPorts() {
        return this.symbolTable().outputPortsNames().toSeq();
    }

    public boolean isInputPort(String name) {
        return this.symbolTable().inputPortsNames().contains((Object)name);
    }

    public boolean isOutputPort(String name) {
        return this.symbolTable().outputPortsNames().contains((Object)name);
    }

    public Iterable<String> validNames() {
        return this.symbolTable().keys();
    }

    public Iterable<Symbol> symbols() {
        return this.symbolTable().symbols();
    }

    public void evaluateCircuit() {
        block2: {
            if (!this.inputsChanged()) break block2;
            this.inputsChanged_$eq(false);
            this.symbolsPokedSinceEvaluation().clear();
            if (this.verbose()) {
                Render$.MODULE$.headerBar("combinational evaluate", 8, Render$.MODULE$.headerBar$default$3());
            }
            this.runAssigns();
            if (this.verbose()) {
                Render$.MODULE$.headerBar("done combinational evaluate", 8, Render$.MODULE$.headerBar$default$3());
            }
        }
    }

    public void advanceTime(long increment) {
        block0: {
            if (increment <= 0L || !this.inputsChanged()) break block0;
            this.evaluateCircuit();
        }
    }

    private Option<Symbol> stopHappenedSymbolOpt() {
        return this.stopHappenedSymbolOpt;
    }

    public Option<Object> lastStopResult() {
        None$ none$;
        Option<Symbol> option = this.stopHappenedSymbolOpt();
        if (option instanceof Some) {
            Some some = (Some)option;
            Symbol hasStoppedSymbol = (Symbol)some.value();
            int stopValue = this.dataStore().apply(hasStoppedSymbol).toInt();
            none$ = stopValue > 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)(stopValue - 1))) : None$.MODULE$;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean stopped() {
        return this.lastStopResult().isDefined();
    }

    public String fieldsHeader() {
        return new StringBuilder(4).append("Buf ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.symbolTable().keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable & scala.Serializable)name -> {
            String s;
            String arg$macro$1 = s = (String)new StringOps(Predef$.MODULE$.augmentString(name)).takeRight(9);
            return new StringOps("%10.10s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("")).toString();
    }

    public String header() {
        return this.fieldsHeader();
    }

    public String dataInColumns() {
        String[] keys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.symbolTable().keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$);
        return new StringBuilder(2).append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(this.fieldsHeader().length())).append("\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)).map((Function1 & Serializable & scala.Serializable)name -> {
            BigInt value;
            Symbol symbol = this.symbolTable().apply((String)name);
            BigInt arg$macro$1 = value = symbol.normalize(this.dataStore().apply(this.symbolTable().apply((String)name)));
            return new StringOps(" %9.9s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("")).append("\n").append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(this.fieldsHeader().length())).toString();
    }

    public String getInfoString() {
        return "Info";
    }

    public String getPrettyString() {
        return new StringBuilder(1).append(this.header()).append("\n").append(this.dataInColumns()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public package.Assigner makeUpToggler(Symbol symbol) {
        void var2_3;
        GetIntConstant getIntConstant = new GetIntConstant(1);
        DataStore.AssignInt assigner = new DataStore.AssignInt(this.dataStore(), symbol, (Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> getIntConstant.apply(), NoInfo$.MODULE$);
        if (this.vcdOption().isDefined()) {
            assigner.setLeanMode(false);
        }
        assigner.setVerbose(this.verbose());
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public package.Assigner makeDownToggler(Symbol symbol) {
        void var2_3;
        GetIntConstant getIntConstant = new GetIntConstant(0);
        DataStore.AssignInt assigner = new DataStore.AssignInt(this.dataStore(), symbol, (Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> getIntConstant.apply(), NoInfo$.MODULE$);
        if (this.vcdOption().isDefined()) {
            assigner.setLeanMode(false);
        }
        assigner.setVerbose(this.verbose());
        return var2_3;
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Annotation x0$1) {
        Annotation annotation = x0$1;
        boolean bl = VerboseAnnotation$.MODULE$.equals(annotation);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$2(ExecutionEngine $this, DataStorePlugInAnnotation a) {
        $this.dataStore().addPlugin(a.name(), (DataStorePlugin)a.getPlugin().apply((Object)$this), true);
    }

    public static final /* synthetic */ void $anonfun$makeVCDLogger$1(VCD vcd$1, String name) {
        vcd$1.scopeRoot().addScope(name);
    }

    public ExecutionEngine(Circuit ast, AnnotationSeq annotationSeq, SymbolTable symbolTable, DataStore dataStore, Scheduler scheduler, Map<Symbol, ExpressionView> expressionViews, UTC wallTime) {
        this.ast = ast;
        this.annotationSeq = annotationSeq;
        this.symbolTable = symbolTable;
        this.dataStore = dataStore;
        this.scheduler = scheduler;
        this.expressionViews = expressionViews;
        this.wallTime = wallTime;
        this.cycleTimeIncrement = 500;
        this.vcdOption = None$.MODULE$;
        this.vcdFileName = "";
        this.expressionViewRenderer = new ExpressionViewRenderer(dataStore, symbolTable, expressionViews, ExpressionViewRenderer$.MODULE$.$lessinit$greater$default$4());
        scheduler.executionEngineOpt_$eq((Option<ExecutionEngine>)new Some((Object)this));
        if (firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = ShowFirrtlAtLoadAnnotation$.MODULE$.equals(A1) ? ShowFirrtlAtLoadAnnotation$.MODULE$ : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x1) {
                Annotation annotation = x1;
                boolean bl = ShowFirrtlAtLoadAnnotation$.MODULE$.equals(annotation);
                return bl;
            }
        }).isDefined()) {
            Predef$.MODULE$.println((Object)ast.serialize());
        }
        this.symbolsPokedSinceEvaluation = new HashSet();
        this.verbose = false;
        this.setVerbose(firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$new$1(x0$1))));
        this.inputsChanged = false;
        dataStore.addPlugin("show-assigns", new ReportAssignments(this), this.verbose());
        this.symbolsToWatch = (Seq)firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Seq<String> seq;
                A1 A1 = x2;
                if (A1 instanceof SymbolsToWatchAnnotation) {
                    Seq<String> stw;
                    SymbolsToWatchAnnotation symbolsToWatchAnnotation = (SymbolsToWatchAnnotation)A1;
                    seq = stw = symbolsToWatchAnnotation.symbolNames();
                } else {
                    seq = function1.apply(x2);
                }
                return (B1)seq;
            }

            public final boolean isDefinedAt(Annotation x2) {
                Annotation annotation = x2;
                boolean bl = annotation instanceof SymbolsToWatchAnnotation;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        dataStore.addPlugin("show-computation", new RenderComputations(this, this.symbolsToWatch()), this.symbolsToWatch().nonEmpty());
        ((IterableLike)firrtl.package$.MODULE$.annoSeqToSeq(annotationSeq).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof DataStorePlugInAnnotation) {
                    DataStorePlugInAnnotation dataStorePlugInAnnotation = (DataStorePlugInAnnotation)A1;
                    object = dataStorePlugInAnnotation;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Annotation x3) {
                Annotation annotation = x3;
                boolean bl = annotation instanceof DataStorePlugInAnnotation;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)a -> {
            ExecutionEngine.$anonfun$new$2(this, a);
            return BoxedUnit.UNIT;
        });
        this.timer = new Timer();
        if (this.verbose()) {
            if (scheduler.orphanedAssigns().nonEmpty()) {
                Render$.MODULE$.headerBar("Executing static assignments", 8, Render$.MODULE$.headerBar$default$3());
            } else {
                Render$.MODULE$.headerBar("No static assignments", 8, Render$.MODULE$.headerBar$default$3());
            }
        }
        scheduler.executeOrphanedAssigns();
        if (this.verbose() && scheduler.orphanedAssigns().nonEmpty()) {
            Render$.MODULE$.headerBar("Finished executing static assignments", 8, Render$.MODULE$.headerBar$default$3());
        }
        this.memoryInitializer = new MemoryInitializer(this);
        this.stopHappenedSymbolOpt = symbolTable.get(StopOp$.MODULE$.stopHappenedName());
    }

    public interface ClockToggle {
        default public void raiseClock() {
        }

        default public void lowerClock() {
        }

        public /* synthetic */ ExecutionEngine treadle$executable$ExecutionEngine$ClockToggle$$$outer();

        public static void $init$(ClockToggle $this) {
        }
    }

    public class NullToggler
    implements ClockToggle {
        @Override
        public void raiseClock() {
            ((ClockToggle)this).raiseClock();
        }

        @Override
        public void lowerClock() {
            ((ClockToggle)this).lowerClock();
        }

        public /* synthetic */ ExecutionEngine treadle$executable$ExecutionEngine$NullToggler$$$outer() {
            return ExecutionEngine.this;
        }

        @Override
        public /* synthetic */ ExecutionEngine treadle$executable$ExecutionEngine$ClockToggle$$$outer() {
            return this.treadle$executable$ExecutionEngine$NullToggler$$$outer();
        }

        public NullToggler() {
            if (ExecutionEngine.this == null) {
                throw null;
            }
            ClockToggle.$init$(this);
        }
    }
}

