/*
 * Decompiled with CFR 0.152.
 */
package treadle.executable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import treadle.chronometry.Task;
import treadle.chronometry.UTC;
import treadle.executable.ClockAssigners;
import treadle.executable.ClockInfo;
import treadle.executable.ClockStepper;
import treadle.executable.DataStore;
import treadle.executable.ExecutionEngine;
import treadle.executable.Scheduler;
import treadle.executable.Symbol;
import treadle.executable.package$Big$;

@ScalaSignature(bytes="\u0006\u0001i4A\u0001E\t\u0001-!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!)\u0004A!A!\u0002\u00131\u0004\"\u0002\u001f\u0001\t\u0003i\u0004b\u0002\"\u0001\u0005\u0004%\ta\u0011\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002#\t\u000f!\u0003!\u0019!C\u0001\u0013\"1Q\n\u0001Q\u0001\n)CqA\u0014\u0001C\u0002\u0013\u0005q\n\u0003\u0004T\u0001\u0001\u0006I\u0001\u0015\u0005\b)\u0002\u0011\r\u0011\"\u0001V\u0011\u0019I\u0006\u0001)A\u0005-\")!\f\u0001C!7\")\u0011\u000e\u0001C!U\")\u0001\u000f\u0001C!c\n\tR*\u001e7uS\u000ecwnY6Ti\u0016\u0004\b/\u001a:\u000b\u0005I\u0019\u0012AC3yK\u000e,H/\u00192mK*\tA#A\u0004ue\u0016\fG\r\\3\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tqr$D\u0001\u0012\u0013\t\u0001\u0013C\u0001\u0007DY>\u001c7n\u0015;faB,'/\u0001\u0004f]\u001eLg.\u001a\t\u0003=\rJ!\u0001J\t\u0003\u001f\u0015CXmY;uS>tWI\\4j]\u0016\fQb\u00197pG.LeNZ8MSN$\bcA\u00140e9\u0011\u0001&\f\b\u0003S1j\u0011A\u000b\u0006\u0003WU\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u00059J\u0012a\u00029bG.\fw-Z\u0005\u0003aE\u00121aU3r\u0015\tq\u0013\u0004\u0005\u0002\u001fg%\u0011A'\u0005\u0002\n\u00072|7m[%oM>\f\u0001b^1mYRKW.\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003sM\t1b\u00195s_:|W.\u001a;ss&\u00111\b\u000f\u0002\u0004+R\u001b\u0015A\u0002\u001fj]&$h\b\u0006\u0003?\u007f\u0001\u000b\u0005C\u0001\u0010\u0001\u0011\u0015\tC\u00011\u0001#\u0011\u0015)C\u00011\u0001'\u0011\u0015)D\u00011\u00017\u0003%!\u0017\r^1Ti>\u0014X-F\u0001E!\tqR)\u0003\u0002G#\tIA)\u0019;b'R|'/Z\u0001\u000bI\u0006$\u0018m\u0015;pe\u0016\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u0005Q\u0005C\u0001\u0010L\u0013\ta\u0015CA\u0005TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\u0017!\f7OU8mY\n\u000b7m[\u000b\u0002!B\u0011\u0001$U\u0005\u0003%f\u0011qAQ8pY\u0016\fg.\u0001\u0007iCN\u0014v\u000e\u001c7CC\u000e\\\u0007%\u0001\btQ>\u0014H/Z:u!\u0016\u0014\u0018n\u001c3\u0016\u0003Y\u0003\"\u0001G,\n\u0005aK\"\u0001\u0002'p]\u001e\fqb\u001d5peR,7\u000f\u001e)fe&|G\rI\u0001\nEVl\u0007o\u00117pG.$2\u0001X0e!\tAR,\u0003\u0002_3\t!QK\\5u\u0011\u0015\u0001W\u00021\u0001b\u0003-\u0019Gn\\2l'fl'm\u001c7\u0011\u0005y\u0011\u0017BA2\u0012\u0005\u0019\u0019\u00160\u001c2pY\")Q-\u0004a\u0001M\u0006)a/\u00197vKB\u0011qeZ\u0005\u0003QF\u0012aAQ5h\u0013:$\u0018a\u0001:v]R\u0011Al\u001b\u0005\u0006Y:\u0001\r!\\\u0001\u0006gR,\u0007o\u001d\t\u000319L!a\\\r\u0003\u0007%sG/A\u0004bI\u0012$\u0016m]6\u0015\u0005IDHC\u0001/t\u0011\u0015!x\u00021\u0001v\u0003\u0011!\u0018m]6\u0011\u0007a1H,\u0003\u0002x3\tIa)\u001e8di&|g\u000e\r\u0005\u0006s>\u0001\rAV\u0001\ti\u0006\u001c8\u000eV5nK\u0002")
public class MultiClockStepper
implements ClockStepper {
    private final ExecutionEngine engine;
    private final UTC wallTime;
    private final DataStore dataStore;
    private final Scheduler scheduler;
    private final boolean hasRollBack;
    private final long shortestPeriod;
    private long cycleCount;
    private final HashMap<Symbol, ClockAssigners> clockAssigners;

    @Override
    public long getCycleCount() {
        return ClockStepper.getCycleCount$(this);
    }

    @Override
    public void combinationalBump(long value) {
        ClockStepper.combinationalBump$(this, value);
    }

    @Override
    public long cycleCount() {
        return this.cycleCount;
    }

    @Override
    public void cycleCount_$eq(long x$1) {
        this.cycleCount = x$1;
    }

    @Override
    public HashMap<Symbol, ClockAssigners> clockAssigners() {
        return this.clockAssigners;
    }

    @Override
    public void treadle$executable$ClockStepper$_setter_$clockAssigners_$eq(HashMap<Symbol, ClockAssigners> x$1) {
        this.clockAssigners = x$1;
    }

    public DataStore dataStore() {
        return this.dataStore;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public boolean hasRollBack() {
        return this.hasRollBack;
    }

    public long shortestPeriod() {
        return this.shortestPeriod;
    }

    @Override
    public void bumpClock(Symbol clockSymbol, BigInt value) {
        ClockAssigners assigner = (ClockAssigners)this.clockAssigners().apply((Object)clockSymbol);
        if (value.$greater((Object)package$Big$.MODULE$.apply(0))) {
            if (this.hasRollBack()) {
                this.engine.dataStore().saveData(this.wallTime.currentTime());
            }
            assigner.upAssigner().run().apply$mcV$sp();
        } else {
            assigner.downAssigner().run().apply$mcV$sp();
        }
    }

    @Override
    public void run(int steps) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), steps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            if ($this.engine.inputsChanged()) {
                $this.engine.evaluateCircuit();
            }
            BooleanRef upTransitionProcessed = BooleanRef.create((boolean)false);
            while (!upTransitionProcessed.elem) {
                this.runHeadTask$1(upTransitionProcessed);
            }
            while (((Task)$this.wallTime.eventQueue().head()).time() == $this.wallTime.currentTime()) {
                this.runHeadTask$1(upTransitionProcessed);
            }
        });
    }

    @Override
    public void addTask(long taskTime, Function0<BoxedUnit> task) {
        this.wallTime.addOneTimeTask(taskTime, this.wallTime.addOneTimeTask$default$2(), task);
    }

    public static final /* synthetic */ void $anonfun$new$1(MultiClockStepper $this, ClockInfo clockInfo) {
        Symbol clockSymbol = $this.engine.symbolTable().apply(clockInfo.name());
        $this.wallTime.addRecurringTask(clockInfo.period(), clockInfo.initialOffset(), new StringBuilder(3).append(clockInfo.name()).append("/up").toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.cycleCount_$eq($this.cycleCount() + 1L);
            $this.engine.setValue(clockSymbol.name(), package$.MODULE$.BigInt().apply(1), $this.engine.setValue$default$3(), $this.engine.setValue$default$4(), $this.engine.setValue$default$5());
        });
        $this.wallTime.addRecurringTask(clockInfo.period(), clockInfo.initialOffset() + clockInfo.upPeriod(), new StringBuilder(5).append(clockInfo.name()).append("/down").toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.engine.setValue(clockSymbol.name(), package$.MODULE$.BigInt().apply(0), $this.engine.setValue$default$3(), $this.engine.setValue$default$4(), $this.engine.setValue$default$5()));
    }

    public static final /* synthetic */ void $anonfun$run$4(MultiClockStepper $this, BooleanRef upTransitionProcessed$1, Task taskRun) {
        block0: {
            if (!taskRun.taskName().endsWith("/up")) break block0;
            $this.cycleCount_$eq($this.cycleCount() + 1L);
            upTransitionProcessed$1.elem = true;
        }
    }

    private final void runHeadTask$1(BooleanRef upTransitionProcessed$1) {
        this.wallTime.runNextTask().foreach((Function1 & Serializable & scala.Serializable)taskRun -> {
            MultiClockStepper.$anonfun$run$4(this, upTransitionProcessed$1, taskRun);
            return BoxedUnit.UNIT;
        });
    }

    public MultiClockStepper(ExecutionEngine engine, Seq<ClockInfo> clockInfoList, UTC wallTime) {
        this.engine = engine;
        this.wallTime = wallTime;
        ClockStepper.$init$(this);
        this.dataStore = engine.dataStore();
        this.scheduler = engine.scheduler();
        this.hasRollBack = engine.dataStore().numberOfBuffers() > 0;
        this.shortestPeriod = BoxesRunTime.unboxToLong((Object)((TraversableOnce)clockInfoList.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.period()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$));
        clockInfoList.foreach((Function1 & Serializable & scala.Serializable)clockInfo -> {
            MultiClockStepper.$anonfun$new$1(this, clockInfo);
            return BoxedUnit.UNIT;
        });
    }
}

